/*
 * Decompiled with CFR 0.152.
 */
package lcmc.data;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lcmc.data.Cluster;
import lcmc.utilities.Tools;

public final class Clusters {
    private static final long serialVersionUID = 1L;
    private final Set<Cluster> clusters = new LinkedHashSet<Cluster>();
    private final ReadWriteLock mClustersLock = new ReentrantReadWriteLock();
    private final Lock mClustersReadLock = this.mClustersLock.readLock();
    private final Lock mClustersWriteLock = this.mClustersLock.writeLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addCluster(Cluster cluster) {
        this.mClustersWriteLock.lock();
        try {
            this.clusters.add(cluster);
        }
        finally {
            this.mClustersWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCluster(Cluster cluster) {
        this.mClustersWriteLock.lock();
        try {
            this.clusters.remove(cluster);
        }
        finally {
            this.mClustersWriteLock.unlock();
        }
    }

    boolean existsCluster(Cluster cluster) {
        this.mClustersReadLock.lock();
        boolean ret = this.clusters.contains(cluster);
        this.mClustersReadLock.unlock();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Cluster> getClusterSet() {
        LinkedHashSet<Cluster> copy = new LinkedHashSet<Cluster>();
        this.mClustersReadLock.lock();
        try {
            for (Cluster c : this.clusters) {
                copy.add(c);
            }
        }
        finally {
            this.mClustersReadLock.unlock();
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDefaultClusterName() {
        int index = 0;
        String defaultName = Tools.getString("Clusters.DefaultName");
        this.mClustersReadLock.lock();
        try {
            if (this.clusters != null) {
                for (Cluster cluster : this.clusters) {
                    int i;
                    String name = cluster.getName();
                    Pattern p = Pattern.compile("^" + defaultName + "(\\d+)$");
                    Matcher m = p.matcher(name);
                    if (!m.matches() || (i = Integer.parseInt(m.group(1))) <= index) continue;
                    index = i;
                }
            }
        }
        finally {
            this.mClustersReadLock.unlock();
        }
        return defaultName + Integer.toString(index + 1);
    }
}

