/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.cluster;

import edu.uci.ics.jung.graph.Graph;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.buffer.UnboundedFifoBuffer;

public class WeakComponentClusterer<V, E>
implements Transformer<Graph<V, E>, Set<Set<V>>> {
    @Override
    public Set<Set<V>> transform(Graph<V, E> graph) {
        HashSet<Set<V>> clusterSet = new HashSet<Set<V>>();
        HashSet unvisitedVertices = new HashSet(graph.getVertices());
        while (!unvisitedVertices.isEmpty()) {
            HashSet<Object> cluster = new HashSet<Object>();
            Object root = unvisitedVertices.iterator().next();
            unvisitedVertices.remove(root);
            cluster.add(root);
            UnboundedFifoBuffer<Object> queue = new UnboundedFifoBuffer<Object>();
            queue.add(root);
            while (!queue.isEmpty()) {
                Object currentVertex = queue.remove();
                Collection neighbors = graph.getNeighbors(currentVertex);
                for (Object neighbor : neighbors) {
                    if (!unvisitedVertices.contains(neighbor)) continue;
                    queue.add(neighbor);
                    unvisitedVertices.remove(neighbor);
                    cluster.add(neighbor);
                }
            }
            clusterSet.add(cluster);
        }
        return clusterSet;
    }
}

