/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout.graphelements;

import com.touchgraph.graphlayout.Edge;
import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.TGException;
import com.touchgraph.graphlayout.graphelements.GraphEltSet;
import java.util.Vector;

public class Locality
extends GraphEltSet {
    protected GraphEltSet completeEltSet;

    public Locality(GraphEltSet ges) {
        this.completeEltSet = ges;
    }

    public GraphEltSet getCompleteEltSet() {
        return this.completeEltSet;
    }

    @Override
    public synchronized void addNode(Node n) throws TGException {
        if (!this.contains(n)) {
            super.addNode(n);
            if (!this.completeEltSet.contains(n)) {
                this.completeEltSet.addNode(n);
            }
        }
    }

    @Override
    public void addEdge(Edge e) {
        if (!this.contains(e)) {
            this.edges.addElement(e);
            if (!this.completeEltSet.contains(e)) {
                this.completeEltSet.addEdge(e);
            }
        }
    }

    public synchronized void addNodeWithEdges(Node n) throws TGException {
        this.addNode(n);
        for (int i = 0; i < n.edgeCount(); ++i) {
            Edge e = n.edgeAt(i);
            if (!this.contains(e.getOtherEndpt(n))) continue;
            this.addEdge(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addAll() throws TGException {
        GraphEltSet graphEltSet = this.completeEltSet;
        synchronized (graphEltSet) {
            int i;
            for (i = 0; i < this.completeEltSet.nodeCount(); ++i) {
                this.addNode(this.completeEltSet.nodeAt(i));
            }
            for (i = 0; i < this.completeEltSet.edgeCount(); ++i) {
                this.addEdge(this.completeEltSet.edgeAt(i));
            }
        }
    }

    @Override
    public Edge findEdge(Node from, Node to) {
        Edge foundEdge = super.findEdge(from, to);
        if (foundEdge != null && this.edges.contains(foundEdge)) {
            return foundEdge;
        }
        return null;
    }

    @Override
    public boolean deleteEdge(Edge e) {
        if (e == null) {
            return false;
        }
        this.removeEdge(e);
        return this.completeEltSet.deleteEdge(e);
    }

    @Override
    public synchronized void deleteEdges(Vector edgesToDelete) {
        this.removeEdges(edgesToDelete);
        this.completeEltSet.deleteEdges(edgesToDelete);
    }

    public boolean removeEdge(Edge e) {
        if (e == null) {
            return false;
        }
        return this.edges.removeElement(e);
    }

    public synchronized void removeEdges(Vector edgesToRemove) {
        for (int i = 0; i < edgesToRemove.size(); ++i) {
            this.removeEdge((Edge)edgesToRemove.elementAt(i));
        }
    }

    @Override
    public boolean deleteNode(Node node) {
        if (node == null) {
            return false;
        }
        this.removeNode(node);
        return this.completeEltSet.deleteNode(node);
    }

    @Override
    public synchronized void deleteNodes(Vector nodesToDelete) {
        this.removeNodes(nodesToDelete);
        this.completeEltSet.deleteNodes(nodesToDelete);
    }

    public boolean removeNode(Node node) {
        if (node == null) {
            return false;
        }
        if (!this.nodes.removeElement(node)) {
            return false;
        }
        String id = node.getID();
        if (id != null) {
            this.nodeIDRegistry.remove(id);
        }
        for (int i = 0; i < node.edgeCount(); ++i) {
            this.removeEdge(node.edgeAt(i));
        }
        return true;
    }

    public synchronized void removeNodes(Vector nodesToRemove) {
        for (int i = 0; i < nodesToRemove.size(); ++i) {
            this.removeNode((Node)nodesToRemove.elementAt(i));
        }
    }

    public synchronized void removeAll() {
        super.clearAll();
    }

    @Override
    public synchronized void clearAll() {
        this.removeAll();
        this.completeEltSet.clearAll();
    }
}

