/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.math;

import cern.colt.function.IntFunction;
import cern.colt.function.IntIntFunction;
import cern.colt.function.IntIntProcedure;
import cern.colt.function.IntProcedure;
import cern.jet.math.Arithmetic;
import cern.jet.random.engine.MersenneTwister;
import java.util.Date;

public class IntFunctions {
    public static final IntFunctions intFunctions = new IntFunctions();
    public static final IntFunction abs = new IntFunction(){

        @Override
        public final int apply(int a) {
            return a < 0 ? -a : a;
        }
    };
    public static final IntFunction dec = new IntFunction(){

        @Override
        public final int apply(int a) {
            return a--;
        }
    };
    public static final IntFunction factorial = new IntFunction(){

        @Override
        public final int apply(int a) {
            return (int)Arithmetic.factorial(a);
        }
    };
    public static final IntFunction identity = new IntFunction(){

        @Override
        public final int apply(int a) {
            return a;
        }
    };
    public static final IntFunction inc = new IntFunction(){

        @Override
        public final int apply(int a) {
            return a++;
        }
    };
    public static final IntFunction neg = new IntFunction(){

        @Override
        public final int apply(int a) {
            return -a;
        }
    };
    public static final IntFunction not = new IntFunction(){

        @Override
        public final int apply(int a) {
            return ~a;
        }
    };
    public static final IntFunction sign = new IntFunction(){

        @Override
        public final int apply(int a) {
            return a < 0 ? -1 : (a > 0 ? 1 : 0);
        }
    };
    public static final IntFunction square = new IntFunction(){

        @Override
        public final int apply(int a) {
            return a * a;
        }
    };
    public static final IntIntFunction and = new IntIntFunction(){

        @Override
        public final int apply(int a, int b) {
            return a & b;
        }
    };
    public static final IntIntFunction compare = new IntIntFunction(){

        @Override
        public final int apply(int a, int b) {
            return a < b ? -1 : (a > b ? 1 : 0);
        }
    };
    public static final IntIntFunction div = new IntIntFunction(){

        @Override
        public final int apply(int a, int b) {
            return a / b;
        }
    };
    public static final IntIntFunction equals = new IntIntFunction(){

        @Override
        public final int apply(int a, int b) {
            return a == b ? 1 : 0;
        }
    };
    public static final IntIntProcedure isEqual = new IntIntProcedure(){

        @Override
        public final boolean apply(int a, int b) {
            return a == b;
        }
    };
    public static final IntIntProcedure isLess = new IntIntProcedure(){

        @Override
        public final boolean apply(int a, int b) {
            return a < b;
        }
    };
    public static final IntIntProcedure isGreater = new IntIntProcedure(){

        @Override
        public final boolean apply(int a, int b) {
            return a > b;
        }
    };
    public static final IntIntFunction max = new IntIntFunction(){

        @Override
        public final int apply(int a, int b) {
            return a >= b ? a : b;
        }
    };
    public static final IntIntFunction min = new IntIntFunction(){

        @Override
        public final int apply(int a, int b) {
            return a <= b ? a : b;
        }
    };
    public static final IntIntFunction minus = new IntIntFunction(){

        @Override
        public final int apply(int a, int b) {
            return a - b;
        }
    };
    public static final IntIntFunction mod = new IntIntFunction(){

        @Override
        public final int apply(int a, int b) {
            return a % b;
        }
    };
    public static final IntIntFunction mult = new IntIntFunction(){

        @Override
        public final int apply(int a, int b) {
            return a * b;
        }
    };
    public static final IntIntFunction or = new IntIntFunction(){

        @Override
        public final int apply(int a, int b) {
            return a | b;
        }
    };
    public static final IntIntFunction plus = new IntIntFunction(){

        @Override
        public final int apply(int a, int b) {
            return a + b;
        }
    };
    public static final IntIntFunction pow = new IntIntFunction(){

        @Override
        public final int apply(int a, int b) {
            return (int)Math.pow(a, b);
        }
    };
    public static final IntIntFunction shiftLeft = new IntIntFunction(){

        @Override
        public final int apply(int a, int b) {
            return a << b;
        }
    };
    public static final IntIntFunction shiftRightSigned = new IntIntFunction(){

        @Override
        public final int apply(int a, int b) {
            return a >> b;
        }
    };
    public static final IntIntFunction shiftRightUnsigned = new IntIntFunction(){

        @Override
        public final int apply(int a, int b) {
            return a >>> b;
        }
    };
    public static final IntIntFunction xor = new IntIntFunction(){

        @Override
        public final int apply(int a, int b) {
            return a ^ b;
        }
    };

    protected IntFunctions() {
    }

    public static IntFunction and(final int b) {
        return new IntFunction(){

            @Override
            public final int apply(int a) {
                return a & b;
            }
        };
    }

    public static IntFunction between(final int from, final int to) {
        return new IntFunction(){

            @Override
            public final int apply(int a) {
                return from <= a && a <= to ? 1 : 0;
            }
        };
    }

    public static IntFunction bindArg1(final IntIntFunction function, final int c) {
        return new IntFunction(){

            @Override
            public final int apply(int var) {
                return function.apply(c, var);
            }
        };
    }

    public static IntFunction bindArg2(final IntIntFunction function, final int c) {
        return new IntFunction(){

            @Override
            public final int apply(int var) {
                return function.apply(var, c);
            }
        };
    }

    public static IntFunction chain(final IntFunction g, final IntFunction h) {
        return new IntFunction(){

            @Override
            public final int apply(int a) {
                return g.apply(h.apply(a));
            }
        };
    }

    public static IntIntFunction chain(final IntFunction g, final IntIntFunction h) {
        return new IntIntFunction(){

            @Override
            public final int apply(int a, int b) {
                return g.apply(h.apply(a, b));
            }
        };
    }

    public static IntIntFunction chain(final IntIntFunction f, final IntFunction g, final IntFunction h) {
        return new IntIntFunction(){

            @Override
            public final int apply(int a, int b) {
                return f.apply(g.apply(a), h.apply(b));
            }
        };
    }

    public static IntFunction compare(final int b) {
        return new IntFunction(){

            @Override
            public final int apply(int a) {
                return a < b ? -1 : (a > b ? 1 : 0);
            }
        };
    }

    public static IntFunction constant(final int c) {
        return new IntFunction(){

            @Override
            public final int apply(int a) {
                return c;
            }
        };
    }

    public static IntFunction div(final int b) {
        return new IntFunction(){

            @Override
            public final int apply(int a) {
                return a / b;
            }
        };
    }

    public static IntFunction equals(final int b) {
        return new IntFunction(){

            @Override
            public final int apply(int a) {
                return a == b ? 1 : 0;
            }
        };
    }

    public static IntProcedure isBetween(final int from, final int to) {
        return new IntProcedure(){

            @Override
            public final boolean apply(int a) {
                return from <= a && a <= to;
            }
        };
    }

    public static IntProcedure isEqual(final int b) {
        return new IntProcedure(){

            @Override
            public final boolean apply(int a) {
                return a == b;
            }
        };
    }

    public static IntProcedure isGreater(final int b) {
        return new IntProcedure(){

            @Override
            public final boolean apply(int a) {
                return a > b;
            }
        };
    }

    public static IntProcedure isLess(final int b) {
        return new IntProcedure(){

            @Override
            public final boolean apply(int a) {
                return a < b;
            }
        };
    }

    public static IntFunction max(final int b) {
        return new IntFunction(){

            @Override
            public final int apply(int a) {
                return a >= b ? a : b;
            }
        };
    }

    public static IntFunction min(final int b) {
        return new IntFunction(){

            @Override
            public final int apply(int a) {
                return a <= b ? a : b;
            }
        };
    }

    public static IntFunction minus(final int b) {
        return new IntFunction(){

            @Override
            public final int apply(int a) {
                return a - b;
            }
        };
    }

    public static IntFunction mod(final int b) {
        return new IntFunction(){

            @Override
            public final int apply(int a) {
                return a % b;
            }
        };
    }

    public static IntFunction mult(final int b) {
        return new IntFunction(){

            @Override
            public final int apply(int a) {
                return a * b;
            }
        };
    }

    public static IntFunction or(final int b) {
        return new IntFunction(){

            @Override
            public final int apply(int a) {
                return a | b;
            }
        };
    }

    public static IntFunction plus(final int b) {
        return new IntFunction(){

            @Override
            public final int apply(int a) {
                return a + b;
            }
        };
    }

    public static IntFunction pow(final int b) {
        return new IntFunction(){

            @Override
            public final int apply(int a) {
                return (int)Math.pow(a, b);
            }
        };
    }

    public static IntFunction random() {
        return new MersenneTwister(new Date());
    }

    public static IntFunction shiftLeft(final int b) {
        return new IntFunction(){

            @Override
            public final int apply(int a) {
                return a << b;
            }
        };
    }

    public static IntFunction shiftRightSigned(final int b) {
        return new IntFunction(){

            @Override
            public final int apply(int a) {
                return a >> b;
            }
        };
    }

    public static IntFunction shiftRightUnsigned(final int b) {
        return new IntFunction(){

            @Override
            public final int apply(int a) {
                return a >>> b;
            }
        };
    }

    public static IntIntFunction swapArgs(final IntIntFunction function) {
        return new IntIntFunction(){

            @Override
            public final int apply(int a, int b) {
                return function.apply(b, a);
            }
        };
    }

    public static IntFunction xor(final int b) {
        return new IntFunction(){

            @Override
            public final int apply(int a) {
                return a ^ b;
            }
        };
    }
}

