/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.impl;

import cern.colt.list.DoubleArrayList;
import cern.colt.list.IntArrayList;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix1D;
import cern.colt.matrix.impl.WrapperDoubleMatrix2D;
import cern.jet.math.Functions;

class RCMDoubleMatrix2D
extends WrapperDoubleMatrix2D {
    private IntArrayList[] indexes;
    private DoubleArrayList[] values;

    public RCMDoubleMatrix2D(double[][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length);
        this.assign(values);
    }

    public RCMDoubleMatrix2D(int rows, int columns) {
        super(null);
        this.setUp(rows, columns);
        this.indexes = new IntArrayList[rows];
        this.values = new DoubleArrayList[rows];
    }

    @Override
    public DoubleMatrix2D assign(double value) {
        if (value == 0.0) {
            int row = this.rows;
            while (--row >= 0) {
                this.indexes[row] = null;
                this.values[row] = null;
            }
        } else {
            super.assign(value);
        }
        return this;
    }

    @Override
    protected DoubleMatrix2D getContent() {
        return this;
    }

    @Override
    public double getQuick(int row, int column) {
        int k = -1;
        if (this.indexes[row] != null) {
            k = this.indexes[row].binarySearch(column);
        }
        if (k < 0) {
            return 0.0;
        }
        return this.values[row].getQuick(k);
    }

    @Override
    public DoubleMatrix2D like(int rows, int columns) {
        return new RCMDoubleMatrix2D(rows, columns);
    }

    @Override
    public DoubleMatrix1D like1D(int size) {
        return new SparseDoubleMatrix1D(size);
    }

    @Override
    public void setQuick(int row, int column, double value) {
        int i = row;
        int j = column;
        int k = -1;
        IntArrayList indexList = this.indexes[i];
        if (indexList != null) {
            k = indexList.binarySearch(j);
        }
        if (k >= 0) {
            if (value == 0.0) {
                DoubleArrayList valueList = this.values[i];
                indexList.remove(k);
                valueList.remove(k);
                int s = indexList.size();
                if (s > 2 && s * 3 < indexList.elements().length) {
                    indexList.setSize(s * 3 / 2);
                    indexList.trimToSize();
                    indexList.setSize(s);
                    valueList.setSize(s * 3 / 2);
                    valueList.trimToSize();
                    valueList.setSize(s);
                }
            } else {
                this.values[i].setQuick(k, value);
            }
        } else {
            if (value == 0.0) {
                return;
            }
            k = -k - 1;
            if (indexList == null) {
                this.indexes[i] = new IntArrayList(3);
                this.values[i] = new DoubleArrayList(3);
            }
            this.indexes[i].beforeInsert(k, j);
            this.values[i].beforeInsert(k, value);
        }
    }

    protected void zMult(DoubleMatrix1D y, DoubleMatrix1D z, IntArrayList nonZeroIndexes, DoubleMatrix1D[] allRows, double alpha, double beta) {
        if (this.columns != y.size() || this.rows > z.size()) {
            throw new IllegalArgumentException("Incompatible args: " + this.toStringShort() + ", " + y.toStringShort() + ", " + z.toStringShort());
        }
        z.assign(Functions.mult(beta / alpha));
        int i = this.indexes.length;
        while (--i >= 0) {
            if (this.indexes[i] == null) continue;
            int k = this.indexes[i].size();
            while (--k >= 0) {
                int j = this.indexes[i].getQuick(k);
                double value = this.values[i].getQuick(k);
                z.setQuick(i, z.getQuick(i) + value * y.getQuick(j));
            }
        }
        z.assign(Functions.mult(alpha));
    }
}

