/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.map;

import cern.colt.map.HashFunctions;
import cern.colt.map.OpenIntIntHashMap;

class QuickOpenIntIntHashMap
extends OpenIntIntHashMap {
    public int totalProbesSaved = 0;

    public QuickOpenIntIntHashMap() {
        this(277);
    }

    public QuickOpenIntIntHashMap(int initialCapacity) {
        this(initialCapacity, 0.2, 0.5);
    }

    public QuickOpenIntIntHashMap(int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        this.setUp(initialCapacity, minLoadFactor, maxLoadFactor);
    }

    @Override
    public boolean put(int key, int value) {
        int[] tab = this.table;
        byte[] stat = this.state;
        int length = tab.length;
        int hash = HashFunctions.hash(key) & Integer.MAX_VALUE;
        int i = hash % length;
        int decrement = hash / length % length;
        if (decrement == 0) {
            decrement = 1;
        }
        int t = 0;
        int p0 = i;
        while (stat[i] == 1 && tab[i] != key) {
            ++t;
            if ((i -= decrement) >= 0) continue;
            i += length;
        }
        if (stat[i] == 1) {
            this.values[i] = value;
            return false;
        }
        if (this.distinct > this.highWaterMark) {
            int newCapacity = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
            return this.put(key, value);
        }
        while (t > 1) {
            int pc;
            int key0 = tab[p0];
            hash = HashFunctions.hash(key0) & Integer.MAX_VALUE;
            decrement = hash / length % length;
            if (decrement == 0) {
                decrement = 1;
            }
            if ((pc = p0 - decrement) < 0) {
                pc += length;
            }
            if (stat[pc] != 0) {
                p0 = pc;
                --t;
                continue;
            }
            this.totalProbesSaved += t - 1;
            tab[pc] = key0;
            stat[pc] = 1;
            this.values[pc] = this.values[p0];
            i = p0;
            t = 0;
        }
        this.table[i] = key;
        this.values[i] = value;
        if (this.state[i] == 0) {
            --this.freeEntries;
        }
        this.state[i] = 1;
        ++this.distinct;
        if (this.freeEntries < 1) {
            int newCapacity = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
        }
        return true;
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this.table.length;
        int[] oldTable = this.table;
        int[] oldValues = this.values;
        byte[] oldState = this.state;
        int[] newTable = new int[newCapacity];
        int[] newValues = new int[newCapacity];
        byte[] newState = new byte[newCapacity];
        this.lowWaterMark = this.chooseLowWaterMark(newCapacity, this.minLoadFactor);
        this.highWaterMark = this.chooseHighWaterMark(newCapacity, this.maxLoadFactor);
        this.table = newTable;
        this.values = newValues;
        this.state = newState;
        this.freeEntries = newCapacity - this.distinct;
        int tmp = this.distinct;
        this.distinct = Integer.MIN_VALUE;
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldState[i] != 1) continue;
            this.put(oldTable[i], oldValues[i]);
        }
        this.distinct = tmp;
    }
}

