/*
 * Decompiled with CFR 0.152.
 */
package jssc;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import jssc.SerialNativeInterface;
import jssc.SerialPortEvent;
import jssc.SerialPortEventListener;
import jssc.SerialPortException;
import jssc.SerialPortTimeoutException;

public class SerialPort {
    private SerialNativeInterface serialInterface;
    private SerialPortEventListener eventListener;
    private long portHandle;
    private String portName;
    private boolean portOpened = false;
    private boolean maskAssigned = false;
    private boolean eventListenerAdded = false;
    private Method methodErrorOccurred = null;
    public static final int BAUDRATE_110 = 110;
    public static final int BAUDRATE_300 = 300;
    public static final int BAUDRATE_600 = 600;
    public static final int BAUDRATE_1200 = 1200;
    public static final int BAUDRATE_4800 = 4800;
    public static final int BAUDRATE_9600 = 9600;
    public static final int BAUDRATE_14400 = 14400;
    public static final int BAUDRATE_19200 = 19200;
    public static final int BAUDRATE_38400 = 38400;
    public static final int BAUDRATE_57600 = 57600;
    public static final int BAUDRATE_115200 = 115200;
    public static final int BAUDRATE_128000 = 128000;
    public static final int BAUDRATE_256000 = 256000;
    public static final int DATABITS_5 = 5;
    public static final int DATABITS_6 = 6;
    public static final int DATABITS_7 = 7;
    public static final int DATABITS_8 = 8;
    public static final int STOPBITS_1 = 1;
    public static final int STOPBITS_2 = 2;
    public static final int STOPBITS_1_5 = 3;
    public static final int PARITY_NONE = 0;
    public static final int PARITY_ODD = 1;
    public static final int PARITY_EVEN = 2;
    public static final int PARITY_MARK = 3;
    public static final int PARITY_SPACE = 4;
    public static final int PURGE_RXABORT = 2;
    public static final int PURGE_RXCLEAR = 8;
    public static final int PURGE_TXABORT = 1;
    public static final int PURGE_TXCLEAR = 4;
    public static final int MASK_RXCHAR = 1;
    public static final int MASK_RXFLAG = 2;
    public static final int MASK_TXEMPTY = 4;
    public static final int MASK_CTS = 8;
    public static final int MASK_DSR = 16;
    public static final int MASK_RLSD = 32;
    public static final int MASK_BREAK = 64;
    public static final int MASK_ERR = 128;
    public static final int MASK_RING = 256;
    public static final int FLOWCONTROL_NONE = 0;
    public static final int FLOWCONTROL_RTSCTS_IN = 1;
    public static final int FLOWCONTROL_RTSCTS_OUT = 2;
    public static final int FLOWCONTROL_XONXOFF_IN = 4;
    public static final int FLOWCONTROL_XONXOFF_OUT = 8;
    public static final int ERROR_FRAME = 8;
    public static final int ERROR_OVERRUN = 2;
    public static final int ERROR_PARITY = 4;
    private static final int PARAMS_FLAG_IGNPAR = 1;
    private static final int PARAMS_FLAG_PARMRK = 2;
    private int linuxMask;
    private EventThread eventThread;

    public SerialPort(String string) {
        this.portName = string;
        this.serialInterface = new SerialNativeInterface();
    }

    public String getPortName() {
        return this.portName;
    }

    public boolean isOpened() {
        return this.portOpened;
    }

    public boolean openPort() throws SerialPortException {
        if (this.portOpened) {
            throw new SerialPortException(this.portName, "openPort()", "Port already opened");
        }
        if (this.portName == null) {
            throw new SerialPortException(this.portName, "openPort()", "Null not permitted");
        }
        boolean bl = System.getProperty("JSSC_NO_TIOCEXCL") == null && System.getProperty("JSSC_NO_TIOCEXCL".toLowerCase()) == null;
        this.portHandle = this.serialInterface.openPort(this.portName, bl);
        if (this.portHandle == -1L) {
            throw new SerialPortException(this.portName, "openPort()", "Port busy");
        }
        if (this.portHandle == -2L) {
            throw new SerialPortException(this.portName, "openPort()", "Port not found");
        }
        if (this.portHandle == -3L) {
            throw new SerialPortException(this.portName, "openPort()", "Permission denied");
        }
        if (this.portHandle == -4L) {
            throw new SerialPortException(this.portName, "openPort()", "Incorrect serial port");
        }
        this.portOpened = true;
        return true;
    }

    public boolean setParams(int n, int n2, int n3, int n4) throws SerialPortException {
        return this.setParams(n, n2, n3, n4, true, true);
    }

    public boolean setParams(int n, int n2, int n3, int n4, boolean bl, boolean bl2) throws SerialPortException {
        this.checkPortOpened("setParams()");
        if (n3 == 1) {
            n3 = 0;
        } else if (n3 == 3) {
            n3 = 1;
        }
        int n5 = 0;
        if (System.getProperty("JSSC_IGNPAR") != null || System.getProperty("JSSC_IGNPAR".toLowerCase()) != null) {
            n5 |= 1;
        }
        if (System.getProperty("JSSC_PARMRK") != null || System.getProperty("JSSC_PARMRK".toLowerCase()) != null) {
            n5 |= 2;
        }
        return this.serialInterface.setParams(this.portHandle, n, n2, n3, n4, bl, bl2, n5);
    }

    public boolean purgePort(int n) throws SerialPortException {
        this.checkPortOpened("purgePort()");
        return this.serialInterface.purgePort(this.portHandle, n);
    }

    public boolean setEventsMask(int n) throws SerialPortException {
        this.checkPortOpened("setEventsMask()");
        if (SerialNativeInterface.getOsType() == 0 || SerialNativeInterface.getOsType() == 2 || SerialNativeInterface.getOsType() == 3) {
            this.linuxMask = n;
            this.maskAssigned = n > 0;
            return true;
        }
        boolean bl = this.serialInterface.setEventsMask(this.portHandle, n);
        if (!bl) {
            throw new SerialPortException(this.portName, "setEventsMask()", "Can't set mask");
        }
        this.maskAssigned = n > 0;
        return bl;
    }

    public int getEventsMask() throws SerialPortException {
        this.checkPortOpened("getEventsMask()");
        if (SerialNativeInterface.getOsType() == 0 || SerialNativeInterface.getOsType() == 2 || SerialNativeInterface.getOsType() == 3) {
            return this.linuxMask;
        }
        return this.serialInterface.getEventsMask(this.portHandle);
    }

    private int getLinuxMask() {
        return this.linuxMask;
    }

    public boolean setRTS(boolean bl) throws SerialPortException {
        this.checkPortOpened("setRTS()");
        return this.serialInterface.setRTS(this.portHandle, bl);
    }

    public boolean setDTR(boolean bl) throws SerialPortException {
        this.checkPortOpened("setDTR()");
        return this.serialInterface.setDTR(this.portHandle, bl);
    }

    public boolean writeBytes(byte[] byArray) throws SerialPortException {
        this.checkPortOpened("writeBytes()");
        return this.serialInterface.writeBytes(this.portHandle, byArray);
    }

    public boolean writeByte(byte by) throws SerialPortException {
        this.checkPortOpened("writeByte()");
        return this.writeBytes(new byte[]{by});
    }

    public boolean writeString(String string) throws SerialPortException {
        this.checkPortOpened("writeString()");
        return this.writeBytes(string.getBytes());
    }

    public boolean writeString(String string, String string2) throws SerialPortException, UnsupportedEncodingException {
        this.checkPortOpened("writeString()");
        return this.writeBytes(string.getBytes(string2));
    }

    public boolean writeInt(int n) throws SerialPortException {
        this.checkPortOpened("writeInt()");
        return this.writeBytes(new byte[]{(byte)n});
    }

    public boolean writeIntArray(int[] nArray) throws SerialPortException {
        this.checkPortOpened("writeIntArray()");
        byte[] byArray = new byte[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            byArray[i] = (byte)nArray[i];
        }
        return this.writeBytes(byArray);
    }

    public byte[] readBytes(int n) throws SerialPortException {
        this.checkPortOpened("readBytes()");
        return this.serialInterface.readBytes(this.portHandle, n);
    }

    public String readString(int n) throws SerialPortException {
        this.checkPortOpened("readString()");
        return new String(this.readBytes(n));
    }

    public String readHexString(int n) throws SerialPortException {
        this.checkPortOpened("readHexString()");
        return this.readHexString(n, " ");
    }

    public String readHexString(int n, String string) throws SerialPortException {
        this.checkPortOpened("readHexString()");
        String[] stringArray = this.readHexStringArray(n);
        String string2 = "";
        boolean bl = false;
        for (String string3 : stringArray) {
            if (bl) {
                string2 = string2 + string;
            }
            string2 = string2 + string3;
            bl = true;
        }
        return string2;
    }

    public String[] readHexStringArray(int n) throws SerialPortException {
        this.checkPortOpened("readHexStringArray()");
        int[] nArray = this.readIntArray(n);
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            String string = Integer.toHexString(nArray[i]).toUpperCase();
            if (string.length() == 1) {
                string = "0" + string;
            }
            stringArray[i] = string;
        }
        return stringArray;
    }

    public int[] readIntArray(int n) throws SerialPortException {
        this.checkPortOpened("readIntArray()");
        byte[] byArray = this.readBytes(n);
        int[] nArray = new int[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            nArray[i] = byArray[i] < 0 ? 256 + byArray[i] : byArray[i];
        }
        return nArray;
    }

    private void waitBytesWithTimeout(String string, int n, int n2) throws SerialPortException, SerialPortTimeoutException {
        this.checkPortOpened("waitBytesWithTimeout()");
        boolean bl = true;
        long l = System.currentTimeMillis();
        while (System.currentTimeMillis() - l < (long)n2) {
            if (this.getInputBufferBytesCount() >= n) {
                bl = false;
                break;
            }
            try {
                Thread.sleep(0L, 100);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (bl) {
            throw new SerialPortTimeoutException(this.portName, string, n2);
        }
    }

    public byte[] readBytes(int n, int n2) throws SerialPortException, SerialPortTimeoutException {
        this.checkPortOpened("readBytes()");
        this.waitBytesWithTimeout("readBytes()", n, n2);
        return this.readBytes(n);
    }

    public String readString(int n, int n2) throws SerialPortException, SerialPortTimeoutException {
        this.checkPortOpened("readString()");
        this.waitBytesWithTimeout("readString()", n, n2);
        return this.readString(n);
    }

    public String readHexString(int n, int n2) throws SerialPortException, SerialPortTimeoutException {
        this.checkPortOpened("readHexString()");
        this.waitBytesWithTimeout("readHexString()", n, n2);
        return this.readHexString(n);
    }

    public String readHexString(int n, String string, int n2) throws SerialPortException, SerialPortTimeoutException {
        this.checkPortOpened("readHexString()");
        this.waitBytesWithTimeout("readHexString()", n, n2);
        return this.readHexString(n, string);
    }

    public String[] readHexStringArray(int n, int n2) throws SerialPortException, SerialPortTimeoutException {
        this.checkPortOpened("readHexStringArray()");
        this.waitBytesWithTimeout("readHexStringArray()", n, n2);
        return this.readHexStringArray(n);
    }

    public int[] readIntArray(int n, int n2) throws SerialPortException, SerialPortTimeoutException {
        this.checkPortOpened("readIntArray()");
        this.waitBytesWithTimeout("readIntArray()", n, n2);
        return this.readIntArray(n);
    }

    public byte[] readBytes() throws SerialPortException {
        this.checkPortOpened("readBytes()");
        int n = this.getInputBufferBytesCount();
        if (n <= 0) {
            return null;
        }
        return this.readBytes(n);
    }

    public String readString() throws SerialPortException {
        this.checkPortOpened("readString()");
        int n = this.getInputBufferBytesCount();
        if (n <= 0) {
            return null;
        }
        return this.readString(n);
    }

    public String readHexString() throws SerialPortException {
        this.checkPortOpened("readHexString()");
        int n = this.getInputBufferBytesCount();
        if (n <= 0) {
            return null;
        }
        return this.readHexString(n);
    }

    public String readHexString(String string) throws SerialPortException {
        this.checkPortOpened("readHexString()");
        int n = this.getInputBufferBytesCount();
        if (n <= 0) {
            return null;
        }
        return this.readHexString(n, string);
    }

    public String[] readHexStringArray() throws SerialPortException {
        this.checkPortOpened("readHexStringArray()");
        int n = this.getInputBufferBytesCount();
        if (n <= 0) {
            return null;
        }
        return this.readHexStringArray(n);
    }

    public int[] readIntArray() throws SerialPortException {
        this.checkPortOpened("readIntArray()");
        int n = this.getInputBufferBytesCount();
        if (n <= 0) {
            return null;
        }
        return this.readIntArray(n);
    }

    public int getInputBufferBytesCount() throws SerialPortException {
        this.checkPortOpened("getInputBufferBytesCount()");
        return this.serialInterface.getBuffersBytesCount(this.portHandle)[0];
    }

    public int getOutputBufferBytesCount() throws SerialPortException {
        this.checkPortOpened("getOutputBufferBytesCount()");
        return this.serialInterface.getBuffersBytesCount(this.portHandle)[1];
    }

    public boolean setFlowControlMode(int n) throws SerialPortException {
        this.checkPortOpened("setFlowControlMode()");
        return this.serialInterface.setFlowControlMode(this.portHandle, n);
    }

    public int getFlowControlMode() throws SerialPortException {
        this.checkPortOpened("getFlowControlMode()");
        return this.serialInterface.getFlowControlMode(this.portHandle);
    }

    public boolean sendBreak(int n) throws SerialPortException {
        this.checkPortOpened("sendBreak()");
        return this.serialInterface.sendBreak(this.portHandle, n);
    }

    private int[][] waitEvents() {
        return this.serialInterface.waitEvents(this.portHandle);
    }

    private void checkPortOpened(String string) throws SerialPortException {
        if (!this.portOpened) {
            throw new SerialPortException(this.portName, string, "Port not opened");
        }
    }

    public int[] getLinesStatus() throws SerialPortException {
        this.checkPortOpened("getLinesStatus()");
        return this.serialInterface.getLinesStatus(this.portHandle);
    }

    public boolean isCTS() throws SerialPortException {
        this.checkPortOpened("isCTS()");
        return this.serialInterface.getLinesStatus(this.portHandle)[0] == 1;
    }

    public boolean isDSR() throws SerialPortException {
        this.checkPortOpened("isDSR()");
        return this.serialInterface.getLinesStatus(this.portHandle)[1] == 1;
    }

    public boolean isRING() throws SerialPortException {
        this.checkPortOpened("isRING()");
        return this.serialInterface.getLinesStatus(this.portHandle)[2] == 1;
    }

    public boolean isRLSD() throws SerialPortException {
        this.checkPortOpened("isRLSD()");
        return this.serialInterface.getLinesStatus(this.portHandle)[3] == 1;
    }

    public void addEventListener(SerialPortEventListener serialPortEventListener) throws SerialPortException {
        this.addEventListener(serialPortEventListener, 1, false);
    }

    public void addEventListener(SerialPortEventListener serialPortEventListener, int n) throws SerialPortException {
        this.addEventListener(serialPortEventListener, n, true);
    }

    private void addEventListener(SerialPortEventListener serialPortEventListener, int n, boolean bl) throws SerialPortException {
        this.checkPortOpened("addEventListener()");
        if (!this.eventListenerAdded) {
            if (this.maskAssigned && bl || !this.maskAssigned) {
                this.setEventsMask(n);
            }
            this.eventListener = serialPortEventListener;
            this.eventThread = this.getNewEventThread();
            this.eventThread.setName("EventThread " + this.portName);
            try {
                Method method = this.eventListener.getClass().getMethod("errorOccurred", SerialPortException.class);
                method.setAccessible(true);
                this.methodErrorOccurred = method;
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        } else {
            throw new SerialPortException(this.portName, "addEventListener()", "Event listener already added");
        }
        this.eventThread.start();
        this.eventListenerAdded = true;
    }

    private EventThread getNewEventThread() {
        if (SerialNativeInterface.getOsType() == 0 || SerialNativeInterface.getOsType() == 2 || SerialNativeInterface.getOsType() == 3) {
            return new LinuxEventThread();
        }
        return new EventThread();
    }

    public boolean removeEventListener() throws SerialPortException {
        this.checkPortOpened("removeEventListener()");
        if (!this.eventListenerAdded) {
            throw new SerialPortException(this.portName, "removeEventListener()", "Can't remove event listener, because listener not added");
        }
        this.eventThread.terminateThread();
        this.setEventsMask(0);
        if (Thread.currentThread().getId() != this.eventThread.getId() && this.eventThread.isAlive()) {
            try {
                this.eventThread.join(5000L);
            }
            catch (InterruptedException interruptedException) {
                throw new SerialPortException(this.portName, "removeEventListener()", "Event listener thread interrupted");
            }
        }
        this.methodErrorOccurred = null;
        this.eventListenerAdded = false;
        return true;
    }

    public boolean closePort() throws SerialPortException {
        boolean bl;
        this.checkPortOpened("closePort()");
        if (this.eventListenerAdded) {
            this.removeEventListener();
        }
        if (bl = this.serialInterface.closePort(this.portHandle)) {
            this.maskAssigned = false;
            this.portOpened = false;
        }
        return bl;
    }

    private class LinuxEventThread
    extends EventThread {
        private final int INTERRUPT_BREAK = 512;
        private final int INTERRUPT_TX = 1024;
        private final int INTERRUPT_FRAME = 2048;
        private final int INTERRUPT_OVERRUN = 4096;
        private final int INTERRUPT_PARITY = 8192;
        private int interruptBreak;
        private int interruptTX;
        private int interruptFrame;
        private int interruptOverrun;
        private int interruptParity;
        private int preCTS;
        private int preDSR;
        private int preRLSD;
        private int preRING;

        public LinuxEventThread() {
            this.INTERRUPT_BREAK = 512;
            this.INTERRUPT_TX = 1024;
            this.INTERRUPT_FRAME = 2048;
            this.INTERRUPT_OVERRUN = 4096;
            this.INTERRUPT_PARITY = 8192;
            int[][] nArray = SerialPort.this.waitEvents();
            block11: for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i][0];
                int n2 = nArray[i][1];
                switch (n) {
                    case 512: {
                        this.interruptBreak = n2;
                        continue block11;
                    }
                    case 1024: {
                        this.interruptTX = n2;
                        continue block11;
                    }
                    case 2048: {
                        this.interruptFrame = n2;
                        continue block11;
                    }
                    case 4096: {
                        this.interruptOverrun = n2;
                        continue block11;
                    }
                    case 8192: {
                        this.interruptParity = n2;
                        continue block11;
                    }
                    case 8: {
                        this.preCTS = n2;
                        continue block11;
                    }
                    case 16: {
                        this.preDSR = n2;
                        continue block11;
                    }
                    case 256: {
                        this.preRING = n2;
                        continue block11;
                    }
                    case 32: {
                        this.preRLSD = n2;
                    }
                }
            }
        }

        @Override
        public void run() {
            while (!((EventThread)this).threadTerminated) {
                int[][] nArray = SerialPort.this.waitEvents();
                int n = SerialPort.this.getLinuxMask();
                boolean bl = false;
                int n2 = 0;
                for (int i = 0; i < nArray.length; ++i) {
                    boolean bl2 = false;
                    int n3 = nArray[i][0];
                    int n4 = nArray[i][1];
                    if (n3 <= 0 || ((EventThread)this).threadTerminated) continue;
                    switch (n3) {
                        case 512: {
                            if (n4 == this.interruptBreak) break;
                            this.interruptBreak = n4;
                            if ((n & 0x40) != 64) break;
                            n3 = 64;
                            n4 = 0;
                            bl2 = true;
                            break;
                        }
                        case 1024: {
                            if (n4 == this.interruptTX) break;
                            this.interruptTX = n4;
                            bl = true;
                            break;
                        }
                        case 2048: {
                            if (n4 == this.interruptFrame) break;
                            this.interruptFrame = n4;
                            n2 |= 8;
                            break;
                        }
                        case 4096: {
                            if (n4 == this.interruptOverrun) break;
                            this.interruptOverrun = n4;
                            n2 |= 2;
                            break;
                        }
                        case 8192: {
                            if (n4 != this.interruptParity) {
                                this.interruptParity = n4;
                                n2 |= 4;
                            }
                            if ((n & 0x80) != 128 || n2 == 0) break;
                            n3 = 128;
                            n4 = n2;
                            bl2 = true;
                            break;
                        }
                        case 8: {
                            if (n4 == this.preCTS) break;
                            this.preCTS = n4;
                            if ((n & 8) != 8) break;
                            bl2 = true;
                            break;
                        }
                        case 16: {
                            if (n4 == this.preDSR) break;
                            this.preDSR = n4;
                            if ((n & 0x10) != 16) break;
                            bl2 = true;
                            break;
                        }
                        case 256: {
                            if (n4 == this.preRING) break;
                            this.preRING = n4;
                            if ((n & 0x100) != 256) break;
                            bl2 = true;
                            break;
                        }
                        case 32: {
                            if (n4 == this.preRLSD) break;
                            this.preRLSD = n4;
                            if ((n & 0x20) != 32) break;
                            bl2 = true;
                            break;
                        }
                        case 1: {
                            if ((n & 1) != 1 || n4 <= 0) break;
                            bl2 = true;
                            break;
                        }
                        case 4: {
                            if ((n & 4) != 4 || n4 != 0 || !bl) break;
                            bl2 = true;
                        }
                    }
                    if (!bl2) continue;
                    SerialPort.this.eventListener.serialEvent(new SerialPortEvent(SerialPort.this.portName, n3, n4));
                }
                try {
                    Thread.sleep(0L, 100);
                }
                catch (Exception exception) {}
            }
        }
    }

    private class EventThread
    extends Thread {
        private boolean threadTerminated = false;

        private EventThread() {
        }

        @Override
        public void run() {
            while (!this.threadTerminated) {
                int[][] nArray = SerialPort.this.waitEvents();
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i][0] <= 0 || this.threadTerminated) continue;
                    SerialPort.this.eventListener.serialEvent(new SerialPortEvent(SerialPort.this.portName, nArray[i][0], nArray[i][1]));
                }
            }
        }

        private void terminateThread() {
            this.threadTerminated = true;
        }
    }
}

