/*
 * Decompiled with CFR 0.152.
 */
package jspecview.js2d;

import java.net.URL;
import javajs.util.AjaxURLConnection;
import javajs.util.PT;
import jspecview.common.JSVFileManager;
import org.jmol.api.GenericFileInterface;

class JsFile
implements GenericFileInterface {
    private String name;
    private String fullName;

    static GenericFileInterface newFile(String name) {
        return new JsFile(name);
    }

    JsFile(String name) {
        this.name = name.replace('\\', '/');
        this.fullName = name;
        if (!this.fullName.startsWith("/") && JSVFileManager.urlTypeIndex(name) < 0) {
            this.fullName = JSVFileManager.jsDocumentBase + "/" + this.fullName;
        }
        this.fullName = PT.rep((String)this.fullName, (String)"/./", (String)"/");
        name = name.substring(name.lastIndexOf("/") + 1);
    }

    public GenericFileInterface getParentAsFile() {
        int pt = this.fullName.lastIndexOf("/");
        return pt < 0 ? null : new JsFile(this.fullName.substring(0, pt));
    }

    public String getFullPath() {
        return this.fullName;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDirectory() {
        return this.fullName.endsWith("/");
    }

    public long length() {
        return 0L;
    }

    static Object getURLContents(URL url, byte[] outputBytes, String post) {
        try {
            AjaxURLConnection conn = (AjaxURLConnection)url.openConnection();
            if (outputBytes != null) {
                conn.outputBytes(outputBytes);
            } else if (post != null) {
                conn.outputString(post);
            }
            return conn.getContents();
        }
        catch (Exception e) {
            return e.toString();
        }
    }
}

