/*
 * Decompiled with CFR 0.152.
 */
package jspecview.java;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javajs.util.PT;

public class AwtClipboard
implements Transferable {
    private Image image;
    private String text;

    public static void setClipboard(Object textOrImage) {
        AwtClipboard sel = new AwtClipboard(textOrImage);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(sel, null);
    }

    private AwtClipboard(Object image) {
        if (image instanceof String) {
            this.text = (String)image;
        } else {
            this.image = (Image)image;
        }
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] dataFlavorArray;
        if (this.text == null) {
            DataFlavor[] dataFlavorArray2 = new DataFlavor[1];
            dataFlavorArray = dataFlavorArray2;
            dataFlavorArray2[0] = DataFlavor.imageFlavor;
        } else {
            DataFlavor[] dataFlavorArray3 = new DataFlavor[1];
            dataFlavorArray = dataFlavorArray3;
            dataFlavorArray3[0] = DataFlavor.stringFlavor;
        }
        return dataFlavorArray;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return DataFlavor.imageFlavor.equals(flavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (DataFlavor.imageFlavor.equals(flavor)) {
            return this.image;
        }
        if (DataFlavor.stringFlavor.equals(flavor)) {
            return this.text;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public static String getClipboardText() {
        String result = null;
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable contents = clipboard.getContents(null);
            if (contents == null) {
                return null;
            }
            if (contents.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                result = (String)contents.getTransferData(DataFlavor.stringFlavor);
            } else if (contents.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                Object o = contents.getTransferData(DataFlavor.javaFileListFlavor);
                List fileList = (List)o;
                int length = fileList.size();
                if (length == 0) {
                    return null;
                }
                if (length == 1) {
                    result = "LoAd " + PT.esc((String)((File)fileList.get(0)).getAbsolutePath().replace('\\', '/'));
                    if (result.endsWith(".pse\"")) {
                        result = result + " filter 'DORESIZE'";
                    }
                } else {
                    result = "LoAd files ";
                    for (int i = 0; i < length; ++i) {
                        result = result + " " + PT.esc((String)((File)fileList.get(i)).getAbsolutePath().replace('\\', '/'));
                    }
                }
            }
        }
        catch (Exception ex) {
            result = ex.toString();
        }
        return result;
    }
}

