/*
 * Decompiled with CFR 0.152.
 */
package jspecview.export;

import java.io.IOException;
import javajs.util.OC;
import jspecview.api.JSVExporter;
import jspecview.common.JSVFileManager;
import jspecview.common.JSViewer;
import jspecview.export.FormContext;
import org.jmol.util.Logger;

abstract class FormExporter
implements JSVExporter {
    FormContext context = new FormContext();
    String errMsg;
    String currentTime;
    protected OC out;
    protected JSViewer vwr;

    FormExporter() {
    }

    protected void initForm(JSViewer viewer, OC out) {
        this.vwr = viewer;
        this.out = out;
        this.currentTime = viewer.apiPlatform.getDateFormat(null);
    }

    protected String writeForm(String templateFile) throws IOException {
        String[] error = new String[1];
        String template = JSVFileManager.getResourceString(this, "resources/" + templateFile, error);
        if (template == null) {
            Logger.error((String)error[0]);
            return error[0];
        }
        this.errMsg = this.context.setTemplate(template);
        if (this.errMsg != null) {
            Logger.error((String)this.errMsg);
            return this.errMsg;
        }
        this.errMsg = this.context.merge(this.out);
        if (this.out == null) {
            return this.errMsg;
        }
        if (this.errMsg != null) {
            Logger.error((String)this.errMsg);
            throw new IOException(this.errMsg);
        }
        this.out.closeChannel();
        return "OK " + this.out.getByteCount() + " bytes";
    }
}

