/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.core.matcher;

import junit.framework.AssertionFailedError;
import org.jmock.core.Invocation;
import org.jmock.core.matcher.InvokedRecorder;
import org.jmock.core.matcher.StatelessInvocationMatcher;

public class InvokedAfterMatcher
extends StatelessInvocationMatcher {
    private InvokedRecorder priorCallRecorder;
    private String priorCallDescription;

    public InvokedAfterMatcher(InvokedRecorder invokedRecorder, String string) {
        this.priorCallRecorder = invokedRecorder;
        this.priorCallDescription = string;
    }

    @Override
    public boolean matches(Invocation invocation) {
        return this.priorCallRecorder.hasBeenInvoked();
    }

    @Override
    public void invoked(Invocation invocation) {
        if (!this.matches(invocation)) {
            throw new AssertionFailedError("called out of order; should be called after " + this.priorCallDescription);
        }
    }

    @Override
    public StringBuffer describeTo(StringBuffer stringBuffer) {
        stringBuffer.append("after ").append(this.priorCallDescription);
        if (this.priorCallRecorder.hasBeenInvoked()) {
            stringBuffer.append(" (invoked)");
        } else {
            stringBuffer.append(" (not invoked)");
        }
        return stringBuffer;
    }
}

