/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.securityconfig.masterpassword;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import net.java.sip.communicator.plugin.desktoputil.PasswordChangeDialog;
import net.java.sip.communicator.plugin.securityconfig.SecurityConfigActivator;
import net.java.sip.communicator.service.credentialsstorage.CredentialsStorageService;

public class MasterPasswordChangeDialog
extends PasswordChangeDialog
implements ActionListener,
KeyListener {
    private MasterPasswordExecutable callback;
    private static MasterPasswordChangeDialog dialog;

    private MasterPasswordChangeDialog() {
        super(SecurityConfigActivator.getCredentialsStorageService().isUsingMasterPassword());
        this.setTitle(this.resources.getI18NString("plugin.securityconfig.masterpassword.MP_TITLE"));
        this.setInfoText(this.resources.getI18NString("plugin.securityconfig.masterpassword.INFO_TEXT"));
        this.getOkButton().addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean close = false;
        CredentialsStorageService credentialsStorageService = SecurityConfigActivator.getCredentialsStorageService();
        String oldMasterPassword = null;
        if (credentialsStorageService.isUsingMasterPassword()) {
            oldMasterPassword = this.getCurrentPassword();
            if (oldMasterPassword.length() == 0) {
                this.displayPopupError(this.resources.getI18NString("plugin.securityconfig.masterpassword.MP_CURRENT_EMPTY"));
                return;
            }
            boolean verified = credentialsStorageService.verifyMasterPassword(oldMasterPassword);
            if (!verified) {
                this.displayPopupError(this.resources.getI18NString("plugin.securityconfig.masterpassword.MP_VERIFICATION_FAILURE_MSG"));
                return;
            }
        }
        if (this.callback != null) {
            close = this.callback.execute(oldMasterPassword, this.getNewPassword());
        }
        if (close) {
            dialog = null;
            this.dispose();
        }
    }

    public static MasterPasswordChangeDialog getInstance() {
        if (dialog == null) {
            dialog = new MasterPasswordChangeDialog();
        }
        return dialog;
    }

    public void setCallback(MasterPasswordExecutable callbackInstance) {
        this.callback = callbackInstance;
    }

    static interface MasterPasswordExecutable {
        public boolean execute(String var1, String var2);
    }
}

