/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.irccommands.command;

import net.java.sip.communicator.impl.protocol.irc.Command;
import net.java.sip.communicator.impl.protocol.irc.IrcConnection;
import net.java.sip.communicator.impl.protocol.irc.ProtocolProviderServiceIrcImpl;

public class Nick
implements Command {
    private static final int END_OF_COMMAND_PREFIX_INDEX = 6;
    private IrcConnection connection;

    public Nick(ProtocolProviderServiceIrcImpl provider, IrcConnection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("connection cannot be null");
        }
        this.connection = connection;
    }

    public void execute(String source, String line) {
        if (line.length() <= 6) {
            throw new IllegalArgumentException("New nick name is missing.");
        }
        String part = line.substring(6);
        int indexOfSep = part.indexOf(32);
        String newNick = indexOfSep == -1 ? part : part.substring(0, indexOfSep);
        if (!newNick.isEmpty()) {
            this.connection.getIdentityManager().setNick(newNick);
        }
    }

    public String help() {
        return "Usage: /nick <new-nick>";
    }
}

