/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.simpleaccreg;

import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.plugin.simpleaccreg.InitialAccountRegistrationFrame;
import net.java.sip.communicator.service.contactlist.MetaContactListService;
import net.java.sip.communicator.service.gui.AccountRegistrationWizard;
import net.java.sip.communicator.service.gui.ConfigurationForm;
import net.java.sip.communicator.service.gui.LazyConfigurationForm;
import net.java.sip.communicator.service.gui.UIService;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.AccountManager;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.util.AbstractServiceDependentActivator;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.resources.ResourceManagementService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class SimpleAccountRegistrationActivator
extends AbstractServiceDependentActivator
implements ServiceListener {
    private static final Logger logger = Logger.getLogger(SimpleAccountRegistrationActivator.class);
    private static final String advancedConfigFormClassName = "net.java.sip.communicator.plugin.advancedconfig.AdvancedConfigurationPanel";
    private static final String provisioningFormClassName = "net.java.sip.communicator.plugin.provisioning.ProvisioningForm";
    private static final String DISABLED_PROP = "net.java.sip.communicator.plugin.simpleaccreg.DISABLED";
    public static BundleContext bundleContext;
    private static ResourceManagementService resourcesService;
    private int numWizardsRegistered = 0;
    private String[] protocolNames;

    public void start(Object dependentService) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SimpleAccountRegistrationActivator.this.init();
                }
            });
            return;
        }
        this.init();
    }

    public Class<?> getDependentServiceClass() {
        return UIService.class;
    }

    public void setBundleContext(BundleContext context) {
        bundleContext = context;
    }

    public void serviceChanged(ServiceEvent event) {
        if (event.getType() == 1 && ++this.numWizardsRegistered == this.protocolNames.length) {
            this.showDialog();
        }
    }

    private void init() {
        if (!SimpleAccountRegistrationActivator.hasStoredAccounts() && !SimpleAccountRegistrationActivator.getConfigService().getBoolean(DISABLED_PROP, false)) {
            String protocolOrder = SimpleAccountRegistrationActivator.getConfigService().getString("plugin.simpleaccreg.PROTOCOL_ORDER");
            if (protocolOrder == null) {
                return;
            }
            String protocolFilter = "";
            this.protocolNames = protocolOrder.split("\\|");
            for (int i = 0; i < this.protocolNames.length; ++i) {
                if (i > 0) {
                    protocolFilter = "(|" + protocolFilter;
                }
                protocolFilter = protocolFilter + "(PROTOCOL_NAME=" + this.protocolNames[i] + ")";
                if (i <= 0) continue;
                protocolFilter = protocolFilter + ")";
            }
            try {
                ServiceReference[] refs = bundleContext.getAllServiceReferences(AccountRegistrationWizard.class.getName(), protocolFilter);
                if (refs != null) {
                    this.numWizardsRegistered = refs.length;
                }
                if (this.numWizardsRegistered < this.protocolNames.length) {
                    bundleContext.addServiceListener((ServiceListener)this, "(&(objectclass=" + AccountRegistrationWizard.class.getName() + ")" + protocolFilter + ")");
                } else {
                    this.showDialog();
                }
            }
            catch (InvalidSyntaxException e) {
                logger.error((Object)e);
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)"SIMPLE ACCOUNT REGISTRATION ...[STARTED]");
        }
    }

    private void showDialog() {
        InitialAccountRegistrationFrame accountRegFrame = new InitialAccountRegistrationFrame();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        accountRegFrame.setLocation(screenSize.width / 2 - accountRegFrame.getWidth() / 2, screenSize.height / 2 - accountRegFrame.getHeight() / 2);
        accountRegFrame.setVisible(true);
    }

    public void stop(BundleContext bc) throws Exception {
    }

    private static boolean hasRegisteredAccounts() {
        ServiceReference[] serRefs = null;
        try {
            serRefs = bundleContext.getServiceReferences(ProtocolProviderFactory.class.getName(), null);
        }
        catch (InvalidSyntaxException e) {
            logger.error((Object)("Unable to obtain service references. " + (Object)((Object)e)));
        }
        boolean hasRegisteredAccounts = false;
        if (serRefs != null) {
            for (ServiceReference serRef : serRefs) {
                ProtocolProviderFactory providerFactory = (ProtocolProviderFactory)bundleContext.getService(serRef);
                for (AccountID accountID : providerFactory.getRegisteredAccounts()) {
                    if (accountID.isHidden()) continue;
                    hasRegisteredAccounts = true;
                    break;
                }
                if (hasRegisteredAccounts) break;
            }
        }
        return hasRegisteredAccounts;
    }

    private static boolean hasStoredAccounts() {
        AccountManager accountManager;
        ServiceReference accountManagerReference = bundleContext.getServiceReference(AccountManager.class.getName());
        boolean hasStoredAccounts = false;
        if (accountManagerReference != null && (accountManager = (AccountManager)bundleContext.getService(accountManagerReference)) != null) {
            hasStoredAccounts = accountManager.hasStoredAccounts(null, false);
        }
        return hasStoredAccounts;
    }

    public static MetaContactListService getContactList() {
        ServiceReference serviceReference = bundleContext.getServiceReference(MetaContactListService.class.getName());
        return (MetaContactListService)bundleContext.getService(serviceReference);
    }

    public static UIService getUIService() {
        ServiceReference serviceReference = bundleContext.getServiceReference(UIService.class.getName());
        return (UIService)bundleContext.getService(serviceReference);
    }

    public static ResourceManagementService getResources() {
        if (resourcesService == null) {
            resourcesService = (ResourceManagementService)ServiceUtils.getService((BundleContext)bundleContext, ResourceManagementService.class);
        }
        return resourcesService;
    }

    public static ConfigurationForm getAdvancedConfigForm() {
        String osgiFilter = "(FORM_TYPE=GENERAL_TYPE)";
        ServiceReference[] confFormsRefs = null;
        try {
            confFormsRefs = bundleContext.getServiceReferences(ConfigurationForm.class.getName(), osgiFilter);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        if (confFormsRefs != null) {
            for (int i = 0; i < confFormsRefs.length; ++i) {
                LazyConfigurationForm lazyConfigForm;
                ConfigurationForm form = (ConfigurationForm)bundleContext.getService(confFormsRefs[i]);
                if (!(form instanceof LazyConfigurationForm ? (lazyConfigForm = (LazyConfigurationForm)form).getFormClassName().equals(advancedConfigFormClassName) : form.getClass().getName().equals(advancedConfigFormClassName))) continue;
                return form;
            }
        }
        return null;
    }

    public static ConfigurationForm getProvisioningConfigForm() {
        String osgiFilter = "(FORM_TYPE=ADVANCED_TYPE)";
        ServiceReference[] confFormsRefs = null;
        try {
            confFormsRefs = bundleContext.getServiceReferences(ConfigurationForm.class.getName(), osgiFilter);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        if (confFormsRefs != null) {
            for (int i = 0; i < confFormsRefs.length; ++i) {
                LazyConfigurationForm lazyConfigForm;
                ConfigurationForm form = (ConfigurationForm)bundleContext.getService(confFormsRefs[i]);
                if (!(form instanceof LazyConfigurationForm) || !(lazyConfigForm = (LazyConfigurationForm)form).getFormClassName().equals(provisioningFormClassName)) continue;
                return form;
            }
        }
        return null;
    }

    public static ConfigurationService getConfigService() {
        return (ConfigurationService)ServiceUtils.getService((BundleContext)bundleContext, ConfigurationService.class);
    }
}

