/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar;

import java.beans.PropertyChangeEvent;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.snaccmd.ExtraInfoData;
import net.kano.joustsim.Screenname;
import net.kano.joustsim.oscar.AimConnection;
import net.kano.joustsim.oscar.BuddyInfo;
import net.kano.joustsim.oscar.BuddyInfoManager;
import net.kano.joustsim.oscar.GlobalBuddyInfoListener;
import net.kano.joustsim.oscar.StateEvent;
import net.kano.joustsim.oscar.StateListener;
import net.kano.joustsim.oscar.oscar.service.icon.IconRequestListener;
import net.kano.joustsim.oscar.oscar.service.icon.IconService;
import net.kano.joustsim.oscar.oscar.service.icon.IconServiceArbiter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuddyIconTracker {
    private static final Logger LOGGER = Logger.getLogger(BuddyIconTracker.class.getName());
    private static final long RE_REQUEST_INTERVAL = 60000L;
    private static final long MAX_REREQUEST_ICON_TIMES = 4L;
    private final AimConnection conn;
    private final Map<BuddyIconRequest, Long> pendingRequests = new HashMap<BuddyIconRequest, Long>();
    private final Map<ExtraInfoData, ByteBlock> iconCache = new HashMap<ExtraInfoData, ByteBlock>();
    private final IconRequestListener iconRequestListener = new MyIconRequestListener();
    private Timer rerequestIconsTimer;
    private boolean enabled = true;

    public BuddyIconTracker(AimConnection aconn) {
        this.conn = aconn;
        BuddyInfoManager mgr = this.conn.getBuddyInfoManager();
        mgr.addGlobalBuddyInfoListener(new MyGlobalBuddyInfoListener());
        this.conn.addStateListener(new StateListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleStateChange(StateEvent event) {
                if (event.getNewState().isFinished()) {
                    if (BuddyIconTracker.this.rerequestIconsTimer != null) {
                        BuddyIconTracker.this.rerequestIconsTimer.cancel();
                        BuddyIconTracker.this.rerequestIconsTimer = null;
                    }
                    BuddyIconTracker buddyIconTracker = BuddyIconTracker.this;
                    synchronized (buddyIconTracker) {
                        BuddyIconTracker.this.pendingRequests.clear();
                    }
                }
            }
        });
    }

    public synchronized boolean isEnabled() {
        return this.enabled;
    }

    public synchronized void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (!enabled) {
            this.iconCache.clear();
        }
    }

    private synchronized void clearRequest(BuddyIconRequest iconRequest) {
        this.pendingRequests.remove(iconRequest);
        if (this.rerequestIconsTimer != null && this.pendingRequests.isEmpty()) {
            this.rerequestIconsTimer.cancel();
            this.rerequestIconsTimer = null;
        }
    }

    private synchronized void updateRequestTime(BuddyIconRequest iconRequest) {
        if (this.rerequestIconsTimer == null && this.pendingRequests.isEmpty()) {
            this.rerequestIconsTimer = new Timer(true);
            this.rerequestIconsTimer.schedule((TimerTask)new RerequestIconsTask(), 60000L, 60000L);
        }
        this.pendingRequests.put(iconRequest, System.currentTimeMillis());
    }

    public synchronized long getRequestTime(ExtraInfoData block, Screenname buddy) {
        Long time = this.pendingRequests.get(new BuddyIconRequest(buddy, block));
        return time == null ? 0L : time;
    }

    @Nullable
    public synchronized ByteBlock getIconDataForHash(ExtraInfoData hash) {
        return this.iconCache.get(hash);
    }

    @Nullable
    public ByteBlock getBuddyIconData(Screenname screenname) {
        BuddyInfo buddyInfo = this.conn.getBuddyInfoManager().getBuddyInfo(screenname);
        ExtraInfoData hash = buddyInfo.getIconHash();
        if (hash == null) {
            return null;
        }
        return this.getIconDataForHash(hash);
    }

    public ExtraInfoData addToCache(Screenname buddy, ByteBlock iconData) {
        DefensiveTools.checkNull(iconData, "iconData");
        ExtraInfoData iconInfo = new ExtraInfoData(1, BuddyIconTracker.computeIconHash(iconData));
        this.storeInCache(iconInfo, buddy, iconData);
        return iconInfo;
    }

    private synchronized void storeInCache(ExtraInfoData hash, Screenname buddy, @NotNull ByteBlock iconData) {
        LOGGER.fine("Cached icon data for " + hash);
        this.clearRequest(new BuddyIconRequest(buddy, hash));
        this.iconCache.put(hash, ByteBlock.wrap(iconData.toByteArray()));
    }

    private static ByteBlock computeIconHash(ByteBlock iconData) {
        ByteBlock hash;
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            hash = ByteBlock.wrap(digest.digest(iconData.toByteArray()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        return hash;
    }

    private synchronized boolean updateRequestTimeIfPossible(BuddyIconRequest iconRequest) {
        if ((long)iconRequest.getTimesRequested() < 4L) {
            this.updateRequestTime(iconRequest);
            iconRequest.incrementTimesRequested();
            return true;
        }
        this.clearRequest(iconRequest);
        return false;
    }

    private void requestIcon(BuddyIconRequest iconRequest) {
        if (this.updateRequestTimeIfPossible(iconRequest)) {
            IconServiceArbiter iconArbiter = this.conn.getExternalServiceManager().getIconServiceArbiter();
            if (iconArbiter != null) {
                if (iconRequest.screenname != null) {
                    LOGGER.fine("Requesting buddy icon for " + iconRequest.screenname);
                }
                iconArbiter.addIconRequestListener(this.iconRequestListener);
                iconArbiter.requestIcon(iconRequest.screenname, iconRequest.data);
            } else {
                LOGGER.warning("icon arbiter is null!");
            }
        }
    }

    private void storeBuddyIconData(Screenname buddy, ExtraInfoData iconInfo, ByteBlock iconData) {
        BuddyInfo buddyInfo = this.conn.getBuddyInfoManager().getBuddyInfo(buddy);
        buddyInfo.setIconDataIfHashMatches(iconInfo, iconData);
    }

    private class MyIconRequestListener
    implements IconRequestListener {
        private MyIconRequestListener() {
        }

        public void buddyIconCleared(IconService service, Screenname screenname, ExtraInfoData data) {
            if (!BuddyIconTracker.this.isEnabled()) {
                return;
            }
            LOGGER.fine("Buddy icon cleared for " + screenname + ": " + data);
            BuddyIconTracker.this.storeBuddyIconData(screenname, data, null);
        }

        public void buddyIconUpdated(IconService service, Screenname buddy, ExtraInfoData hash, ByteBlock iconData) {
            if (!BuddyIconTracker.this.isEnabled()) {
                return;
            }
            BuddyIconTracker.this.storeInCache(hash, buddy, iconData);
            BuddyInfo buddyInfo = BuddyIconTracker.this.conn.getBuddyInfoManager().getBuddyInfo(buddy);
            LOGGER.fine("Storing buddy icon for " + buddy);
            if (!buddyInfo.setIconDataIfHashMatches(hash, iconData)) {
                LOGGER.info("Buddy icon data for " + buddy + " set too " + "late - hash " + hash + " no longer matches");
            }
        }
    }

    private class RerequestIconsTask
    extends TimerTask {
        private RerequestIconsTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LOGGER.fine("RerequestIconsTask invoked...");
            ArrayList rereq = new ArrayList();
            BuddyIconTracker buddyIconTracker = BuddyIconTracker.this;
            synchronized (buddyIconTracker) {
                for (Map.Entry entry : BuddyIconTracker.this.pendingRequests.entrySet()) {
                    if (System.currentTimeMillis() - (Long)entry.getValue() <= 60000L) continue;
                    rereq.add(entry.getKey());
                }
            }
            for (BuddyIconRequest iconRequest : rereq) {
                LOGGER.fine("Re-requesting buddy icon for " + iconRequest.screenname + " (" + iconRequest.data + ")");
                BuddyIconTracker.this.requestIcon(iconRequest);
            }
        }
    }

    private class MyGlobalBuddyInfoListener
    implements GlobalBuddyInfoListener {
        private MyGlobalBuddyInfoListener() {
        }

        public void newBuddyInfo(BuddyInfoManager manager, Screenname buddy, BuddyInfo info) {
            if (!BuddyIconTracker.this.isEnabled()) {
                return;
            }
            this.handleNewIconHashForBuddy(buddy, info.getIconHash());
        }

        public void buddyInfoChanged(BuddyInfoManager manager, Screenname buddy, BuddyInfo info, PropertyChangeEvent event) {
            if (!BuddyIconTracker.this.isEnabled()) {
                return;
            }
            if (event.getPropertyName().equals("iconHash")) {
                ExtraInfoData newHash = (ExtraInfoData)event.getNewValue();
                this.handleNewIconHashForBuddy(buddy, newHash);
            }
        }

        private void handleNewIconHashForBuddy(Screenname buddy, ExtraInfoData newHash) {
            LOGGER.fine("Got new icon hash for " + buddy + ": " + newHash);
            if (newHash == null) {
                BuddyIconTracker.this.storeBuddyIconData(buddy, newHash, null);
            } else {
                ByteBlock iconData = BuddyIconTracker.this.getIconDataForHash(newHash);
                if (iconData == null) {
                    BuddyIconTracker.this.requestIcon(new BuddyIconRequest(buddy, newHash));
                } else {
                    LOGGER.finer("Icon data was already cached for " + buddy);
                    BuddyIconTracker.this.storeBuddyIconData(buddy, newHash, iconData);
                }
            }
        }

        public void receivedStatusUpdate(BuddyInfoManager manager, Screenname buddy, BuddyInfo info) {
        }
    }

    private static class BuddyIconRequest {
        private final Screenname screenname;
        private final ExtraInfoData data;
        private int timesRequested;

        public BuddyIconRequest(Screenname screenname, ExtraInfoData data) {
            this.screenname = screenname;
            this.data = data;
            this.timesRequested = 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BuddyIconRequest that = (BuddyIconRequest)o;
            return this.data.equals(that.data) && this.screenname.equals(that.screenname);
        }

        public int hashCode() {
            return 31 * this.screenname.hashCode() + this.data.hashCode();
        }

        public int getTimesRequested() {
            return this.timesRequested;
        }

        public void incrementTimesRequested() {
            ++this.timesRequested;
        }
    }
}

