/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.ssi;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.ssi.SsiCommand;
import net.kano.joscar.snaccmd.ssi.SsiItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SsiDataCmd
extends SsiCommand {
    public static final int VERSION_DEFAULT = 0;
    private final int version;
    private final List<SsiItem> items;
    private final long lastmod;

    protected SsiDataCmd(SnacPacket packet) {
        super(6);
        SsiItem item;
        DefensiveTools.checkNull(packet, "packet");
        ByteBlock snacData = packet.getData();
        this.version = BinaryTools.getUByte(snacData, 0);
        int itemCount = BinaryTools.getUShort(snacData, 1);
        ArrayList<SsiItem> itemList = new ArrayList<SsiItem>();
        ByteBlock block = snacData.subBlock(3);
        for (int i = 0; i < itemCount && (item = SsiItem.readSsiItem(block)) != null; ++i) {
            itemList.add(item);
            block = block.subBlock(item.getTotalSize());
        }
        this.items = DefensiveTools.getUnmodifiable(itemList);
        this.lastmod = BinaryTools.getUInt(block, 0);
    }

    public SsiDataCmd(Collection<? extends SsiItem> items, long lastmod) {
        this(0, items, lastmod);
    }

    public SsiDataCmd(int version, Collection<? extends SsiItem> items, long lastmod) {
        super(6);
        DefensiveTools.checkRange(version, "version", 0);
        DefensiveTools.checkRange(lastmod, "lastmod", 0L);
        List<? extends SsiItem> safeItems = DefensiveTools.getSafeNonnullListCopy(items, "items");
        this.version = version;
        this.items = safeItems;
        this.lastmod = lastmod;
    }

    public final int getSsiVersion() {
        return this.version;
    }

    public final List<SsiItem> getItems() {
        return this.items;
    }

    public final long getLastModDate() {
        return this.lastmod;
    }

    @Override
    public void writeData(OutputStream out) throws IOException {
        BinaryTools.writeUByte(out, this.version);
        BinaryTools.writeUShort(out, this.items.size());
        for (SsiItem item : this.items) {
            item.write(out);
        }
        BinaryTools.writeUInt(out, this.lastmod);
    }

    public String toString() {
        return "SsiDataCmd (ssi version=" + this.version + "): " + this.items.size() + " items, modified " + new Date(this.lastmod * 1000L);
    }
}

