/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvcmd.chatinvite;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.rvcmd.AbstractRequestRvCmd;
import net.kano.joscar.rvcmd.InvitationMessage;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.snaccmd.MiniRoomInfo;
import net.kano.joscar.snaccmd.icbm.RecvRvIcbm;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;

public class ChatInvitationRvCmd
extends AbstractRequestRvCmd {
    private static final int TYPE_SECURE = 17;
    private static final int TYPE_SECURITYINFO = 10003;
    private final InvitationMessage invMessage;
    private final MiniRoomInfo roomInfo;
    private final ByteBlock securityInfo;

    public ChatInvitationRvCmd(RecvRvIcbm icbm) {
        super(icbm);
        TlvChain chain = this.getRvTlvs();
        this.invMessage = InvitationMessage.readInvitationMessage(chain);
        Tlv securityInfoTlv = chain.getLastTlv(10003);
        this.securityInfo = securityInfoTlv != null ? securityInfoTlv.getData() : null;
        ByteBlock serviceData = this.getServiceData();
        this.roomInfo = serviceData == null ? null : MiniRoomInfo.readMiniRoomInfo(serviceData);
    }

    public ChatInvitationRvCmd(MiniRoomInfo roomInfo, InvitationMessage message) {
        this(roomInfo, message, null);
    }

    public ChatInvitationRvCmd(MiniRoomInfo roomInfo, InvitationMessage message, ByteBlock securityInfo) {
        super(CapabilityBlock.BLOCK_CHAT);
        this.roomInfo = roomInfo;
        this.invMessage = message;
        this.securityInfo = securityInfo;
    }

    public final InvitationMessage getInvMessage() {
        return this.invMessage;
    }

    public final ByteBlock getSecurityInfo() {
        return this.securityInfo;
    }

    public final MiniRoomInfo getRoomInfo() {
        return this.roomInfo;
    }

    protected void writeRvTlvs(OutputStream out) throws IOException {
        if (this.invMessage != null) {
            this.invMessage.write(out);
        }
        if (this.securityInfo != null) {
            new Tlv(17).write(out);
            new Tlv(10003, this.securityInfo).write(out);
        }
    }

    protected void writeServiceData(OutputStream out) throws IOException {
        if (this.roomInfo != null) {
            this.roomInfo.write(out);
        }
    }

    public String toString() {
        return "ChatInvitationRvCmd: " + (this.securityInfo != null ? "(secure) " : "") + "roomInfo=<" + this.roomInfo + ">: " + this.invMessage;
    }
}

