/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvcmd;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import net.kano.joscar.DefensiveTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SegmentedFilename {
    private static final String FILESEP_FT = "\u0001";
    public static final String FILESEP_NATIVE = File.separator;
    private final List<String> parts;

    public SegmentedFilename(String ... strings) {
        this(Arrays.asList(strings));
    }

    private static SegmentedFilename createFromString(String path, String separator) {
        DefensiveTools.checkNull(path, "path");
        DefensiveTools.checkNull(separator, "separator");
        StringTokenizer strtok = new StringTokenizer(path, separator);
        LinkedList<String> parts = new LinkedList<String>();
        while (strtok.hasMoreTokens()) {
            String part = strtok.nextToken();
            parts.add(part);
        }
        return new SegmentedFilename(parts);
    }

    public static SegmentedFilename fromNativeFilename(String nativeFilename) {
        return SegmentedFilename.createFromString(nativeFilename, FILESEP_NATIVE);
    }

    public static SegmentedFilename fromFTFilename(String ftFilename) {
        return SegmentedFilename.createFromString(ftFilename, FILESEP_FT);
    }

    public SegmentedFilename(SegmentedFilename parent, String file) {
        this(parent, new SegmentedFilename(Arrays.asList(file)));
    }

    public SegmentedFilename(SegmentedFilename parent, SegmentedFilename child) {
        DefensiveTools.checkNull(child, "file");
        if (parent == null) {
            this.parts = child.parts;
        } else {
            ArrayList<String> list = new ArrayList<String>(parent.parts.size() + child.parts.size());
            list.addAll(parent.parts);
            list.addAll(child.parts);
            this.parts = DefensiveTools.getUnmodifiable(list);
        }
    }

    public SegmentedFilename(Collection<String> parts) {
        this.parts = DefensiveTools.getSafeNonnullListCopy(parts, "parts");
    }

    public final List<String> getSegments() {
        return this.parts;
    }

    public final String getLastSegment() {
        return this.parts.isEmpty() ? null : this.parts.get(0);
    }

    private String toFilename(String sep) {
        DefensiveTools.checkNull(sep, "sep");
        StringBuffer buffer = new StringBuffer(this.parts.size() * 16);
        boolean first = true;
        for (String part : this.parts) {
            if (part.length() == 0) continue;
            if (first) {
                first = false;
            } else {
                buffer.append(sep);
            }
            buffer.append(part);
        }
        return buffer.toString();
    }

    public final String toNativeFilename() {
        return this.toFilename(FILESEP_NATIVE);
    }

    public final String toFTFilename() {
        return this.toFilename(FILESEP_FT);
    }

    public int hashCode() {
        int code = 0;
        for (String part : this.parts) {
            code += 29 * part.hashCode();
        }
        return code;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SegmentedFilename)) {
            return false;
        }
        return ((Object)this.parts).equals(((SegmentedFilename)obj).parts);
    }

    public String toString() {
        return "SegmentedFilename: " + this.parts + " (" + this.toNativeFilename() + ")";
    }
}

