/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.ratelim;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.logging.Logger;
import net.kano.joscar.logging.LoggingSystem;
import net.kano.joscar.ratelim.ConnectionQueueMgr;
import net.kano.joscar.ratelim.RateClassMonitor;
import net.kano.joscar.ratelim.SnacRequestSender;
import net.kano.joscar.snac.SnacRequest;
import net.kano.joscar.snac.SnacRequestAdapter;
import net.kano.joscar.snac.SnacRequestSentEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RateQueue {
    private static final Logger logger = LoggingSystem.getLogger("net.kano.joscar.ratelim");
    private final ConnectionQueueMgr connectionManager;
    private final LinkedList<SnacRequest> queue = new LinkedList();
    private final RateClassMonitor rateMonitor;
    private final Set<SnacRequest> pendingRequests = new HashSet<SnacRequest>();
    private final SnacRequestSender requestSender;

    RateQueue(ConnectionQueueMgr connectionManager, RateClassMonitor monitor, SnacRequestSender requestSender) {
        DefensiveTools.checkNull(connectionManager, "connectionManager");
        DefensiveTools.checkNull(monitor, "monitor");
        DefensiveTools.checkNull(requestSender, "requestSender");
        this.connectionManager = connectionManager;
        this.rateMonitor = monitor;
        this.requestSender = requestSender;
    }

    public RateClassMonitor getRateClassMonitor() {
        return this.rateMonitor;
    }

    public synchronized int getQueueSize() {
        return this.queue.size();
    }

    public synchronized boolean hasRequests() {
        return !this.queue.isEmpty();
    }

    synchronized void enqueue(SnacRequest req) {
        DefensiveTools.checkNull(req, "req");
        if (logger.logFineEnabled()) {
            logger.logFine("Enqueuing " + req.getCommand() + " within ratequeue " + "(class " + this.rateMonitor.getRateInfo().getRateClass() + ")...");
        }
        this.queue.add(req);
    }

    synchronized SnacRequest dequeueNextRequest() throws NoSuchElementException {
        SnacRequest request = this.queue.removeFirst();
        if (logger.logFineEnabled()) {
            logger.logFine("Dequeueing " + request.getCommand() + " from ratequeue (class " + this.rateMonitor.getRateInfo().getRateClass() + ")...");
        }
        return request;
    }

    synchronized void dequeueAll(Collection<? super SnacRequest> dest) {
        dest.addAll(this.queue);
        this.queue.clear();
    }

    synchronized void clear() {
        this.queue.clear();
    }

    public boolean isOpen() {
        return this.hasRequests() && !this.connectionManager.isPaused();
    }

    public boolean isReady() {
        return this.rateMonitor.getPossibleCmdCount() > 0;
    }

    public long getOptimalWaitTime() {
        return this.rateMonitor.getOptimalWaitTime();
    }

    public synchronized boolean sendAndDequeueReadyRequestsIfPossible() {
        if (!this.isOpen()) {
            return true;
        }
        if (this.isReady()) {
            this.sendAndDequeueReadyRequests();
        }
        return !this.hasRequests();
    }

    private void sendAndDequeueReadyRequests() {
        List<SnacRequest> toSend = this.dequeueReadyRequests();
        if (toSend.isEmpty()) {
            return;
        }
        this.requestSender.sendRequests(toSend);
    }

    private synchronized List<SnacRequest> dequeueReadyRequests() {
        ArrayList<SnacRequest> toSend = new ArrayList<SnacRequest>(this.queue.size());
        int max = this.rateMonitor.getPossibleCmdCount() - this.pendingRequests.size();
        for (int i = 0; i < max && this.hasRequests(); ++i) {
            SnacRequest request = this.dequeueNextRequest();
            request.addListener(new SnacRequestAdapter(){

                public void handleSent(SnacRequestSentEvent e) {
                    RateQueue.this.removePending(e.getRequest());
                }
            });
            toSend.add(request);
        }
        this.pendingRequests.addAll(toSend);
        return toSend;
    }

    synchronized void removePending(SnacRequest request) {
        this.pendingRequests.remove(request);
    }

    public String toString() {
        return "RateQueue: rateMonitor=" + this.rateMonitor + ", queued: " + this.queue.size();
    }
}

