/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.flapcmd;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flap.FlapCommand;
import net.kano.joscar.flap.FlapPacket;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.flapcmd.SnacPacket;

public class SnacFlapCmd
extends FlapCommand {
    public static final int CHANNEL_SNAC = 2;
    private final SnacPacket packet;

    public SnacFlapCmd(FlapPacket flapPacket) {
        super(2);
        DefensiveTools.checkNull(flapPacket, "flapPacket");
        ByteBlock flapData = flapPacket.getData();
        this.packet = SnacPacket.isValidSnacPacket(flapData) ? SnacPacket.readSnacPacket(flapData) : null;
    }

    public SnacFlapCmd(long requestId, SnacCommand command) {
        super(2);
        DefensiveTools.checkRange(requestId, "requestId", 0L);
        this.packet = new SnacPacket(requestId, command);
    }

    public final SnacPacket getSnacPacket() {
        return this.packet;
    }

    public void writeData(OutputStream out) throws IOException {
        this.packet.write(out);
    }

    public String toString() {
        return "SnacFlapCmd: packet=" + this.packet;
    }
}

