/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.protocol.icq;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import junit.framework.Test;
import junit.framework.TestSuite;
import net.java.sip.communicator.slick.protocol.icq.IcqSlickFixture;
import net.java.sip.communicator.slick.protocol.icq.IcqTesterAgent;
import net.java.sip.communicator.slick.protocol.icq.TestAccountInstallation;
import net.java.sip.communicator.slick.protocol.icq.TestAccountInvalidNotification;
import net.java.sip.communicator.slick.protocol.icq.TestAccountUninstallation;
import net.java.sip.communicator.slick.protocol.icq.TestAccountUninstallationPersistence;
import net.java.sip.communicator.slick.protocol.icq.TestOperationSetBasicInstantMessaging;
import net.java.sip.communicator.slick.protocol.icq.TestOperationSetFileTransferImpl;
import net.java.sip.communicator.slick.protocol.icq.TestOperationSetPersistentPresence;
import net.java.sip.communicator.slick.protocol.icq.TestOperationSetPresence;
import net.java.sip.communicator.slick.protocol.icq.TestOperationSetTypingNotifications;
import net.java.sip.communicator.slick.protocol.icq.TestProtocolProviderServiceIcqImpl;
import net.java.sip.communicator.util.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class IcqProtocolProviderSlick
extends TestSuite
implements BundleActivator {
    private Logger logger = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());
    public static final String TESTED_IMPL_USER_ID_PROP_NAME = "accounts.icq.TESTED_IMPL_ACCOUNT_ID";
    public static final String TESTED_IMPL_PWD_PROP_NAME = "accounts.icq.TESTED_IMPL_PWD";
    public static final String TESTING_IMPL_USER_ID_PROP_NAME = "accounts.icq.TESTING_IMPL_ACCOUNT_ID";
    public static final String TESTING_IMPL_PWD_PROP_NAME = "accounts.icq.TESTING_IMPL_PWD";
    public static final String CONTACT_LIST_PROPERTY_NAME = "accounts.icq.CONTACT_LIST";
    public static final String DISABLE_ONLINE_TESTS_PROPERTY_NAME = "accounts.icq.DISABLE_ONLINE_TESTING";

    public void start(BundleContext bundleContext) throws Exception {
        String icqTestAgentName;
        this.setName("IcqProtocolProviderSlick");
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("service.pid", this.getName());
        IcqSlickFixture.bc = bundleContext;
        String offlineMode = System.getProperty(DISABLE_ONLINE_TESTS_PROPERTY_NAME, null);
        if (offlineMode != null && offlineMode.equalsIgnoreCase("true")) {
            IcqSlickFixture.onlineTestingDisabled = true;
        }
        if ((icqTestAgentName = System.getProperty(TESTING_IMPL_USER_ID_PROP_NAME, null)) != null) {
            IcqSlickFixture.testerAgent = new IcqTesterAgent(icqTestAgentName);
            String icqTestAgentPwd = System.getProperty(TESTING_IMPL_PWD_PROP_NAME, null);
            if (IcqSlickFixture.testerAgent.register(icqTestAgentPwd)) {
                if (!IcqSlickFixture.onlineTestingDisabled) {
                    IcqSlickFixture.testerAgent.setAuthorizationRequired();
                    try {
                        this.initializeTestedContactList();
                    }
                    catch (Exception ex) {
                        this.logger.error((Object)"Error initing of tester agent list", (Throwable)ex);
                    }
                    String offlineMsgBody = "This is a Test Message. Supposed to be delivered as offline message!";
                    IcqSlickFixture.offlineMsgCollector = new IcqSlickFixture.OfflineMsgCollector();
                    IcqSlickFixture.offlineMsgCollector.setMessageText(offlineMsgBody);
                    IcqSlickFixture.testerAgent.sendOfflineMessage(System.getProperty(TESTED_IMPL_USER_ID_PROP_NAME, null), offlineMsgBody);
                }
                this.addTest(TestAccountInstallation.suite());
                this.addTest(TestProtocolProviderServiceIcqImpl.suite());
                this.addTest(TestOperationSetPresence.suite());
                if (!IcqSlickFixture.onlineTestingDisabled) {
                    this.addTest(TestOperationSetPersistentPresence.suite());
                    this.addTest(TestOperationSetBasicInstantMessaging.suite());
                    this.addTest(TestOperationSetTypingNotifications.suite());
                    this.addTest(TestOperationSetFileTransferImpl.suite());
                }
                this.addTest(TestAccountUninstallation.suite());
                this.addTestSuite(TestAccountUninstallationPersistence.class);
            } else {
                this.addTest((Test)new TestAccountInvalidNotification("failIcqTesterAgentRegisterRejected"));
            }
        } else {
            this.addTest((Test)new TestAccountInvalidNotification("failIcqTesterAgentMissing"));
        }
        bundleContext.registerService(((Object)((Object)this)).getClass().getName(), (Object)this, properties);
        this.logger.debug((Object)("Successfully registered " + ((Object)((Object)this)).getClass().getName()));
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (IcqSlickFixture.testerAgent != null) {
            IcqSlickFixture.testerAgent.unregister();
        }
    }

    private void initializeTestedContactList() {
        String contactList = System.getProperty(CONTACT_LIST_PROPERTY_NAME, null);
        this.logger.debug((Object)("The accounts.icq.CONTACT_LIST property is set to=" + contactList));
        if (contactList == null || contactList.trim().length() < 6) {
            throw new IllegalArgumentException("The accounts.icq.CONTACT_LIST property did not contain a contact list.");
        }
        StringTokenizer tokenizer = new StringTokenizer(contactList, " \n\t");
        this.logger.debug((Object)("tokens contained by the CL tokenized=" + tokenizer.countTokens()));
        Hashtable<String, List<String>> contactListToCreate = new Hashtable<String, List<String>>();
        while (tokenizer.hasMoreTokens()) {
            String groupUinToken = tokenizer.nextToken();
            int dotIndex = groupUinToken.indexOf(".");
            if (dotIndex == -1) {
                throw new IllegalArgumentException(groupUinToken + " is not a valid Group.UIN token");
            }
            String groupName = groupUinToken.substring(0, dotIndex);
            String uin = groupUinToken.substring(dotIndex + 1);
            if (groupName.trim().length() < 1 || uin.trim().length() < 4) {
                throw new IllegalArgumentException(groupName + " or " + uin + " are not a valid group name or ICQ UIN.");
            }
            List<String> uinInThisGroup = contactListToCreate.get(groupName);
            if (uinInThisGroup == null) {
                uinInThisGroup = new ArrayList<String>();
                contactListToCreate.put(groupName, uinInThisGroup);
            }
            uinInThisGroup.add(uin);
        }
        if (IcqSlickFixture.onlineTestingDisabled) {
            return;
        }
        IcqTesterAgent cListInitTesterAgent = new IcqTesterAgent(System.getProperty(TESTED_IMPL_USER_ID_PROP_NAME, null));
        cListInitTesterAgent.register(System.getProperty(TESTED_IMPL_PWD_PROP_NAME, null));
        cListInitTesterAgent.setAuthorizationRequired();
        cListInitTesterAgent.initializeBuddyList(contactListToCreate);
        cListInitTesterAgent.unregister();
        IcqSlickFixture.preInstalledBuddyList = contactListToCreate;
    }
}

