/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.galagonotification;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.java.sip.communicator.impl.galagonotification.DBusException;
import net.java.sip.communicator.impl.galagonotification.GalagoNotification;
import net.java.sip.communicator.impl.galagonotification.GalagoNotificationActivator;
import net.java.sip.communicator.service.systray.AbstractPopupMessageHandler;
import net.java.sip.communicator.service.systray.PopupMessage;
import net.java.sip.communicator.util.Logger;

public class GalagoPopupMessageHandler
extends AbstractPopupMessageHandler {
    private static final Logger logger = Logger.getLogger(GalagoPopupMessageHandler.class);
    private final boolean iconStaticIsImplemented;

    public GalagoPopupMessageHandler(boolean iconStaticIsImplemented) {
        this.iconStaticIsImplemented = iconStaticIsImplemented;
    }

    private BufferedImage getIcon(PopupMessage popupMessage) {
        byte[] iconBytes = popupMessage.getIcon();
        BufferedImage icon = null;
        if (iconBytes != null && iconBytes.length > 0) {
            try {
                icon = ImageIO.read(new ByteArrayInputStream(iconBytes));
            }
            catch (IOException ioe) {
                logger.error((Object)"Failed to create BufferedImage from byte[].", (Throwable)ioe);
            }
        }
        return icon;
    }

    public int getPreferenceIndex() {
        int preferenceIndex = 1;
        if (this.iconStaticIsImplemented) {
            ++preferenceIndex;
        }
        return preferenceIndex;
    }

    public void showPopupMessage(PopupMessage popupMessage) {
        try {
            GalagoNotification.notify(GalagoNotificationActivator.dbusConnection, null, 0L, this.iconStaticIsImplemented ? this.getIcon(popupMessage) : null, popupMessage.getMessageTitle(), popupMessage.getMessage(), -1);
        }
        catch (DBusException dbe) {
            logger.error((Object)("Failed to show PopupMessage " + popupMessage), (Throwable)dbe);
        }
    }

    public String toString() {
        return GalagoNotificationActivator.getResources().getI18NString("impl.galagonotification.POPUP_MESSAGE_HANDLER");
    }
}

