/*
 * Decompiled with CFR 0.152.
 */
package com.ircclouds.irc.api.domain;

import com.ircclouds.irc.api.domain.IRCUserStatus;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

public class IRCUserStatuses
implements Iterable<IRCUserStatus> {
    private Set<IRCUserStatus> userStatuses;

    public IRCUserStatuses(Set<IRCUserStatus> aUserStatuses) {
        this.userStatuses = aUserStatuses;
    }

    public boolean isEmpty() {
        return this.userStatuses.isEmpty();
    }

    @Override
    public Iterator<IRCUserStatus> iterator() {
        return Collections.unmodifiableSet(this.userStatuses).iterator();
    }

    public boolean contains(Character aChanMode) {
        for (IRCUserStatus _ucs : this.userStatuses) {
            if (!_ucs.getChanModeType().equals(aChanMode)) continue;
            return true;
        }
        return false;
    }

    public IRCUserStatus getUserStatus(Character aChanMode) {
        for (IRCUserStatus _ucs : this.userStatuses) {
            if (!_ucs.getChanModeType().equals(aChanMode)) continue;
            return _ucs;
        }
        return null;
    }

    public static IRCUserStatus getDominantUserStatus(Set<IRCUserStatus> aUserStatuses) {
        IRCUserStatus _ucs = null;
        int _priority = Integer.MAX_VALUE;
        for (IRCUserStatus _tmp : aUserStatuses) {
            if (_tmp.getPriority() >= _priority) continue;
            _priority = _tmp.getPriority();
            _ucs = _tmp;
        }
        return _ucs;
    }

    public String toString() {
        return this.userStatuses.toString();
    }
}

