/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.replacement.dailymotion;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.java.sip.communicator.service.replacement.ReplacementService;
import net.java.sip.communicator.util.Logger;

public class ReplacementServiceDailymotionImpl
implements ReplacementService {
    private static final Logger logger = Logger.getLogger(ReplacementServiceDailymotionImpl.class);
    public static final String DAILYMOTION_PATTERN = "(https?\\:\\/\\/(www\\.)*?dailymotion\\.com\\/video\\/([a-zA-Z0-9_\\-]+))([?#]([a-zA-Z0-9_\\-]+))*";
    public static final String DAILYMOTION_CONFIG_LABEL = "Dailymotion";
    public static final String SOURCE_NAME = "DAILYMOTION";

    public ReplacementServiceDailymotionImpl() {
        logger.trace((Object)"Creating a DailyMotion Source.");
    }

    public String getReplacement(String sourceString) {
        Pattern p = Pattern.compile("(.+\\/video\\/([a-zA-Z0-9_\\-]+))([?#]([a-zA-Z0-9_\\-]+))*", 34);
        Matcher m = p.matcher(sourceString);
        String thumbUrl = sourceString;
        while (m.find()) {
            thumbUrl = "http://www.dailymotion.com/thumbnail/160x120/video/" + m.group(2);
        }
        return thumbUrl;
    }

    public String getSourceName() {
        return SOURCE_NAME;
    }

    public String getPattern() {
        return DAILYMOTION_PATTERN;
    }
}

