/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.mock;

import java.util.Date;
import java.util.EventObject;
import net.java.sip.communicator.impl.protocol.mock.MockMessage;
import net.java.sip.communicator.impl.protocol.mock.MockPersistentPresenceOperationSet;
import net.java.sip.communicator.impl.protocol.mock.MockProvider;
import net.java.sip.communicator.service.protocol.AbstractOperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.Message;
import net.java.sip.communicator.service.protocol.event.MessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.MessageReceivedEvent;

public class MockBasicInstantMessaging
extends AbstractOperationSetBasicInstantMessaging {
    private final MockPersistentPresenceOperationSet opSetPersPresence;
    private final MockProvider parentProvider;

    public MockBasicInstantMessaging(MockProvider provider, MockPersistentPresenceOperationSet opSetPersPresence) {
        this.opSetPersPresence = opSetPersPresence;
        this.parentProvider = provider;
    }

    public Message createMessage(String content, String contentType, String encoding, String subject) {
        return new MockMessage(content, contentType, encoding, subject);
    }

    public void sendInstantMessage(Contact to, Message message) throws IllegalStateException, IllegalArgumentException {
        this.fireMessageEvent((EventObject)new MessageDeliveredEvent(message, to, new Date()));
    }

    public boolean isOfflineMessagingSupported() {
        return true;
    }

    public boolean isContentTypeSupported(String contentType) {
        return contentType.equals("text/plain");
    }

    public void deliverMessage(String to, Message msg) {
        Contact sourceContact = this.opSetPersPresence.findContactByID(to);
        this.fireMessageEvent((EventObject)new MessageReceivedEvent(msg, sourceContact, new Date()));
    }
}

