/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.protocol.sip;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.EventObject;
import junit.framework.TestCase;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.CallPeerState;
import net.java.sip.communicator.service.protocol.CallState;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.event.CallChangeAdapter;
import net.java.sip.communicator.service.protocol.event.CallChangeEvent;
import net.java.sip.communicator.service.protocol.event.CallChangeListener;
import net.java.sip.communicator.service.protocol.event.CallEvent;
import net.java.sip.communicator.service.protocol.event.CallListener;
import net.java.sip.communicator.service.protocol.event.CallPeerAdapter;
import net.java.sip.communicator.service.protocol.event.CallPeerChangeEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerListener;
import net.java.sip.communicator.slick.protocol.sip.SipSlickFixture;
import net.java.sip.communicator.util.Logger;

public class TestOperationSetBasicTelephonySipImpl
extends TestCase {
    private static final Logger logger = Logger.getLogger(TestOperationSetBasicTelephonySipImpl.class);
    private SipSlickFixture fixture = new SipSlickFixture();

    public TestOperationSetBasicTelephonySipImpl(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.fixture.setUp();
    }

    protected void tearDown() throws Exception {
        this.fixture.tearDown();
        super.tearDown();
    }

    public void testCreateCancelCall() throws ParseException, OperationFailedException {
        OperationSetBasicTelephony basicTelephonyP1 = (OperationSetBasicTelephony)this.fixture.provider1.getOperationSet(OperationSetBasicTelephony.class);
        OperationSetBasicTelephony basicTelephonyP2 = (OperationSetBasicTelephony)this.fixture.provider2.getOperationSet(OperationSetBasicTelephony.class);
        CallEventCollector call1Listener = new CallEventCollector(basicTelephonyP1);
        CallEventCollector call2Listener = new CallEventCollector(basicTelephonyP2);
        String provider2Address = this.fixture.provider2.getAccountID().getAccountAddress();
        Call callAtP1 = basicTelephonyP1.createCall(provider2Address);
        call1Listener.waitForEvent(10000L);
        call2Listener.waitForEvent(10000L);
        TestOperationSetBasicTelephonySipImpl.assertEquals((String)"The provider that created the call did not dispatch an event that it has done so.", (int)1, (int)call1Listener.collectedEvents.size());
        CallEvent callCreatedEvent = (CallEvent)call1Listener.collectedEvents.get(0);
        TestOperationSetBasicTelephonySipImpl.assertEquals((String)"CallEvent.getEventID()", (int)1, (int)callCreatedEvent.getEventID());
        TestOperationSetBasicTelephonySipImpl.assertSame((String)"CallEvent.getSource()", (Object)callAtP1, (Object)callCreatedEvent.getSource());
        TestOperationSetBasicTelephonySipImpl.assertTrue((String)"The callee provider did not receive a call or did not issue an event.", (call2Listener.collectedEvents.size() > 0 ? 1 : 0) != 0);
        CallEvent callReceivedEvent = (CallEvent)call2Listener.collectedEvents.get(0);
        Call callAtP2 = callReceivedEvent.getSourceCall();
        TestOperationSetBasicTelephonySipImpl.assertEquals((String)"CallEvent.getEventID()", (int)2, (int)callReceivedEvent.getEventID());
        TestOperationSetBasicTelephonySipImpl.assertNotNull((String)"CallEvent.getSource()", (Object)callAtP2);
        TestOperationSetBasicTelephonySipImpl.assertEquals((String)"callAtP1.getCallPeerCount()", (int)1, (int)callAtP1.getCallPeerCount());
        TestOperationSetBasicTelephonySipImpl.assertEquals((String)"callAtP2.getCallPeerCount()", (int)1, (int)callAtP2.getCallPeerCount());
        CallPeer peerAtP1 = (CallPeer)callAtP1.getCallPeers().next();
        CallPeer peerAtP2 = (CallPeer)callAtP2.getCallPeers().next();
        CallPeerStateEventCollector stateCollectorForPp1 = new CallPeerStateEventCollector(peerAtP1, CallPeerState.ALERTING_REMOTE_SIDE);
        CallPeerStateEventCollector stateCollectorForPp2 = new CallPeerStateEventCollector(peerAtP2, CallPeerState.INCOMING_CALL);
        stateCollectorForPp1.waitForEvent(10000L, true);
        stateCollectorForPp2.waitForEvent(10000L, true);
        TestOperationSetBasicTelephonySipImpl.assertSame((String)"peerAtP1.getCall", (Object)peerAtP1.getCall(), (Object)callAtP1);
        TestOperationSetBasicTelephonySipImpl.assertSame((String)"peerAtP2.getCall", (Object)peerAtP2.getCall(), (Object)callAtP2);
        TestOperationSetBasicTelephonySipImpl.assertEquals((String)"The peer at provider one was not in the right state.", (Object)CallPeerState.ALERTING_REMOTE_SIDE, (Object)peerAtP1.getState());
        TestOperationSetBasicTelephonySipImpl.assertEquals((String)"The peer at provider two was not in the right state.", (Object)CallPeerState.INCOMING_CALL, (Object)peerAtP2.getState());
        if (Boolean.getBoolean("accounts.sip.PRESERVE_PEER_INFO")) {
            String expectedPeer1Address = this.fixture.provider2.getAccountID().getAccountAddress();
            String expectedPeer1DisplayName = System.getProperty("accounts.sip.account2.DISPLAY_NAME");
            TestOperationSetBasicTelephonySipImpl.assertTrue((String)"Provider 2 did not advertise their accountID.getAccoutAddress() address.", (expectedPeer1Address.indexOf(peerAtP1.getAddress()) != -1 || peerAtP1.getAddress().indexOf(expectedPeer1Address) != -1 ? 1 : 0) != 0);
            TestOperationSetBasicTelephonySipImpl.assertEquals((String)"Provider 2 did not properly advertise their display name.", (String)expectedPeer1DisplayName, (String)peerAtP1.getDisplayName());
            String expectedPeer2Address = this.fixture.provider1.getAccountID().getAccountAddress();
            String expectedPeer2DisplayName = System.getProperty("accounts.sip.account1.DISPLAY_NAME");
            TestOperationSetBasicTelephonySipImpl.assertTrue((String)"Provider 1 did not advertise their accountID.getAccoutAddress() address.", (expectedPeer2Address.indexOf(peerAtP2.getAddress()) != -1 || peerAtP2.getAddress().indexOf(expectedPeer2Address) != -1 ? 1 : 0) != 0);
            TestOperationSetBasicTelephonySipImpl.assertEquals((String)"Provider 1 did not properly advertise their display name.", (String)expectedPeer2DisplayName, (String)peerAtP2.getDisplayName());
        }
        stateCollectorForPp1 = new CallPeerStateEventCollector(peerAtP1, CallPeerState.DISCONNECTED);
        stateCollectorForPp2 = new CallPeerStateEventCollector(peerAtP2, CallPeerState.DISCONNECTED);
        call1Listener = new CallEventCollector(basicTelephonyP1);
        call2Listener = new CallEventCollector(basicTelephonyP2);
        CallStateEventCollector call1StateCollector = new CallStateEventCollector(callAtP1, CallState.CALL_ENDED);
        CallStateEventCollector call2StateCollector = new CallStateEventCollector(callAtP2, CallState.CALL_ENDED);
        basicTelephonyP1.hangupCallPeer(peerAtP1);
        call1Listener.waitForEvent(10000L);
        call2Listener.waitForEvent(10000L);
        stateCollectorForPp1.waitForEvent(10000L);
        stateCollectorForPp2.waitForEvent(10000L);
        call1StateCollector.waitForEvent(10000L);
        call2StateCollector.waitForEvent(10000L);
        TestOperationSetBasicTelephonySipImpl.assertEquals((String)"The peer at provider one was not in the right state.", (Object)CallPeerState.DISCONNECTED, (Object)peerAtP1.getState());
        TestOperationSetBasicTelephonySipImpl.assertEquals((String)"The basic telephony operation set did not distribute an event to notify us that a call has been ended.", (int)1, (int)call1Listener.collectedEvents.size());
        CallEvent collectedEvent = (CallEvent)call1Listener.collectedEvents.get(0);
        TestOperationSetBasicTelephonySipImpl.assertEquals((String)"The basic telephony operation set did not distribute an event to notify us that a call has been ended.", (int)3, (int)collectedEvent.getEventID());
        TestOperationSetBasicTelephonySipImpl.assertEquals((String)"The peer at provider one was not in the right state.", (Object)CallPeerState.DISCONNECTED, (Object)peerAtP2.getState());
        TestOperationSetBasicTelephonySipImpl.assertEquals((String)"The basic telephony operation set did not distribute an event to notify us that a call has been ended.", (int)1, (int)call2Listener.collectedEvents.size());
        collectedEvent = (CallEvent)call2Listener.collectedEvents.get(0);
        TestOperationSetBasicTelephonySipImpl.assertEquals((String)"The basic telephony operation set did not distribute an event to notify us that a call has been ended.", (int)3, (int)collectedEvent.getEventID());
        TestOperationSetBasicTelephonySipImpl.assertEquals((String)"A call did not change its state to CallState.CALL_ENDED when it ended.", (Object)CallState.CALL_ENDED, (Object)callAtP1.getCallState());
        TestOperationSetBasicTelephonySipImpl.assertEquals((String)"A call did not change its state to CallState.CALL_ENDED when it ended.", (Object)CallState.CALL_ENDED, (Object)callAtP2.getCallState());
    }

    public void testCreateRejectCall() throws ParseException, OperationFailedException {
        OperationSetBasicTelephony basicTelephonyP1 = (OperationSetBasicTelephony)this.fixture.provider1.getOperationSet(OperationSetBasicTelephony.class);
        OperationSetBasicTelephony basicTelephonyP2 = (OperationSetBasicTelephony)this.fixture.provider2.getOperationSet(OperationSetBasicTelephony.class);
        CallEventCollector call1Listener = new CallEventCollector(basicTelephonyP1);
        CallEventCollector call2Listener = new CallEventCollector(basicTelephonyP2);
        String provider2Address = this.fixture.provider2.getAccountID().getAccountAddress();
        Call callAtP1 = basicTelephonyP1.createCall(provider2Address);
        call1Listener.waitForEvent(10000L);
        call2Listener.waitForEvent(10000L);
        TestOperationSetBasicTelephonySipImpl.assertEquals((String)"The provider that created the call did not dispatch an event that it has done so.", (int)1, (int)call1Listener.collectedEvents.size());
        CallEvent callCreatedEvent = (CallEvent)call1Listener.collectedEvents.get(0);
        TestOperationSetBasicTelephonySipImpl.assertEquals((String)"CallEvent.getEventID()", (int)1, (int)callCreatedEvent.getEventID());
        TestOperationSetBasicTelephonySipImpl.assertSame((String)"CallEvent.getSource()", (Object)callAtP1, (Object)callCreatedEvent.getSource());
        TestOperationSetBasicTelephonySipImpl.assertTrue((String)"The callee provider did not receive a call or did not issue an event.", (call2Listener.collectedEvents.size() > 0 ? 1 : 0) != 0);
        CallEvent callReceivedEvent = (CallEvent)call2Listener.collectedEvents.get(0);
        Call callAtP2 = callReceivedEvent.getSourceCall();
        TestOperationSetBasicTelephonySipImpl.assertEquals((String)"CallEvent.getEventID()", (int)2, (int)callReceivedEvent.getEventID());
        TestOperationSetBasicTelephonySipImpl.assertNotNull((String)"CallEvent.getSource()", (Object)callAtP2);
        TestOperationSetBasicTelephonySipImpl.assertEquals((String)"callAtP1.getCallPeerCount()", (int)1, (int)callAtP1.getCallPeerCount());
        TestOperationSetBasicTelephonySipImpl.assertEquals((String)"callAtP2.getCallPeerCount()", (int)1, (int)callAtP2.getCallPeerCount());
        CallPeer peerAtP1 = (CallPeer)callAtP1.getCallPeers().next();
        CallPeer peerAtP2 = (CallPeer)callAtP2.getCallPeers().next();
        CallPeerStateEventCollector stateCollectorForPp1 = new CallPeerStateEventCollector(peerAtP1, CallPeerState.ALERTING_REMOTE_SIDE);
        CallPeerStateEventCollector stateCollectorForPp2 = new CallPeerStateEventCollector(peerAtP2, CallPeerState.INCOMING_CALL);
        stateCollectorForPp1.waitForEvent(10000L, true);
        stateCollectorForPp2.waitForEvent(10000L, true);
        TestOperationSetBasicTelephonySipImpl.assertSame((String)"peerAtP1.getCall", (Object)peerAtP1.getCall(), (Object)callAtP1);
        TestOperationSetBasicTelephonySipImpl.assertSame((String)"peerAtP2.getCall", (Object)peerAtP2.getCall(), (Object)callAtP2);
        TestOperationSetBasicTelephonySipImpl.assertEquals((String)"The peer at provider one was not in the right state.", (Object)CallPeerState.ALERTING_REMOTE_SIDE, (Object)peerAtP1.getState());
        TestOperationSetBasicTelephonySipImpl.assertEquals((String)"The peer at provider two was not in the right state.", (Object)CallPeerState.INCOMING_CALL, (Object)peerAtP2.getState());
        if (Boolean.getBoolean("accounts.sip.PRESERVE_PEER_INFO")) {
            String expectedPeer1Address = this.fixture.provider2.getAccountID().getAccountAddress();
            String expectedPeer1DisplayName = System.getProperty("accounts.sip.account2.DISPLAY_NAME");
            TestOperationSetBasicTelephonySipImpl.assertTrue((String)"Provider 2 did not advertise their accountID.getAccoutAddress() address.", (expectedPeer1Address.indexOf(peerAtP1.getAddress()) != -1 || peerAtP1.getAddress().indexOf(expectedPeer1Address) != -1 ? 1 : 0) != 0);
            TestOperationSetBasicTelephonySipImpl.assertEquals((String)"Provider 2 did not properly advertise their display name.", (String)expectedPeer1DisplayName, (String)peerAtP1.getDisplayName());
            String expectedPeer2Address = this.fixture.provider1.getAccountID().getAccountAddress();
            String expectedPeer2DisplayName = System.getProperty("accounts.sip.account1.DISPLAY_NAME");
            TestOperationSetBasicTelephonySipImpl.assertTrue((String)"Provider 1 did not advertise their accountID.getAccoutAddress() address.", (expectedPeer2Address.indexOf(peerAtP2.getAddress()) != -1 || peerAtP2.getAddress().indexOf(expectedPeer2Address) != -1 ? 1 : 0) != 0);
            TestOperationSetBasicTelephonySipImpl.assertEquals((String)"Provider 1 did not properly advertise their display name.", (String)expectedPeer2DisplayName, (String)peerAtP2.getDisplayName());
        }
        CallPeerStateEventCollector busyStateCollectorForPp1 = new CallPeerStateEventCollector(peerAtP1, CallPeerState.BUSY);
        stateCollectorForPp1 = new CallPeerStateEventCollector(peerAtP1, CallPeerState.DISCONNECTED);
        stateCollectorForPp2 = new CallPeerStateEventCollector(peerAtP2, CallPeerState.DISCONNECTED);
        call1Listener = new CallEventCollector(basicTelephonyP1);
        call2Listener = new CallEventCollector(basicTelephonyP2);
        CallStateEventCollector call1StateCollector = new CallStateEventCollector(callAtP1, CallState.CALL_ENDED);
        CallStateEventCollector call2StateCollector = new CallStateEventCollector(callAtP2, CallState.CALL_ENDED);
        basicTelephonyP2.hangupCallPeer(peerAtP2);
        busyStateCollectorForPp1.waitForEvent(10000L);
        basicTelephonyP1.hangupCallPeer(peerAtP1);
        call1Listener.waitForEvent(10000L);
        call2Listener.waitForEvent(10000L);
        stateCollectorForPp1.waitForEvent(10000L);
        stateCollectorForPp2.waitForEvent(10000L);
        call1StateCollector.waitForEvent(10000L);
        call2StateCollector.waitForEvent(10000L);
        TestOperationSetBasicTelephonySipImpl.assertEquals((String)"The peer at provider one was not in the right state.", (Object)CallPeerState.DISCONNECTED, (Object)peerAtP1.getState());
        TestOperationSetBasicTelephonySipImpl.assertEquals((String)"The basic telephony operation set did not distribute an event to notify us that a call has been ended.", (int)1, (int)call1Listener.collectedEvents.size());
        CallEvent collectedEvent = (CallEvent)call1Listener.collectedEvents.get(0);
        TestOperationSetBasicTelephonySipImpl.assertEquals((String)"The basic telephony operation set did not distribute an event to notify us that a call has been ended.", (int)3, (int)collectedEvent.getEventID());
        TestOperationSetBasicTelephonySipImpl.assertEquals((String)"The peer at provider one was not in the right state.", (Object)CallPeerState.DISCONNECTED, (Object)peerAtP2.getState());
        TestOperationSetBasicTelephonySipImpl.assertEquals((String)"The basic telephony operation set did not distribute an event to notify us that a call has been ended.", (int)1, (int)call2Listener.collectedEvents.size());
        collectedEvent = (CallEvent)call2Listener.collectedEvents.get(0);
        TestOperationSetBasicTelephonySipImpl.assertEquals((String)"The basic telephony operation set did not distribute an event to notify us that a call has been ended.", (int)3, (int)collectedEvent.getEventID());
        TestOperationSetBasicTelephonySipImpl.assertEquals((String)"A call did not change its state to CallState.CALL_ENDED when it ended.", (Object)CallState.CALL_ENDED, (Object)callAtP1.getCallState());
        TestOperationSetBasicTelephonySipImpl.assertEquals((String)"A call did not change its state to CallState.CALL_ENDED when it ended.", (Object)CallState.CALL_ENDED, (Object)callAtP2.getCallState());
    }

    public void aTestCreateAnswerHangupCall() throws ParseException, OperationFailedException {
        OperationSetBasicTelephony basicTelephonyP1 = (OperationSetBasicTelephony)this.fixture.provider1.getOperationSet(OperationSetBasicTelephony.class);
        OperationSetBasicTelephony basicTelephonyP2 = (OperationSetBasicTelephony)this.fixture.provider2.getOperationSet(OperationSetBasicTelephony.class);
        CallEventCollector call1Listener = new CallEventCollector(basicTelephonyP1);
        CallEventCollector call2Listener = new CallEventCollector(basicTelephonyP2);
        String provider2Address = this.fixture.provider2.getAccountID().getAccountAddress();
        Call callAtP1 = basicTelephonyP1.createCall(provider2Address);
        call1Listener.waitForEvent(10000L);
        call2Listener.waitForEvent(10000L);
        TestOperationSetBasicTelephonySipImpl.assertEquals((String)"The provider that created the call did not dispatch an event that it has done so.", (int)1, (int)call1Listener.collectedEvents.size());
        CallEvent callCreatedEvent = (CallEvent)call1Listener.collectedEvents.get(0);
        TestOperationSetBasicTelephonySipImpl.assertEquals((String)"CallEvent.getEventID()", (int)1, (int)callCreatedEvent.getEventID());
        TestOperationSetBasicTelephonySipImpl.assertSame((String)"CallEvent.getSource()", (Object)callAtP1, (Object)callCreatedEvent.getSource());
        TestOperationSetBasicTelephonySipImpl.assertTrue((String)"The callee provider did not receive a call or did not issue an event.", (call2Listener.collectedEvents.size() > 0 ? 1 : 0) != 0);
        CallEvent callReceivedEvent = (CallEvent)call2Listener.collectedEvents.get(0);
        Call callAtP2 = callReceivedEvent.getSourceCall();
        TestOperationSetBasicTelephonySipImpl.assertEquals((String)"CallEvent.getEventID()", (int)2, (int)callReceivedEvent.getEventID());
        TestOperationSetBasicTelephonySipImpl.assertNotNull((String)"CallEvent.getSource()", (Object)callAtP2);
        TestOperationSetBasicTelephonySipImpl.assertEquals((String)"callAtP1.getCallpeersCount()", (int)1, (int)callAtP1.getCallPeerCount());
        TestOperationSetBasicTelephonySipImpl.assertEquals((String)"callAtP2.getCallpeersCount()", (int)1, (int)callAtP2.getCallPeerCount());
        CallPeer peerAtP1 = (CallPeer)callAtP1.getCallPeers().next();
        CallPeer peerAtP2 = (CallPeer)callAtP2.getCallPeers().next();
        CallPeerStateEventCollector stateCollectorForPp1 = new CallPeerStateEventCollector(peerAtP1, CallPeerState.ALERTING_REMOTE_SIDE);
        CallPeerStateEventCollector stateCollectorForPp2 = new CallPeerStateEventCollector(peerAtP2, CallPeerState.INCOMING_CALL);
        stateCollectorForPp1.waitForEvent(10000L, true);
        stateCollectorForPp2.waitForEvent(10000L, true);
        TestOperationSetBasicTelephonySipImpl.assertSame((String)"peerAtP1.getCall", (Object)peerAtP1.getCall(), (Object)callAtP1);
        TestOperationSetBasicTelephonySipImpl.assertSame((String)"peerAtP2.getCall", (Object)peerAtP2.getCall(), (Object)callAtP2);
        TestOperationSetBasicTelephonySipImpl.assertEquals((String)"The peer at provider one was not in the right state.", (Object)CallPeerState.ALERTING_REMOTE_SIDE, (Object)peerAtP1.getState());
        TestOperationSetBasicTelephonySipImpl.assertEquals((String)"The peer at provider two was not in the right state.", (Object)CallPeerState.INCOMING_CALL, (Object)peerAtP2.getState());
        if (Boolean.getBoolean("accounts.sip.PRESERVE_PEER_INFO")) {
            String expectedPeer1Address = this.fixture.provider2.getAccountID().getAccountAddress();
            String expectedPeer1DisplayName = System.getProperty("accounts.sip.account2.DISPLAY_NAME");
            TestOperationSetBasicTelephonySipImpl.assertTrue((String)"Provider 2 did not advertise their accountID.getAccoutAddress() address.", (expectedPeer1Address.indexOf(peerAtP1.getAddress()) != -1 || peerAtP1.getAddress().indexOf(expectedPeer1Address) != -1 ? 1 : 0) != 0);
            TestOperationSetBasicTelephonySipImpl.assertEquals((String)"Provider 2 did not properly advertise their display name.", (String)expectedPeer1DisplayName, (String)peerAtP1.getDisplayName());
            String expectedPeer2Address = this.fixture.provider1.getAccountID().getAccountAddress();
            String expectedPeer2DisplayName = System.getProperty("accounts.sip.account1.DISPLAY_NAME");
            TestOperationSetBasicTelephonySipImpl.assertTrue((String)"Provider 1 did not advertise their accountID.getAccoutAddress() address.", (expectedPeer2Address.indexOf(peerAtP2.getAddress()) != -1 || peerAtP2.getAddress().indexOf(expectedPeer2Address) != -1 ? 1 : 0) != 0);
            TestOperationSetBasicTelephonySipImpl.assertEquals((String)"Provider 1 did not properly advertise their display name.", (String)expectedPeer2DisplayName, (String)peerAtP2.getDisplayName());
        }
        stateCollectorForPp1 = new CallPeerStateEventCollector(peerAtP1, CallPeerState.CONNECTED);
        stateCollectorForPp2 = new CallPeerStateEventCollector(peerAtP2, CallPeerState.CONNECTED);
        basicTelephonyP2.answerCallPeer(peerAtP2);
        stateCollectorForPp1.waitForEvent(10000L);
        stateCollectorForPp2.waitForEvent(10000L);
        TestOperationSetBasicTelephonySipImpl.assertEquals((String)"The peer at provider one was not in the right state.", (Object)CallPeerState.CONNECTED, (Object)peerAtP1.getState());
        TestOperationSetBasicTelephonySipImpl.assertEquals((String)"The peer at provider two was not in the right state.", (Object)CallPeerState.CONNECTED, (Object)peerAtP2.getState());
        TestOperationSetBasicTelephonySipImpl.assertEquals((String)"No event was dispatched when a call peer changed its state.", (int)1, (int)stateCollectorForPp1.collectedEvents.size());
        TestOperationSetBasicTelephonySipImpl.assertEquals((String)"No event was dispatched when a call peer changed its state.", (int)1, (int)stateCollectorForPp2.collectedEvents.size());
        stateCollectorForPp1 = new CallPeerStateEventCollector(peerAtP1, CallPeerState.DISCONNECTED);
        stateCollectorForPp2 = new CallPeerStateEventCollector(peerAtP2, CallPeerState.DISCONNECTED);
        basicTelephonyP2.hangupCallPeer(peerAtP2);
        stateCollectorForPp1.waitForEvent(10000L);
        stateCollectorForPp2.waitForEvent(10000L);
        TestOperationSetBasicTelephonySipImpl.assertEquals((String)"The peer at provider one was not in the right state.", (Object)CallPeerState.DISCONNECTED, (Object)peerAtP1.getState());
        TestOperationSetBasicTelephonySipImpl.assertEquals((String)"The peer at provider two was not in the right state.", (Object)CallPeerState.DISCONNECTED, (Object)peerAtP2.getState());
        TestOperationSetBasicTelephonySipImpl.assertEquals((String)"a provider did not distribute an event when a call peer changed states.", (int)1, (int)stateCollectorForPp1.collectedEvents.size());
        TestOperationSetBasicTelephonySipImpl.assertEquals((String)"a provider did not distribute an event when a call peer changed states.", (int)1, (int)stateCollectorForPp2.collectedEvents.size());
    }

    public class CallStateEventCollector
    extends CallChangeAdapter {
        public ArrayList<EventObject> collectedEvents = new ArrayList();
        private Call listenedCall = null;
        public CallState awaitedState = null;

        public CallStateEventCollector(Call call, CallState awaitedState) {
            this.listenedCall = call;
            this.listenedCall.addCallChangeListener((CallChangeListener)this);
            this.awaitedState = awaitedState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void callStateChanged(CallChangeEvent event) {
            CallStateEventCollector callStateEventCollector = this;
            synchronized (callStateEventCollector) {
                logger.debug((Object)("Collected evt(" + this.collectedEvents.size() + ")= " + event));
                if (((CallState)event.getNewValue()).equals(this.awaitedState)) {
                    this.collectedEvents.add((EventObject)event);
                    ((Object)((Object)this)).notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForEvent(long waitFor) {
            logger.trace((Object)"Waiting for a CallParticpantEvent");
            CallStateEventCollector callStateEventCollector = this;
            synchronized (callStateEventCollector) {
                if (this.listenedCall.getCallState() == this.awaitedState) {
                    logger.trace((Object)("Event already received. " + this.collectedEvents));
                    this.listenedCall.removeCallChangeListener((CallChangeListener)this);
                    return;
                }
                try {
                    ((Object)((Object)this)).wait(waitFor);
                    if (this.collectedEvents.size() > 0) {
                        logger.trace((Object)"Received a CallChangeEvent.");
                    } else {
                        logger.trace((Object)("No CallChangeEvent received for " + waitFor + "ms."));
                    }
                    this.listenedCall.removeCallChangeListener((CallChangeListener)this);
                }
                catch (InterruptedException ex) {
                    logger.debug((Object)"Interrupted while waiting for a CallParticpantEvent", (Throwable)ex);
                }
            }
        }
    }

    public class CallPeerStateEventCollector
    extends CallPeerAdapter {
        public ArrayList<EventObject> collectedEvents = new ArrayList();
        private CallPeer listenedCallPeer = null;
        public CallPeerState awaitedState = null;

        public CallPeerStateEventCollector(CallPeer callPeer, CallPeerState awaitedState) {
            this.listenedCallPeer = callPeer;
            this.listenedCallPeer.addCallPeerListener((CallPeerListener)this);
            this.awaitedState = awaitedState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void peerStateChanged(CallPeerChangeEvent event) {
            CallPeerStateEventCollector callPeerStateEventCollector = this;
            synchronized (callPeerStateEventCollector) {
                logger.debug((Object)("Collected evt(" + this.collectedEvents.size() + ")= " + event));
                if (((CallPeerState)event.getNewValue()).equals(this.awaitedState)) {
                    this.collectedEvents.add((EventObject)event);
                    ((Object)((Object)this)).notifyAll();
                }
            }
        }

        public void waitForEvent(long waitFor) {
            this.waitForEvent(waitFor, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForEvent(long waitFor, boolean exitIfAlreadyInState) {
            logger.trace((Object)("Waiting for a CallPeerEvent with newState=" + this.awaitedState + " for peer " + this.listenedCallPeer));
            CallPeerStateEventCollector callPeerStateEventCollector = this;
            synchronized (callPeerStateEventCollector) {
                CallPeerChangeEvent lastEvent;
                if (exitIfAlreadyInState && this.listenedCallPeer.getState().equals(this.awaitedState)) {
                    logger.trace((Object)("Src peer is already in the awaited state." + this.collectedEvents));
                    this.listenedCallPeer.removeCallPeerListener((CallPeerListener)this);
                    return;
                }
                if (this.collectedEvents.size() > 0 && (lastEvent = (CallPeerChangeEvent)this.collectedEvents.get(this.collectedEvents.size() - 1)).getNewValue().equals(this.awaitedState)) {
                    logger.trace((Object)("Event already received. " + this.collectedEvents));
                    this.listenedCallPeer.removeCallPeerListener((CallPeerListener)this);
                    return;
                }
                try {
                    ((Object)((Object)this)).wait(waitFor);
                    if (this.collectedEvents.size() > 0) {
                        logger.trace((Object)"Received a CallParticpantStateEvent.");
                    } else {
                        logger.trace((Object)("No CallParticpantStateEvent received for " + waitFor + "ms."));
                    }
                    this.listenedCallPeer.removeCallPeerListener((CallPeerListener)this);
                }
                catch (InterruptedException ex) {
                    logger.debug((Object)"Interrupted while waiting for a CallParticpantEvent", (Throwable)ex);
                }
            }
        }
    }

    public class CallEventCollector
    implements CallListener {
        public ArrayList<EventObject> collectedEvents = new ArrayList();
        public OperationSetBasicTelephony<?> listenedOpSet = null;

        public CallEventCollector(OperationSetBasicTelephony<?> listenedOpSet) {
            this.listenedOpSet = listenedOpSet;
            this.listenedOpSet.addCallListener((CallListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForEvent(long waitFor) {
            logger.trace((Object)"Waiting for a CallEvent");
            CallEventCollector callEventCollector = this;
            synchronized (callEventCollector) {
                if (this.collectedEvents.size() > 0) {
                    logger.trace((Object)("Event already received. " + this.collectedEvents));
                    this.listenedOpSet.removeCallListener((CallListener)this);
                    return;
                }
                try {
                    this.wait(waitFor);
                    if (this.collectedEvents.size() > 0) {
                        logger.trace((Object)"Received a CallEvent.");
                    } else {
                        logger.trace((Object)("No CallEvent received for " + waitFor + "ms."));
                    }
                    this.listenedOpSet.removeCallListener((CallListener)this);
                }
                catch (InterruptedException ex) {
                    logger.debug((Object)"Interrupted while waiting for a call event", (Throwable)ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void incomingCallReceived(CallEvent event) {
            CallEventCollector callEventCollector = this;
            synchronized (callEventCollector) {
                logger.debug((Object)("Collected evt(" + this.collectedEvents.size() + ")= " + event));
                this.collectedEvents.add((EventObject)event);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void outgoingCallCreated(CallEvent event) {
            CallEventCollector callEventCollector = this;
            synchronized (callEventCollector) {
                logger.debug((Object)("Collected evt(" + this.collectedEvents.size() + ")= " + event));
                this.collectedEvents.add((EventObject)event);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void callEnded(CallEvent event) {
            CallEventCollector callEventCollector = this;
            synchronized (callEventCollector) {
                logger.debug((Object)("Collected evt(" + this.collectedEvents.size() + ")= " + event));
                this.collectedEvents.add((EventObject)event);
                this.notifyAll();
            }
        }
    }
}

