/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.resources.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.java.sip.communicator.service.resources.ResourcePack;

public class SkinJarBuilder {
    public static File createBundleFromZip(File zip, ResourcePack srv) throws Exception {
        File tmpDir = SkinJarBuilder.unzipIntoTmp(zip);
        File tmpDir2 = SkinJarBuilder.findBase(tmpDir);
        if (tmpDir2 == null) {
            tmpDir2 = tmpDir;
        }
        if (!SkinJarBuilder.test(tmpDir2)) {
            SkinJarBuilder.deleteDir(tmpDir);
            throw new Exception("Zip file doesn't contain all necessary files and folders.");
        }
        SkinJarBuilder.cpTmp(tmpDir2, srv);
        File jar = SkinJarBuilder.insertIntoZip(tmpDir2);
        SkinJarBuilder.deleteDir(tmpDir);
        return jar;
    }

    private static void cpTmp(File unzippedBase, ResourcePack srv) throws IOException {
        InputStream in = srv.getClass().getClassLoader().getResourceAsStream("resources/skinresourcepack/SkinResourcePack.class");
        File dest = new File(unzippedBase, "net" + File.separatorChar + "java" + File.separatorChar + "sip" + File.separatorChar + "communicator" + File.separatorChar + "plugin" + File.separatorChar + "skinresourcepack");
        if (!dest.mkdirs()) {
            throw new IOException("Unable to build resource pack.");
        }
        FileOutputStream out = new FileOutputStream(new File(dest, "SkinResourcePack.class"));
        SkinJarBuilder.copy(in, out);
        in = srv.getClass().getClassLoader().getResourceAsStream("resources/skinresourcepack/skinresourcepack.manifest.mf");
        dest = new File(unzippedBase, "META-INF");
        if (!dest.mkdirs()) {
            throw new IOException("Unable to build resource pack.");
        }
        out = new FileOutputStream(new File(dest, "MANIFEST.MF"));
        SkinJarBuilder.copy(in, out);
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        in.close();
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File unzipIntoTmp(File zip) throws IOException {
        File dest = File.createTempFile("zip", null);
        if (!dest.delete()) {
            throw new IOException("Cannot unzip given zip file");
        }
        if (!dest.mkdirs()) {
            throw new IOException("Cannot unzip given zip file");
        }
        try (ZipFile archive = new ZipFile(zip);){
            Enumeration<? extends ZipEntry> e = archive.entries();
            if (e.hasMoreElements()) {
                byte[] buffer = new byte[8192];
                while (e.hasMoreElements()) {
                    ZipEntry entry = e.nextElement();
                    File file = new File(dest, entry.getName());
                    if (entry.isDirectory() && !file.exists()) {
                        file.mkdirs();
                        continue;
                    }
                    File parentFile = file.getParentFile();
                    if (!parentFile.exists()) {
                        parentFile.mkdirs();
                    }
                    try (InputStream in = archive.getInputStream(entry);
                         BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
                        int read;
                        while (-1 != (read = in.read(buffer))) {
                            out.write(buffer, 0, read);
                        }
                    }
                }
            }
        }
        return dest;
    }

    private static File insertIntoZip(File tmpDir) throws IOException {
        File jar = File.createTempFile("skinresourcepack", ".jar");
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(jar));
        SkinJarBuilder.zipDir(tmpDir.getAbsolutePath(), out);
        out.close();
        return jar;
    }

    private static void zipDir(String dir2zip, ZipOutputStream zos) throws IOException {
        File directory = new File(dir2zip);
        SkinJarBuilder.zip(directory, directory, zos);
    }

    private static final void zip(File directory, File base, ZipOutputStream zos) throws IOException {
        File[] files = directory.listFiles();
        byte[] buffer = new byte[8192];
        int read = 0;
        int n = files.length;
        for (int i = 0; i < n; ++i) {
            if (files[i].isDirectory()) {
                SkinJarBuilder.zip(files[i], base, zos);
                continue;
            }
            FileInputStream in = new FileInputStream(files[i]);
            ZipEntry entry = new ZipEntry(files[i].getPath().substring(base.getPath().length() + 1));
            zos.putNextEntry(entry);
            while (-1 != (read = in.read(buffer))) {
                zos.write(buffer, 0, read);
            }
            in.close();
        }
    }

    private static void deleteDir(File tmp) {
        if (tmp.exists()) {
            File[] files = tmp.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    SkinJarBuilder.deleteDir(files[i]);
                    continue;
                }
                files[i].delete();
            }
            tmp.delete();
        }
    }

    private static boolean test(File tmpDir) {
        boolean colors = false;
        boolean images = false;
        boolean styles = false;
        File[] list = tmpDir.listFiles();
        if (list == null) {
            return false;
        }
        for (File f : list) {
            File[] ff;
            if (f.getName().equals("info.properties")) {
                if (f.isFile()) continue;
                return false;
            }
            if (f.getName().equals("colors")) {
                if (f.isFile()) {
                    return false;
                }
                ff = f.listFiles();
                if (ff == null) {
                    return false;
                }
                for (File x : ff) {
                    if (!x.getName().equals("colors.properties")) continue;
                    colors = true;
                }
                continue;
            }
            if (f.getName().equals("images")) {
                if (f.isFile()) {
                    return false;
                }
                ff = f.listFiles();
                if (ff == null) {
                    return false;
                }
                for (File x : ff) {
                    if (!x.getName().equals("images.properties")) continue;
                    images = true;
                }
                continue;
            }
            if (!f.getName().equals("styles")) continue;
            if (f.isFile()) {
                return false;
            }
            ff = f.listFiles();
            if (ff == null) {
                return false;
            }
            for (File x : ff) {
                if (!x.getName().equals("styles.properties")) continue;
                styles = true;
            }
        }
        return styles || colors || images;
    }

    private static File findBase(File tmpDir) {
        File[] list = tmpDir.listFiles();
        if (list == null) {
            return null;
        }
        boolean test = false;
        for (File f : list) {
            if (!f.getName().equals("info.properties") || !f.isFile()) continue;
            test = true;
        }
        if (!test) {
            if (list.length != 0) {
                File tmp = null;
                for (File f : list) {
                    File tmp2;
                    if (!f.isDirectory() || (tmp2 = SkinJarBuilder.findBase(f)) == null || tmp != null) continue;
                    tmp = tmp2;
                }
                return tmp;
            }
            return null;
        }
        return tmpDir;
    }
}

