/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.googlecontacts;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.java.sip.communicator.impl.googlecontacts.GoogleContactsActivator;
import net.java.sip.communicator.impl.googlecontacts.GoogleContactsConnectionImpl;
import net.java.sip.communicator.impl.googlecontacts.GoogleContactsQuery;
import net.java.sip.communicator.impl.googlecontacts.configform.AccountSettingsForm;
import net.java.sip.communicator.service.contactsource.ContactQuery;
import net.java.sip.communicator.service.contactsource.ExtendedContactSourceService;
import net.java.sip.communicator.service.contactsource.PrefixedContactSourceService;
import net.java.sip.communicator.service.googlecontacts.GoogleContactsConnection;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.NetworkUtils;
import net.java.sip.communicator.util.SRVRecord;

public class GoogleContactsSourceService
implements ExtendedContactSourceService,
PrefixedContactSourceService {
    private static final Logger logger = Logger.getLogger(GoogleContactsSourceService.class);
    private final List<GoogleContactsQuery> queries = new LinkedList<GoogleContactsQuery>();
    private final String login;
    private String phoneNumberprefix;
    private GoogleContactsConnection cnx = null;
    private AccountSettingsForm settings = null;
    private boolean googleTalk = false;

    public GoogleContactsSourceService(String login) {
        this.login = login;
    }

    public GoogleContactsSourceService(GoogleContactsConnection cnx) {
        this.cnx = cnx;
        this.login = cnx.getLogin();
        this.phoneNumberprefix = cnx.getPrefix();
    }

    public String getLogin() {
        return this.login;
    }

    public void setGoogleTalk(boolean googleTalk) {
        this.googleTalk = googleTalk;
    }

    public boolean isGoogleTalk() {
        return this.googleTalk;
    }

    public ContactQuery createContactQuery(Pattern queryPattern) {
        return this.createContactQuery(queryPattern, 20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContactQuery createContactQuery(Pattern queryPattern, int count) {
        GoogleContactsQuery query = new GoogleContactsQuery(this, queryPattern, count);
        List<GoogleContactsQuery> list = this.queries;
        synchronized (list) {
            this.queries.add(query);
        }
        return query;
    }

    public synchronized void removeQuery(ContactQuery query) {
        if (this.queries.remove(query)) {
            this.queries.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GoogleContactsConnectionImpl getConnection() {
        block20: {
            int s = this.login.indexOf(64);
            boolean isGoogleAppsOrGmail = false;
            if (s == -1) {
                return null;
            }
            String domain = this.login.substring(s + 1);
            try {
                SRVRecord[] srvRecords = NetworkUtils.getSRVRecords((String)"xmpp-client", (String)"tcp", (String)domain);
                if (srvRecords != null) {
                    for (SRVRecord srv : srvRecords) {
                        if (!srv.getTarget().endsWith("google.com") && !srv.getTarget().endsWith("google.com.")) continue;
                        isGoogleAppsOrGmail = true;
                        break;
                    }
                }
                if (!isGoogleAppsOrGmail) {
                    isGoogleAppsOrGmail = this.googleTalk;
                }
                if (isGoogleAppsOrGmail) {
                    if (this.cnx == null) {
                        this.cnx = new GoogleContactsConnectionImpl(this.login);
                        if (this.cnx.connect() != GoogleContactsConnection.ConnectionStatus.ERROR_INVALID_CREDENTIALS) break block20;
                        GoogleContactsSourceService googleContactsSourceService = this;
                        synchronized (googleContactsSourceService) {
                            if (this.settings != null) {
                                this.cnx = null;
                                return null;
                            }
                            this.settings = new AccountSettingsForm();
                        }
                        this.settings.setModal(true);
                        this.settings.loadData(this.cnx);
                        int n = this.settings.showDialog();
                        if (n == 1) {
                            this.cnx = this.settings.getConnection();
                            GoogleContactsActivator.getGoogleContactsService().saveConfig(this.cnx);
                        } else {
                            this.cnx = null;
                        }
                        break block20;
                    }
                    if (this.cnx.connect() != GoogleContactsConnection.ConnectionStatus.ERROR_INVALID_CREDENTIALS) break block20;
                    GoogleContactsSourceService googleContactsSourceService = this;
                    synchronized (googleContactsSourceService) {
                        if (this.settings != null) {
                            this.cnx = null;
                            return null;
                        }
                        this.settings = new AccountSettingsForm();
                    }
                    this.settings.setModal(true);
                    this.settings.loadData(this.cnx);
                    int n = this.settings.showDialog();
                    if (n == 1) {
                        this.cnx = this.settings.getConnection();
                        GoogleContactsActivator.getGoogleContactsService().saveConfig(this.cnx);
                    } else {
                        this.cnx = null;
                    }
                    break block20;
                }
                this.cnx = null;
            }
            catch (Exception e) {
                logger.info((Object)"GoogleContacts connection error", (Throwable)e);
                return null;
            }
        }
        return (GoogleContactsConnectionImpl)this.cnx;
    }

    public String getDisplayName() {
        return this.login;
    }

    public int getType() {
        return 1;
    }

    public ContactQuery createContactQuery(String query) {
        return this.createContactQuery(query, 20);
    }

    public ContactQuery createContactQuery(String query, int contactCount) {
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(query);
        }
        catch (PatternSyntaxException pse) {
            pattern = Pattern.compile(Pattern.quote(query));
        }
        if (pattern != null) {
            return this.createContactQuery(pattern, contactCount);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        boolean interrupted = false;
        List<GoogleContactsQuery> list = this.queries;
        synchronized (list) {
            while (!this.queries.isEmpty()) {
                this.queries.get(0).cancel();
                try {
                    this.queries.wait();
                }
                catch (InterruptedException iex) {
                    interrupted = true;
                }
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopped(GoogleContactsQuery query) {
        List<GoogleContactsQuery> list = this.queries;
        synchronized (list) {
            if (this.queries.remove((Object)query)) {
                this.queries.notify();
            }
        }
    }

    public String getPhoneNumberPrefix() {
        return this.phoneNumberprefix;
    }

    public void setPhoneNumberPrefix(String phoneNumberprefix) {
        this.phoneNumberprefix = phoneNumberprefix;
    }

    public int getIndex() {
        return -1;
    }
}

