/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.wireformats.output;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.BaseFeed;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.IAtom;
import com.google.gdata.data.IEntry;
import com.google.gdata.data.IFeed;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.common.xml.XmlWriter;
import com.google.gdata.wireformats.AltFormat;
import com.google.gdata.wireformats.output.OutputProperties;
import com.google.gdata.wireformats.output.XmlGenerator;
import java.io.IOException;

public class AtomGenerator
extends XmlGenerator<IAtom> {
    @Override
    public AltFormat getAltFormat() {
        return AltFormat.ATOM;
    }

    @Override
    public Class<IAtom> getSourceType() {
        return IAtom.class;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void generateXml(XmlWriter xw, OutputProperties outProps, IAtom source) throws IOException {
        xw.setDefaultNamespace(Namespaces.atomNs);
        ExtensionProfile extProfile = outProps.getExtensionProfile();
        if (source instanceof IFeed) {
            IFeed feed = (IFeed)source;
            if (!(feed instanceof BaseFeed)) throw new IllegalArgumentException("Feed was not an instance of data.BaseFeed");
            ((BaseFeed)feed).generateAtom(xw, extProfile);
            return;
        } else if (source instanceof IEntry) {
            IEntry entry = (IEntry)source;
            if (!(entry instanceof BaseEntry)) throw new IllegalArgumentException("Entry was not an instance of data.BaseEntry");
            ((BaseEntry)entry).generateAtom(xw, extProfile);
            return;
        } else {
            if (source == null) return;
            throw new IllegalStateException("Unexpected source type: " + source.getClass());
        }
    }
}

