/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.util;

import com.google.gdata.util.ContentType;
import com.google.gdata.util.ErrorContent;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.ServiceException;
import com.google.gdata.util.XmlParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.util.Collections;
import java.util.zip.GZIPInputStream;
import org.xml.sax.Attributes;

public class ServiceExceptionInitializer {
    private final ServiceException initialException;
    private ServiceException currentException = null;

    public ServiceExceptionInitializer(ServiceException se) {
        this.initialException = se;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(HttpURLConnection httpConn) throws ParseException, IOException {
        InputStream responseStream;
        StringBuilder sb;
        ContentType responseContentType;
        this.initialException.httpErrorCodeOverride = httpConn.getResponseCode();
        this.initialException.httpHeaders = Collections.unmodifiableMap(httpConn.getHeaderFields());
        this.initialException.responseContentType = responseContentType = new ContentType(httpConn.getContentType());
        int responseLength = httpConn.getContentLength();
        if (responseLength < 0) {
            sb = new StringBuilder();
        } else if (responseLength > 0) {
            sb = new StringBuilder(responseLength);
        } else {
            return;
        }
        InputStream inputStream = responseStream = this.initialException.httpErrorCodeOverride >= 400 ? httpConn.getErrorStream() : httpConn.getInputStream();
        if (responseStream != null) {
            if ("gzip".equalsIgnoreCase(httpConn.getContentEncoding())) {
                responseStream = new GZIPInputStream(responseStream);
            }
            try {
                String body;
                String responseLine;
                String charset = responseContentType.getAttributes().get("charset");
                if (charset == null) {
                    charset = "iso8859-1";
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(responseStream, charset));
                while ((responseLine = reader.readLine()) != null) {
                    sb.append(responseLine);
                    sb.append('\n');
                }
                this.initialException.responseBody = body = sb.toString();
                this.parse(responseContentType, body);
            }
            finally {
                responseStream.close();
            }
        }
    }

    public void parse(ContentType contentType, String body) throws ParseException {
        if (ContentType.GDATA_ERROR.equals(contentType)) {
            XmlParser xp = new XmlParser();
            try {
                xp.parse(new StringReader(body), (XmlParser.ElementHandler)new ErrorsHandler(), "http://schemas.google.com/g/2005", "errors");
            }
            catch (IOException ioe) {
                throw new RuntimeException("Impossible parser I/O", ioe);
            }
        }
    }

    private ServiceException nextException() {
        if (this.currentException == null) {
            this.currentException = this.initialException;
            return this.currentException;
        }
        try {
            this.currentException = (ServiceException)this.initialException.getClass().getConstructor(String.class).newInstance(this.initialException.getMessage());
            this.initialException.addSibling(this.currentException);
            return this.currentException;
        }
        catch (InstantiationException ie) {
            throw new IllegalStateException(ie);
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalStateException(nsme);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalStateException(iae);
        }
        catch (InvocationTargetException ite) {
            throw new IllegalStateException(ite);
        }
    }

    private class DebugInfoHandler
    extends XmlParser.ElementHandler {
        private DebugInfoHandler() {
        }

        @Override
        public void processEndElement() {
            ((ServiceExceptionInitializer)ServiceExceptionInitializer.this).currentException.errorElement.setDebugInfo(this.value);
        }
    }

    private class SendReportHandler
    extends XmlParser.ElementHandler {
        private SendReportHandler() {
        }

        @Override
        public void processEndElement() {
            ((ServiceExceptionInitializer)ServiceExceptionInitializer.this).currentException.errorElement.setSendReport(this.value);
        }
    }

    private class ExtendedHelpHandler
    extends XmlParser.ElementHandler {
        private ExtendedHelpHandler() {
        }

        @Override
        public void processEndElement() {
            ((ServiceExceptionInitializer)ServiceExceptionInitializer.this).currentException.errorElement.setExtendedHelp(this.value);
        }
    }

    private class InternalReasonHandler
    extends XmlParser.ElementHandler {
        private InternalReasonHandler() {
        }

        @Override
        public void processEndElement() {
            ((ServiceExceptionInitializer)ServiceExceptionInitializer.this).currentException.errorElement.setInternalReason(this.value);
        }
    }

    private class LocationHandler
    extends XmlParser.ElementHandler {
        private ErrorContent.LocationType locationType = ErrorContent.LocationType.OTHER;

        private LocationHandler() {
        }

        @Override
        public void processAttribute(String namespace, String localName, String value) {
            if ("type".equals(localName)) {
                this.locationType = ErrorContent.LocationType.fromString(value);
            }
        }

        @Override
        public void processEndElement() {
            ((ServiceExceptionInitializer)ServiceExceptionInitializer.this).currentException.errorElement.setLocation(this.value, this.locationType);
        }
    }

    private class CodeHandler
    extends XmlParser.ElementHandler {
        private CodeHandler() {
        }

        @Override
        public void processEndElement() {
            ((ServiceExceptionInitializer)ServiceExceptionInitializer.this).currentException.errorElement.setCode(this.value);
        }
    }

    private class DomainHandler
    extends XmlParser.ElementHandler {
        private DomainHandler() {
        }

        @Override
        public void processEndElement() {
            ((ServiceExceptionInitializer)ServiceExceptionInitializer.this).currentException.errorElement.setDomain(this.value);
        }
    }

    private class ErrorHandler
    extends XmlParser.ElementHandler {
        private ErrorHandler() {
        }

        @Override
        public XmlParser.ElementHandler getChildHandler(String namespace, String localName, Attributes attrs) throws ParseException, IOException {
            if ("http://schemas.google.com/g/2005".equals(namespace)) {
                if ("domain".equals(localName)) {
                    return new DomainHandler();
                }
                if ("code".equals(localName)) {
                    return new CodeHandler();
                }
                if ("location".equals(localName)) {
                    return new LocationHandler();
                }
                if ("internalReason".equals(localName)) {
                    return new InternalReasonHandler();
                }
                if ("extendedHelp".equals(localName)) {
                    return new ExtendedHelpHandler();
                }
                if ("sendReport".equals(localName)) {
                    return new SendReportHandler();
                }
                if ("debugInfo".equals(localName)) {
                    return new DebugInfoHandler();
                }
            }
            return super.getChildHandler(namespace, localName, attrs);
        }
    }

    private class ErrorsHandler
    extends XmlParser.ElementHandler {
        private ErrorsHandler() {
        }

        @Override
        public XmlParser.ElementHandler getChildHandler(String namespace, String localName, Attributes attrs) throws ParseException, IOException {
            if ("http://schemas.google.com/g/2005".equals(namespace) && "error".equals(localName)) {
                ServiceExceptionInitializer.this.nextException();
                return new ErrorHandler();
            }
            return super.getChildHandler(namespace, localName, attrs);
        }
    }
}

