/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.geo.impl;

import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.geo.Box;
import com.google.gdata.data.geo.Namespaces;
import com.google.gdata.data.geo.Point;
import com.google.gdata.data.geo.impl.GmlLowerCorner;
import com.google.gdata.data.geo.impl.GmlUpperCorner;

@ExtensionDescription.Default(nsAlias="gml", nsUri="http://www.opengis.net/gml", localName="Envelope")
public class GmlEnvelope
extends ExtensionPoint
implements Box {
    static final String NAME = "Envelope";

    public GmlEnvelope() {
    }

    public GmlEnvelope(Double lowerLat, Double lowerLon, Double upperLat, Double upperLon) {
        this(new GmlLowerCorner(lowerLat, lowerLon), new GmlUpperCorner(upperLat, upperLon));
    }

    public GmlEnvelope(Point lower, Point upper) {
        this.setGeoLocation(lower, upper);
    }

    public GmlEnvelope(Box box) {
        this(box == null ? null : box.getLowerLeft(), box == null ? null : box.getUpperRight());
    }

    public static ExtensionDescription getDefaultDescription(boolean repeatable) {
        ExtensionDescription desc = new ExtensionDescription();
        desc.setExtensionClass(GmlEnvelope.class);
        desc.setNamespace(Namespaces.GML_NAMESPACE);
        desc.setLocalName(NAME);
        desc.setRepeatable(repeatable);
        return desc;
    }

    public static ExtensionDescription getDefaultDescription() {
        return GmlEnvelope.getDefaultDescription(true);
    }

    @Override
    public void declareExtensions(ExtensionProfile extProfile) {
        extProfile.declare(GmlEnvelope.class, GmlLowerCorner.getDefaultDescription(false));
        extProfile.declare(GmlEnvelope.class, GmlUpperCorner.getDefaultDescription(false));
        super.declareExtensions(extProfile);
    }

    @Override
    public GmlLowerCorner getLowerLeft() {
        return this.getExtension(GmlLowerCorner.class);
    }

    @Override
    public GmlUpperCorner getUpperRight() {
        return this.getExtension(GmlUpperCorner.class);
    }

    @Override
    public void setGeoLocation(Point lowerLeft, Point upperRight) {
        if (lowerLeft != null && upperRight != null) {
            if (!(lowerLeft instanceof GmlLowerCorner)) {
                lowerLeft = new GmlLowerCorner(lowerLeft);
            }
            if (!(upperRight instanceof GmlUpperCorner)) {
                upperRight = new GmlUpperCorner(upperRight);
            }
            this.setExtension(lowerLeft);
            this.setExtension(upperRight);
        } else {
            if (lowerLeft != null || upperRight != null) {
                throw new IllegalArgumentException("'lower' and 'upper' must either both be null or non-null.");
            }
            this.removeExtension(GmlLowerCorner.class);
            this.removeExtension(GmlUpperCorner.class);
        }
    }

    public void setUpperRight(Point upperRight) {
        if (upperRight == null) {
            this.removeExtension(GmlUpperCorner.class);
        } else {
            if (!(upperRight instanceof GmlUpperCorner)) {
                upperRight = new GmlUpperCorner(upperRight);
            }
            this.setExtension(upperRight);
        }
    }

    @Override
    protected void validate() throws IllegalStateException {
        super.validate();
        GmlLowerCorner lower = this.getLowerLeft();
        GmlUpperCorner upper = this.getUpperRight();
        if (lower != null && upper == null || lower == null && upper != null) {
            throw new IllegalStateException("Both upper and lower must be set or neither may be set.");
        }
    }
}

