/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.pluginmanager;

import java.util.Arrays;
import javax.swing.table.AbstractTableModel;
import net.java.sip.communicator.plugin.pluginmanager.BundleComparator;
import net.java.sip.communicator.plugin.pluginmanager.PluginManagerActivator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class PluginTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 0L;
    private BundleContext bundleContext = PluginManagerActivator.bundleContext;
    private boolean showSystemBundles;
    private final Object showSystemBundlesSync = new Object();
    private Bundle[] bundles = null;
    private final BundleComparator bundleComparator = new BundleComparator();

    public PluginTableModel() {
        this.refreshSortedBundlesList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowCount() {
        boolean showSystem;
        Object object = this.showSystemBundlesSync;
        synchronized (object) {
            showSystem = this.showSystemBundles;
        }
        if (this.bundles == null) {
            return 0;
        }
        if (showSystem) {
            return this.bundles.length;
        }
        int bundlesSize = 0;
        for (int i = 0; i < this.bundles.length; ++i) {
            Bundle bundle = this.bundles[i];
            if (PluginManagerActivator.isSystemBundle(bundle)) continue;
            ++bundlesSize;
        }
        return bundlesSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Bundle bundle) {
        boolean showSystem;
        Object object = this.showSystemBundlesSync;
        synchronized (object) {
            showSystem = this.showSystemBundles;
        }
        for (int i = 0; i < this.bundles.length; ++i) {
            Bundle b = this.bundles[i];
            if (!b.equals(bundle)) continue;
            return showSystem || !PluginManagerActivator.isSystemBundle(bundle);
        }
        return false;
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int row, int column) {
        boolean showSystem;
        Object object = this.showSystemBundlesSync;
        synchronized (object) {
            showSystem = this.showSystemBundles;
        }
        if (showSystem) {
            return this.bundles[row];
        }
        int bundleCounter = 0;
        for (int i = 0; i < this.bundles.length; ++i) {
            if (PluginManagerActivator.isSystemBundle(this.bundles[i])) continue;
            if (bundleCounter == row) {
                return this.bundles[i];
            }
            ++bundleCounter;
        }
        return null;
    }

    public void update() {
        this.refreshSortedBundlesList();
        this.fireTableDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isShowSystemBundles() {
        boolean showSystem;
        Object object = this.showSystemBundlesSync;
        synchronized (object) {
            showSystem = this.showSystemBundles;
        }
        return showSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShowSystemBundles(boolean showSystemBundles) {
        Object object = this.showSystemBundlesSync;
        synchronized (object) {
            this.showSystemBundles = showSystemBundles;
        }
    }

    private void refreshSortedBundlesList() {
        this.bundles = this.bundleContext.getBundles();
        Arrays.sort(this.bundles, this.bundleComparator);
    }
}

