/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.chatconfig.replacement;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.java.sip.communicator.plugin.chatconfig.ChatConfigActivator;
import net.java.sip.communicator.plugin.chatconfig.replacement.ReplacementConfigurationTableModel;
import net.java.sip.communicator.plugin.desktoputil.SIPCommCheckBox;
import net.java.sip.communicator.plugin.desktoputil.SIPCommRadioButton;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.replacement.ReplacementProperty;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.resources.ResourceManagementService;

public class ReplacementConfigPanel
extends TransparentPanel {
    private static final long serialVersionUID = 0L;
    private JCheckBox enableSmiley;
    private JRadioButton enableReplacement;
    private JRadioButton enableReplacementProposal;
    private JRadioButton disableReplacement;
    private JTable table;

    public ReplacementConfigPanel() {
        super((LayoutManager)new BorderLayout());
        this.add(ChatConfigActivator.createConfigSectionComponent(ChatConfigActivator.getResources().getI18NString("plugin.chatconfig.replacement.TITLE")), "West");
        this.add(this.createMainPanel());
        this.initValues();
    }

    private Component createMainPanel() {
        TransparentPanel mainPanel = new TransparentPanel();
        mainPanel.setLayout(new BoxLayout((Container)mainPanel, 1));
        ResourceManagementService R = ChatConfigActivator.getResources();
        this.enableSmiley = new SIPCommCheckBox(R.getI18NString("plugin.chatconfig.replacement.ENABLE_SMILEY_STATUS"));
        mainPanel.add(this.enableSmiley);
        this.enableSmiley.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReplacementConfigPanel.this.saveData();
            }
        });
        mainPanel.add(Box.createVerticalStrut(10));
        TransparentPanel replacementPanel = new TransparentPanel();
        replacementPanel.setLayout(new BoxLayout((Container)replacementPanel, 1));
        replacementPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(R.getI18NString("plugin.chatconfig.replacement.REPLACEMENT_TITLE")), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        this.enableReplacement = new SIPCommRadioButton(R.getI18NString("plugin.chatconfig.replacement.ENABLE_REPLACEMENT_STATUS"));
        replacementPanel.add(this.enableReplacement);
        this.enableReplacement.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReplacementConfigPanel.this.saveData();
            }
        });
        this.enableReplacementProposal = new SIPCommRadioButton(R.getI18NString("plugin.chatconfig.replacement.ENABLE_REPLACEMENT_PROPOSAL"));
        replacementPanel.add(this.enableReplacementProposal);
        this.enableReplacementProposal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ReplacementConfigPanel.this.saveData();
            }
        });
        this.disableReplacement = new SIPCommRadioButton(R.getI18NString("plugin.chatconfig.replacement.DISABLE_REPLACEMENT"));
        replacementPanel.add(this.disableReplacement);
        this.disableReplacement.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ReplacementConfigPanel.this.saveData();
            }
        });
        ButtonGroup replacementGroup = new ButtonGroup();
        replacementGroup.add(this.enableReplacement);
        replacementGroup.add(this.enableReplacementProposal);
        replacementGroup.add(this.disableReplacement);
        this.table = new JTable();
        this.table.setShowGrid(false);
        this.table.setTableHeader(null);
        this.table.setOpaque(true);
        this.table.setBackground(Color.white);
        JScrollPane tablePane = new JScrollPane(this.table);
        tablePane.setOpaque(false);
        tablePane.setPreferredSize(new Dimension(replacementPanel.getWidth(), 150));
        tablePane.setAlignmentX(0.0f);
        TransparentPanel container = new TransparentPanel((LayoutManager)new BorderLayout());
        container.setPreferredSize(new Dimension(replacementPanel.getWidth(), 200));
        container.setLayout(new BoxLayout((Container)container, 1));
        JLabel label = new JLabel(R.getI18NString("plugin.chatconfig.replacement.REPLACEMENT_SOURCES"));
        label.setDisplayedMnemonic(R.getI18nMnemonic("plugin.chatconfig.replacement.REPLACEMENT_SOURCES"));
        label.setLabelFor(this.table);
        container.add(label);
        container.add(Box.createRigidArea(new Dimension(0, 5)));
        container.add((Component)tablePane, "East");
        Set<String> keys = ChatConfigActivator.getReplacementSources().keySet();
        ArrayList<String> sourceList = new ArrayList<String>(keys);
        sourceList.remove("SMILEY");
        Collections.sort(sourceList);
        this.table.setModel(new ReplacementConfigurationTableModel(sourceList));
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                boolean isEnabled;
                if (e.getValueIsAdjusting()) {
                    return;
                }
                if (ReplacementConfigPanel.this.table.getSelectedRow() != -1 && (isEnabled = ((Boolean)ReplacementConfigPanel.this.table.getValueAt(ReplacementConfigPanel.this.table.getSelectedRow(), 0)).booleanValue())) {
                    ReplacementConfigPanel.this.enableReplacement.setSelected(true);
                }
            }
        });
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setMaxWidth(tableColumn.getMinWidth());
        this.table.setDefaultRenderer(this.table.getColumnClass(1), new FixedTableCellRenderer());
        replacementPanel.add(Box.createVerticalStrut(10));
        replacementPanel.add((Component)container);
        mainPanel.add((Component)replacementPanel);
        return mainPanel;
    }

    private void initValues() {
        ConfigurationService configService = ChatConfigActivator.getConfigurationService();
        this.enableSmiley.setSelected(configService.getBoolean(ReplacementProperty.getPropertyName((String)"SMILEY"), true));
        this.enableReplacement.setSelected(configService.getBoolean("net.java.sip.communicator.service.replacement.enable", true));
        this.enableReplacementProposal.setSelected(configService.getBoolean("plugin.chatconfig.replacement.proposal.enable", true));
        this.disableReplacement.setSelected(!this.enableReplacement.isSelected() && !this.enableReplacementProposal.isSelected());
        this.table.setEnabled(this.enableReplacement.isSelected());
    }

    private void saveData() {
        ConfigurationService configService = ChatConfigActivator.getConfigurationService();
        configService.setProperty(ReplacementProperty.getPropertyName((String)"SMILEY"), (Object)Boolean.toString(this.enableSmiley.isSelected()));
        configService.setProperty("net.java.sip.communicator.service.replacement.enable", (Object)Boolean.toString(this.enableReplacement.isSelected()));
        configService.setProperty("plugin.chatconfig.replacement.proposal.enable", (Object)Boolean.toString(this.enableReplacementProposal.isSelected()));
        this.table.getSelectionModel().clearSelection();
        this.table.setEnabled(this.enableReplacement.isSelected() || this.enableReplacementProposal.isSelected());
    }

    private static class FixedTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 0L;

        private FixedTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            this.setEnabled(table == null || table.isEnabled());
            super.getTableCellRendererComponent(table, value, selected, focused, row, column);
            return this;
        }
    }
}

