/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.contactlist;

import java.util.EventObject;
import java.util.Iterator;
import java.util.Vector;
import junit.framework.TestCase;
import net.java.sip.communicator.impl.protocol.mock.MockContact;
import net.java.sip.communicator.impl.protocol.mock.MockContactGroup;
import net.java.sip.communicator.impl.protocol.mock.MockStatusEnum;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.contactlist.MetaContactGroup;
import net.java.sip.communicator.service.contactlist.event.MetaContactAvatarUpdateEvent;
import net.java.sip.communicator.service.contactlist.event.MetaContactEvent;
import net.java.sip.communicator.service.contactlist.event.MetaContactGroupEvent;
import net.java.sip.communicator.service.contactlist.event.MetaContactListListener;
import net.java.sip.communicator.service.contactlist.event.MetaContactModifiedEvent;
import net.java.sip.communicator.service.contactlist.event.MetaContactMovedEvent;
import net.java.sip.communicator.service.contactlist.event.MetaContactRenamedEvent;
import net.java.sip.communicator.service.contactlist.event.ProtoContactEvent;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactGroup;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.slick.contactlist.MclSlickFixture;
import net.java.sip.communicator.slick.contactlist.MetaContactListServiceLick;
import net.java.sip.communicator.util.Logger;

public class TestMetaContactList
extends TestCase {
    private MclSlickFixture fixture = new MclSlickFixture(((Object)((Object)this)).getClass().getName());
    private String newSubscriptionName = "NewSubscription";
    private String renamedGroupName = "RenamedContactGroup";
    private static final Logger logger = Logger.getLogger(TestMetaContactList.class);

    public TestMetaContactList(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.fixture.setUp();
    }

    protected void tearDown() throws Exception {
        this.fixture.tearDown();
        super.tearDown();
    }

    public void testContactListRetrieving() {
        MockContactGroup expectedRoot = (MockContactGroup)MclSlickFixture.mockPresOpSet.getServerStoredContactListRoot();
        logger.info((Object)"============== Predefined contact List ==============");
        logger.info((Object)("rootGroup=" + expectedRoot.getGroupName() + " rootGroup.childContacts=" + expectedRoot.countContacts() + "rootGroup.childGroups=" + expectedRoot.countSubgroups() + " Printing rootGroupContents=\n" + expectedRoot.toString()));
        MetaContactGroup actualRoot = this.fixture.metaClService.getRoot();
        logger.info((Object)"================ Meta Contact List =================");
        logger.info((Object)("rootGroup=" + actualRoot.getGroupName() + " rootGroup.childContacts=" + actualRoot.countChildContacts() + " rootGroup.childGroups=" + actualRoot.countSubgroups() + " Printing rootGroupContents=\n" + actualRoot.toString()));
        MclSlickFixture.assertGroupEquals(expectedRoot, actualRoot, false);
    }

    public void testContactsOrder() {
        this.assertContactsOrder(this.fixture.metaClService.getRoot());
        MclEventCollector evtCollector = new MclEventCollector();
        this.fixture.metaClService.addMetaContactListListener((MetaContactListListener)evtCollector);
        MclSlickFixture.mockPresOpSet.changePresenceStatusForContact(MetaContactListServiceLick.mockContactToReorder, MockStatusEnum.MOCK_STATUS_100);
        this.fixture.metaClService.removeMetaContactListListener((MetaContactListListener)evtCollector);
        TestMetaContactList.assertEquals((String)"Number of evts dispatched after a contact changed its status", (int)1, (int)evtCollector.collectedMetaContactGroupEvents.size());
        MetaContactGroupEvent evt = (MetaContactGroupEvent)evtCollector.collectedMetaContactGroupEvents.remove(0);
        TestMetaContactList.assertEquals((String)"ID of the generated event", (int)4, (int)evt.getEventID());
        TestMetaContactList.assertEquals((String)"Source meta contact.", (Object)this.fixture.metaClService.getRoot(), (Object)evt.getSourceMetaContactGroup());
        this.assertContactsOrder(this.fixture.metaClService.getRoot());
        MclSlickFixture.mockPresOpSet.changePresenceStatusForContact(MetaContactListServiceLick.mockContactToReorder, MockStatusEnum.MOCK_STATUS_00);
        this.fixture.metaClService.addMetaContactListListener((MetaContactListListener)evtCollector);
        MetaContact theReorderedContact = this.fixture.metaClService.findMetaContactByContact((Contact)MetaContactListServiceLick.mockContactToReorder);
        this.fixture.metaClService.renameMetaContact(theReorderedContact, "zzzzzz");
        this.fixture.metaClService.removeMetaContactListListener((MetaContactListListener)evtCollector);
        TestMetaContactList.assertEquals((String)"Number of evts dispatched after a contact changed its display name", (int)1, (int)evtCollector.collectedMetaContactGroupEvents.size());
        evt = (MetaContactGroupEvent)evtCollector.collectedMetaContactGroupEvents.remove(0);
        TestMetaContactList.assertEquals((String)"ID of the generated event", (int)4, (int)evt.getEventID());
        TestMetaContactList.assertEquals((String)"Source meta contact.", (Object)this.fixture.metaClService.getRoot(), (Object)evt.getSourceMetaContactGroup());
        TestMetaContactList.assertSame((String)(MetaContactListServiceLick.mockContactToReorder + " was not moved to the bottom of the list after being assigned 00 status and a heavy name."), (Object)theReorderedContact, (Object)this.fixture.metaClService.getRoot().getMetaContact(this.fixture.metaClService.getRoot().countChildContacts() - 1));
    }

    public void assertContactsOrder(MetaContactGroup group) {
        Iterator contacts = group.getChildContacts();
        MetaContact previousContact = null;
        while (contacts.hasNext()) {
            MetaContact currentContact = (MetaContact)contacts.next();
            if (previousContact != null) {
                TestMetaContactList.assertTrue((String)(previousContact + " was wrongfully before " + currentContact), (previousContact.compareTo((Object)currentContact) <= 0 ? 1 : 0) != 0);
            }
            previousContact = currentContact;
        }
        Iterator subgroups = group.getSubgroups();
        while (subgroups.hasNext()) {
            this.assertContactsOrder((MetaContactGroup)subgroups.next());
        }
    }

    public void testFindMetaContactByMetaUID() {
        MetaContactGroup root = this.fixture.metaClService.getRoot();
        Iterator contactsIter = root.getChildContacts();
        TestMetaContactList.assertTrue((String)"No contacts were found in the meta contact list", (boolean)contactsIter.hasNext());
        MetaContact expectedContact = (MetaContact)contactsIter.next();
        MetaContact actualResult = this.fixture.metaClService.findMetaContactByMetaUID(expectedContact.getMetaUID());
        TestMetaContactList.assertEquals((String)("find failed for contact " + expectedContact.getDisplayName()), (Object)expectedContact, (Object)actualResult);
        Iterator subgroupsIter = root.getSubgroups();
        TestMetaContactList.assertTrue((String)"No sub groups were found in the meta contact list", (boolean)subgroupsIter.hasNext());
        MetaContactGroup subgroup = (MetaContactGroup)subgroupsIter.next();
        contactsIter = subgroup.getChildContacts();
        TestMetaContactList.assertTrue((String)("No contacts were found in the meta group: " + subgroup.getGroupName()), (boolean)contactsIter.hasNext());
        expectedContact = (MetaContact)contactsIter.next();
        actualResult = this.fixture.metaClService.findMetaContactByMetaUID(expectedContact.getMetaUID());
        TestMetaContactList.assertEquals((String)("find failed for contact " + expectedContact.getDisplayName()), (Object)expectedContact, (Object)actualResult);
    }

    public void testFindMetaContactByContact() {
        MetaContactGroup root = this.fixture.metaClService.getRoot();
        Iterator contactsIter = root.getChildContacts();
        TestMetaContactList.assertTrue((String)"No contacts were found in the meta contact list", (boolean)contactsIter.hasNext());
        MetaContact expectedMetaContact = (MetaContact)contactsIter.next();
        TestMetaContactList.assertTrue((String)("No contacts are encapsulated by MetaContact: " + expectedMetaContact.getDisplayName()), (boolean)expectedMetaContact.getContacts().hasNext());
        Contact mockContact = (Contact)expectedMetaContact.getContacts().next();
        MetaContact actualResult = this.fixture.metaClService.findMetaContactByContact(mockContact);
        TestMetaContactList.assertEquals((String)("find failed for contact " + expectedMetaContact.getDisplayName()), (Object)expectedMetaContact, (Object)actualResult);
        Iterator subgroupsIter = root.getSubgroups();
        TestMetaContactList.assertTrue((String)"No sub groups were found in the meta contact list", (boolean)subgroupsIter.hasNext());
        MetaContactGroup subgroup = (MetaContactGroup)subgroupsIter.next();
        contactsIter = subgroup.getChildContacts();
        TestMetaContactList.assertTrue((String)("No contacts were found in MetaContactGroup: " + subgroup.getGroupName()), (boolean)contactsIter.hasNext());
        expectedMetaContact = (MetaContact)contactsIter.next();
        TestMetaContactList.assertTrue((String)("No contacts were encapsulated by meta contact: " + expectedMetaContact.getDisplayName()), (boolean)expectedMetaContact.getContacts().hasNext());
        mockContact = (Contact)expectedMetaContact.getContacts().next();
        actualResult = this.fixture.metaClService.findMetaContactByContact(mockContact);
        TestMetaContactList.assertEquals((String)("find failed for contact " + expectedMetaContact.getDisplayName()), (Object)expectedMetaContact, (Object)actualResult);
    }

    public void testFindMetaContactGroupByContactGroup() {
        MetaContactGroup root = this.fixture.metaClService.getRoot();
        Iterator groupsIter = root.getSubgroups();
        TestMetaContactList.assertTrue((String)"No sub groups were found in the meta contact list", (boolean)groupsIter.hasNext());
        MetaContactGroup expectedMetaContactGroup = (MetaContactGroup)groupsIter.next();
        TestMetaContactList.assertTrue((String)("There were no contact groups encapsulated in MetaContactGroup: " + expectedMetaContactGroup), (boolean)expectedMetaContactGroup.getContactGroups().hasNext());
        TestMetaContactList.assertTrue((String)("No ContactGroups are encapsulated by MetaContactGroup: " + expectedMetaContactGroup), (boolean)expectedMetaContactGroup.getContactGroups().hasNext());
        ContactGroup mockContactGroup = (ContactGroup)expectedMetaContactGroup.getContactGroups().next();
        MetaContactGroup actualMetaContactGroup = this.fixture.metaClService.findMetaContactGroupByContactGroup(mockContactGroup);
        TestMetaContactList.assertSame((String)("find failed for contact group " + mockContactGroup), (Object)expectedMetaContactGroup, (Object)actualMetaContactGroup);
        actualMetaContactGroup = this.fixture.metaClService.findMetaContactGroupByContactGroup(MclSlickFixture.mockPresOpSet.getServerStoredContactListRoot());
        TestMetaContactList.assertSame((String)"find failed for root contact group ", (Object)root, (Object)actualMetaContactGroup);
    }

    public void testSubscriptionHandling() throws Exception {
        MclEventCollector mclEvtCollector = new MclEventCollector();
        this.fixture.metaClService.addMetaContactListListener((MetaContactListListener)mclEvtCollector);
        MclSlickFixture.mockPresOpSet.subscribe(this.newSubscriptionName);
        this.fixture.metaClService.removeMetaContactListListener((MetaContactListListener)mclEvtCollector);
        MockContact newProtoContact = (MockContact)MclSlickFixture.mockPresOpSet.findContactByID(this.newSubscriptionName);
        MetaContact newMetaContact = this.fixture.metaClService.findMetaContactByContact((Contact)newProtoContact);
        TestMetaContactList.assertNotNull((String)("The meta contact list was not updated after adding contact " + newProtoContact + " to the mock provider."), (Object)newMetaContact);
        TestMetaContactList.assertEquals((String)"Number of evts dispatched while adding a contact", (int)1, (int)mclEvtCollector.collectedMetaContactEvents.size());
        MetaContactEvent evt = (MetaContactEvent)mclEvtCollector.collectedMetaContactEvents.remove(0);
        TestMetaContactList.assertEquals((String)"ID of the generated event", (int)1, (int)evt.getEventID());
        TestMetaContactList.assertEquals((String)"Parent group of the source contact", (Object)this.fixture.metaClService.getRoot(), (Object)evt.getParentGroup());
        TestMetaContactList.assertEquals((String)"Source meta contact.", (Object)newMetaContact, (Object)evt.getSourceMetaContact());
        this.fixture.metaClService.addMetaContactListListener((MetaContactListListener)mclEvtCollector);
        MclSlickFixture.mockPresOpSet.unsubscribe((Contact)newProtoContact);
        this.fixture.metaClService.removeMetaContactListListener((MetaContactListListener)mclEvtCollector);
        TestMetaContactList.assertNull((String)"The impl contact list did not update after a subscr. was removed.", (Object)this.fixture.metaClService.findMetaContactByContact((Contact)newProtoContact));
        TestMetaContactList.assertEquals((String)"Number of evts dispatched while adding a contact", (int)1, (int)mclEvtCollector.collectedMetaContactEvents.size());
        evt = (MetaContactEvent)mclEvtCollector.collectedMetaContactEvents.remove(0);
        TestMetaContactList.assertEquals((String)"ID of the generated event", (int)2, (int)evt.getEventID());
        TestMetaContactList.assertEquals((String)"Parent group of the source contact", (Object)this.fixture.metaClService.getRoot(), (Object)evt.getParentGroup());
        TestMetaContactList.assertEquals((String)"Source meta contact.", (Object)newMetaContact, (Object)evt.getSourceMetaContact());
        MclSlickFixture.mockPresOpSet.createVolatileContact(this.newSubscriptionName + "1");
        MclSlickFixture.mockPresOpSet.createVolatileContact(this.newSubscriptionName + "2");
        MclSlickFixture.mockPresOpSet.removeServerStoredContactGroup((ContactGroup)MclSlickFixture.mockPresOpSet.getNonPersistentGroup());
    }

    public void testGroupChangeEventHandling() throws Exception {
        String newGroupName = "testGroupChangeEventHandling.NewContactGroup";
        String newInnerGroupName = "testGroupChangeEventHandling.NewInnderContactGroup";
        MclEventCollector mclEvtCollector = new MclEventCollector();
        MockContactGroup newContactGroup = new MockContactGroup(newGroupName, MclSlickFixture.mockProvider);
        MockContactGroup newInnerContactGroup = new MockContactGroup(newInnerGroupName, MclSlickFixture.mockProvider);
        newContactGroup.addSubgroup(newInnerContactGroup);
        this.fixture.metaClService.addMetaContactListListener((MetaContactListListener)mclEvtCollector);
        MclSlickFixture.mockPresOpSet.addMockGroupAndFireEvent((MockContactGroup)MclSlickFixture.mockPresOpSet.getServerStoredContactListRoot(), newContactGroup);
        this.fixture.metaClService.removeMetaContactListListener((MetaContactListListener)mclEvtCollector);
        TestMetaContactList.assertEquals((String)"Number of evts dispatched while adding a contact group", (int)1, (int)mclEvtCollector.collectedMetaContactGroupEvents.size());
        MetaContactGroupEvent evt = (MetaContactGroupEvent)mclEvtCollector.collectedMetaContactGroupEvents.remove(0);
        TestMetaContactList.assertEquals((String)"ID of the generated event", (int)1, (int)evt.getEventID());
        TestMetaContactList.assertEquals((String)"Name of the source group of the AddEvent.", (String)newContactGroup.getGroupName(), (String)evt.getSourceMetaContactGroup().getGroupName());
        MetaContactGroup newMetaGroup = evt.getSourceMetaContactGroup();
        TestMetaContactList.assertSame((String)"Contact group in the newly added meta group.", (Object)newContactGroup, (Object)newMetaGroup.getContactGroup(newContactGroup.getGroupName(), (ProtocolProviderService)MclSlickFixture.mockProvider));
        TestMetaContactList.assertEquals((String)"Subgroups were not imported in the MetaContactList.", (int)newContactGroup.countSubgroups(), (int)evt.getSourceMetaContactGroup().countSubgroups());
        TestMetaContactList.assertEquals((String)"Source provider for the add event.", (Object)MclSlickFixture.mockProvider, (Object)evt.getSourceProvider());
        ContactGroup newProtoGroup = newMetaGroup.getContactGroup(newGroupName, (ProtocolProviderService)MclSlickFixture.mockProvider);
        TestMetaContactList.assertNotNull((String)"The new meta contact group did not contain a proto group", (Object)newProtoGroup);
        TestMetaContactList.assertEquals((String)"The new meta contact group did not seem to contain the right protocol contact group.", (String)newProtoGroup.getGroupName(), (String)newGroupName);
        TestMetaContactList.assertEquals((String)"The new meta contact group did not seem to contain the right protocol contact group.", (Object)newProtoGroup.getProtocolProvider(), (Object)MclSlickFixture.mockProvider);
        this.fixture.metaClService.addMetaContactListListener((MetaContactListListener)mclEvtCollector);
        MclSlickFixture.mockPresOpSet.renameServerStoredContactGroup(newProtoGroup, this.renamedGroupName);
        this.fixture.metaClService.removeMetaContactListListener((MetaContactListListener)mclEvtCollector);
        TestMetaContactList.assertEquals((String)"Number of evts dispatched while renaming a contact group", (int)1, (int)mclEvtCollector.collectedMetaContactGroupEvents.size());
        evt = (MetaContactGroupEvent)mclEvtCollector.collectedMetaContactGroupEvents.remove(0);
        TestMetaContactList.assertEquals((String)"ID of the generated event", (int)5, (int)evt.getEventID());
        TestMetaContactList.assertEquals((String)"Source group for the RemoveEvent.", (Object)newMetaGroup, (Object)evt.getSourceMetaContactGroup());
        TestMetaContactList.assertEquals((String)"Source provider for the remove event.", (Object)MclSlickFixture.mockProvider, (Object)evt.getSourceProvider());
        Iterator groupsIter = evt.getSourceMetaContactGroup().getContactGroupsForProvider((ProtocolProviderService)MclSlickFixture.mockProvider);
        TestMetaContactList.assertTrue((String)"A proto group was unexplicably removed after renaming.", (boolean)groupsIter.hasNext());
        TestMetaContactList.assertEquals((String)"The name of a protocol group after renaming.", (String)this.renamedGroupName, (String)((ContactGroup)groupsIter.next()).getGroupName());
        this.fixture.metaClService.addMetaContactListListener((MetaContactListListener)mclEvtCollector);
        MclSlickFixture.mockPresOpSet.removeServerStoredContactGroup(newProtoGroup);
        this.fixture.metaClService.removeMetaContactListListener((MetaContactListListener)mclEvtCollector);
        TestMetaContactList.assertTrue((String)"Number of evts dispatched while removing a contact group", (mclEvtCollector.collectedMetaContactGroupEvents.size() > 0 ? 1 : 0) != 0);
        evt = (MetaContactGroupEvent)mclEvtCollector.collectedMetaContactGroupEvents.get(mclEvtCollector.collectedMetaContactGroupEvents.size() - 2);
        mclEvtCollector.collectedMetaContactGroupEvents.clear();
        TestMetaContactList.assertEquals((String)"ID of the generated event", (int)evt.getEventID(), (int)3);
        TestMetaContactList.assertEquals((String)"Source group for the RemoveEvent.", (Object)newMetaGroup, (Object)evt.getSourceMetaContactGroup());
        TestMetaContactList.assertEquals((String)"Source provider for the remove event.", (Object)MclSlickFixture.mockProvider, (Object)evt.getSourceProvider());
    }

    public void testAddMoveRemoveContactToMetaContact() {
        String newContactID = "TestyPesty";
        MetaContact metaContact = this.fixture.metaClService.getRoot().getMetaContact(0);
        MetaContact dstMetaContact = this.fixture.metaClService.getRoot().getMetaContact(1);
        MclEventCollector evtCollector = new MclEventCollector();
        this.fixture.metaClService.addMetaContactListListener((MetaContactListListener)evtCollector);
        this.fixture.metaClService.addNewContactToMetaContact((ProtocolProviderService)MclSlickFixture.mockProvider, metaContact, newContactID);
        this.fixture.metaClService.removeMetaContactListListener((MetaContactListListener)evtCollector);
        TestMetaContactList.assertEquals((String)"Dest. meta Contact did not seem to contain an extra proto contact.", (int)2, (int)metaContact.getContactCount());
        MockContact newContact = (MockContact)metaContact.getContact(newContactID, (ProtocolProviderService)MclSlickFixture.mockProvider);
        TestMetaContactList.assertNotNull((String)"newContact", (Object)newContact);
        TestMetaContactList.assertSame((String)"Proto specific contact in mock contact list.", (Object)newContact, (Object)MclSlickFixture.mockPresOpSet.getServerStoredContactListRoot().getContact(newContactID));
        TestMetaContactList.assertEquals((String)"Events delivered while adding a new contact to a meta contact", (int)1, (int)evtCollector.collectedMetaContactEvents.size());
        ProtoContactEvent event = (ProtoContactEvent)evtCollector.collectedMetaContactEvents.remove(0);
        TestMetaContactList.assertSame((String)"Source contact in ProtoContactEvent gen. upon add.", (Object)newContact, (Object)event.getProtoContact());
        TestMetaContactList.assertSame((String)"Source provider in ProtoContactEvent gen. upon add.", (Object)MclSlickFixture.mockProvider, (Object)event.getProtoContact().getProtocolProvider());
        TestMetaContactList.assertEquals((String)"Event ID in MetaContactEvent gen. upon add.", (String)"ProtoContactAdded", (String)event.getPropertyName());
        this.fixture.metaClService.addMetaContactListListener((MetaContactListListener)evtCollector);
        this.fixture.metaClService.moveContact((Contact)newContact, dstMetaContact);
        this.fixture.metaClService.removeMetaContactListListener((MetaContactListListener)evtCollector);
        TestMetaContactList.assertEquals((String)"Orig. Meta Contact did not seem restored after removing the newly added contact.", (int)1, (int)metaContact.getContactCount());
        TestMetaContactList.assertEquals((String)"A Meta Contact did not seem updated after moving a contact inside it.", (int)2, (int)dstMetaContact.getContactCount());
        newContact = (MockContact)dstMetaContact.getContact(newContactID, (ProtocolProviderService)MclSlickFixture.mockProvider);
        TestMetaContactList.assertNotNull((String)"newContact", (Object)newContact);
        TestMetaContactList.assertEquals((String)"Events delivered while adding a moving a proto contact. ", (int)1, (int)evtCollector.collectedMetaContactEvents.size());
        event = (ProtoContactEvent)evtCollector.collectedMetaContactEvents.remove(0);
        TestMetaContactList.assertSame((String)"Source contact in ProtoContactEvent gen. upon move.", (Object)newContact, (Object)event.getProtoContact());
        TestMetaContactList.assertSame((String)"Parent meta contact in ProtoContactEvent gen. upon move.", (Object)dstMetaContact, (Object)event.getParent());
        TestMetaContactList.assertSame((String)"Source provider in ProtoContactEvent gen. upon move.", (Object)MclSlickFixture.mockProvider, (Object)event.getProtoContact().getProtocolProvider());
        TestMetaContactList.assertEquals((String)"Event ID in ProtoContactEvent gen. upon add.", (String)"ProtoContactMoved", (String)event.getPropertyName());
        this.fixture.metaClService.addMetaContactListListener((MetaContactListListener)evtCollector);
        this.fixture.metaClService.removeContact((Contact)newContact);
        this.fixture.metaClService.removeMetaContactListListener((MetaContactListListener)evtCollector);
        TestMetaContactList.assertEquals((String)"Dest. Meta Contact did not seem restored after removing the newly added contact.", (int)1, (int)dstMetaContact.getContactCount());
        TestMetaContactList.assertNull((String)"The MetaContactList did not remove a contact from the MockList on del.", (Object)MclSlickFixture.mockPresOpSet.getServerStoredContactListRoot().getContact(newContactID));
        TestMetaContactList.assertEquals((String)"Events delivered while adding a new contact to a meta contact", (int)1, (int)evtCollector.collectedMetaContactEvents.size());
        event = (ProtoContactEvent)evtCollector.collectedMetaContactEvents.remove(0);
        TestMetaContactList.assertSame((String)"Source contact in ProtoContactEvent gen. upon remove.", (Object)newContact, (Object)event.getProtoContact());
        TestMetaContactList.assertSame((String)"Parent meta contact in ProtoContactEvent gen. upon remove.", (Object)dstMetaContact, (Object)event.getParent());
        TestMetaContactList.assertSame((String)"Source provider in ProtoContactEvent gen. upon remove.", (Object)MclSlickFixture.mockProvider, (Object)event.getProtoContact().getProtocolProvider());
        TestMetaContactList.assertEquals((String)"Event ID in ProtoContactEvent gen. upon remove.", (String)"ProtoContactRemoved", (String)event.getPropertyName());
    }

    public void testCreateMoveRemoveMetaContact() {
        String newContactID = "testCreateMoveRemoveMetaContact.ContactID";
        MetaContactGroup parentMetaGroup = this.fixture.metaClService.getRoot().getMetaContactSubgroup("SomePeople");
        MclEventCollector evtCollector = new MclEventCollector();
        this.fixture.metaClService.addMetaContactListListener((MetaContactListListener)evtCollector);
        this.fixture.metaClService.createMetaContact((ProtocolProviderService)MclSlickFixture.mockProvider, parentMetaGroup, newContactID);
        this.fixture.metaClService.removeMetaContactListListener((MetaContactListListener)evtCollector);
        MetaContact newMetaContact = parentMetaGroup.getMetaContact((ProtocolProviderService)MclSlickFixture.mockProvider, newContactID);
        TestMetaContactList.assertNotNull((String)"create failed. couldn't find the new contact.", (Object)newMetaContact);
        TestMetaContactList.assertEquals((String)"create() created a meta contact with the wrong name.", (String)newContactID, (String)newMetaContact.getDisplayName());
        TestMetaContactList.assertEquals((String)"Events delivered while creating a new meta contact", (int)1, (int)evtCollector.collectedMetaContactEvents.size());
        MetaContactEvent event = (MetaContactEvent)evtCollector.collectedMetaContactEvents.remove(0);
        TestMetaContactList.assertSame((String)"Source contact in MetaContactEvent gen. upon create.", (Object)newMetaContact, (Object)event.getSourceMetaContact());
        TestMetaContactList.assertEquals((String)"Event ID in MetaContactEvent gen. upon create.", (int)1, (int)event.getEventID());
        this.fixture.metaClService.addMetaContactListListener((MetaContactListListener)evtCollector);
        this.fixture.metaClService.moveMetaContact(newMetaContact, this.fixture.metaClService.getRoot());
        this.fixture.metaClService.removeMetaContactListListener((MetaContactListListener)evtCollector);
        TestMetaContactList.assertNull((String)(newMetaContact.getDisplayName() + " was still in its old location after moving it."), (Object)parentMetaGroup.getMetaContact(newMetaContact.getMetaUID()));
        TestMetaContactList.assertNotNull((String)(newMetaContact.getDisplayName() + " was not in the new location after moving it."), (Object)this.fixture.metaClService.getRoot().getMetaContact(newMetaContact.getMetaUID()));
        TestMetaContactList.assertNull((String)("The mock contact corresponding to: " + newMetaContact.getDisplayName() + " was still in its old location after its encapsulating meta contact was moved"), (Object)MetaContactListServiceLick.topLevelMockGroup.getContact(newContactID));
        TestMetaContactList.assertNotNull((String)("The mock contact corresponding to: " + newMetaContact.getDisplayName() + " was not moved to its new location after its encapsulating meta contact was."), (Object)MclSlickFixture.mockPresOpSet.getServerStoredContactListRoot().getContact(newContactID));
        TestMetaContactList.assertEquals((String)"Events delivered while moving a meta contact", (int)1, (int)evtCollector.collectedMetaContactEvents.size());
        MetaContactMovedEvent movedEvent = (MetaContactMovedEvent)evtCollector.collectedMetaContactEvents.remove(0);
        TestMetaContactList.assertSame((String)"Source contact in MetaContactEvent gen. upon move.", (Object)newMetaContact, (Object)movedEvent.getSourceMetaContact());
        TestMetaContactList.assertEquals((String)"Event Property Name in MetaContactEvent gen. upon move.", (String)"MetaContactMovedEvent", (String)movedEvent.getPropertyName());
        TestMetaContactList.assertEquals((String)"Old Parent in MetaContactEvent gen. upon move.", (Object)parentMetaGroup, (Object)movedEvent.getOldParent());
        TestMetaContactList.assertEquals((String)"Old Parent in MetaContactEvent gen. upon move.", (Object)this.fixture.metaClService.getRoot(), (Object)movedEvent.getNewParent());
        this.fixture.metaClService.addMetaContactListListener((MetaContactListListener)evtCollector);
        this.fixture.metaClService.removeMetaContact(newMetaContact);
        this.fixture.metaClService.removeMetaContactListListener((MetaContactListListener)evtCollector);
        TestMetaContactList.assertNull((String)(newMetaContact.getDisplayName() + " was still in its old location after it was removed."), (Object)this.fixture.metaClService.getRoot().getMetaContact(newMetaContact.getMetaUID()));
        TestMetaContactList.assertNull((String)("The mock contact corresponding to: " + newMetaContact.getDisplayName() + " was not removed after its encapsulating meta contact was."), (Object)MclSlickFixture.mockPresOpSet.getServerStoredContactListRoot().getContact(newContactID));
        TestMetaContactList.assertEquals((String)"Events delivered while removing a meta contact", (int)1, (int)evtCollector.collectedMetaContactEvents.size());
        event = (MetaContactEvent)evtCollector.collectedMetaContactEvents.remove(0);
        TestMetaContactList.assertSame((String)"Source contact in MetaContactEvent gen. upon remove.", (Object)newMetaContact, (Object)event.getSourceMetaContact());
        TestMetaContactList.assertEquals((String)"Event ID in MetaContactEvent gen. upon remove.", (int)2, (int)event.getEventID());
    }

    public void testCreateRenameRemoveMetaContactGroup() {
        String newGroupName = "testCRRMetaContactGroup.NewContactGroup";
        String newContactID = "testCRRMetaContactGroup.NewContactID";
        this.fixture.metaClService.createMetaContactGroup(this.fixture.metaClService.getRoot(), newGroupName);
        MetaContactGroup newMetaGroup = this.fixture.metaClService.getRoot().getMetaContactSubgroup(newGroupName);
        TestMetaContactList.assertNotNull((String)"createMetaContactGroup failed - no group was created.", (Object)newMetaGroup);
        TestMetaContactList.assertNull((String)"createMetaContactGroup tried to create a proto group too early.", (Object)MclSlickFixture.mockPresOpSet.getServerStoredContactListRoot().getGroup(newGroupName));
        this.fixture.metaClService.createMetaContact((ProtocolProviderService)MclSlickFixture.mockProvider, newMetaGroup, newContactID);
        MockContactGroup newMockGroup = (MockContactGroup)MclSlickFixture.mockPresOpSet.getServerStoredContactListRoot().getGroup(newGroupName);
        TestMetaContactList.assertNotNull((String)"createMetaContact did not create a parent proto group when it had to.", (Object)newMockGroup);
        TestMetaContactList.assertSame((String)"createMetaContact created a proto group but did not add it to the right meta contact group.", (Object)newMockGroup, (Object)newMetaGroup.getContactGroup(newGroupName, (ProtocolProviderService)MclSlickFixture.mockProvider));
        MetaContact newMetaContact = newMetaGroup.getMetaContact((ProtocolProviderService)MclSlickFixture.mockProvider, newContactID);
        TestMetaContactList.assertNotNull((String)"createMetaContact failed", (Object)newMetaContact);
        String renamedGroupName = "new" + newGroupName;
        this.fixture.metaClService.renameMetaContactGroup(newMetaGroup, renamedGroupName);
        TestMetaContactList.assertEquals((String)"renameMetaContactGroup failed", (String)newMetaGroup.getGroupName(), (String)renamedGroupName);
        TestMetaContactList.assertEquals((String)"renameMetaContactGroup didn't renamed a proto group!", (String)newMockGroup.getGroupName(), (String)renamedGroupName);
        this.fixture.metaClService.removeMetaContactGroup(newMetaGroup);
        TestMetaContactList.assertNull((String)"removeMetaContactGroup failed - group not removed.", (Object)this.fixture.metaClService.getRoot().getMetaContactSubgroup(newGroupName));
        TestMetaContactList.assertNull((String)"removeMetaContact did not remove the corresp. proto group.", (Object)MclSlickFixture.mockPresOpSet.getServerStoredContactListRoot().getGroup(newGroupName));
    }

    public void testFindParentMetaContactGroup() {
        MetaContact metaContact1 = this.fixture.metaClService.findMetaContactByContact((Contact)MetaContactListServiceLick.subLevelContact);
        MetaContact metaContact2 = this.fixture.metaClService.findMetaContactByContact((Contact)MetaContactListServiceLick.subsubContact);
        MetaContactGroup metaGroup = this.fixture.metaClService.findParentMetaContactGroup(metaContact1);
        TestMetaContactList.assertNotNull((String)("find failed for contact " + metaContact1), (Object)metaGroup);
        TestMetaContactList.assertEquals((String)("find failed (wrong group) for contact " + metaContact1.getDisplayName()), (String)"SomePeople", (String)metaGroup.getGroupName());
        metaGroup = this.fixture.metaClService.findParentMetaContactGroup(metaContact2);
        TestMetaContactList.assertNotNull((String)("find failed for contact " + metaContact2), (Object)metaGroup);
        TestMetaContactList.assertEquals((String)("find failed (wrong group) for contact " + metaContact2.getDisplayName()), (String)MetaContactListServiceLick.subLevelGroup.getGroupName(), (String)metaGroup.getGroupName());
    }

    public void testRenameMetaContact() {
        String newName = "testRenameMetaContact.AyNewName";
        MockContact mockContact = MetaContactListServiceLick.mockContactToRename;
        String oldMockContactDisplayName = mockContact.getDisplayName();
        MetaContact contactToRename = this.fixture.metaClService.findMetaContactByContact((Contact)mockContact);
        MclEventCollector evtCollector = new MclEventCollector();
        this.fixture.metaClService.addMetaContactListListener((MetaContactListListener)evtCollector);
        this.fixture.metaClService.renameMetaContact(contactToRename, newName);
        this.fixture.metaClService.removeMetaContactListListener((MetaContactListListener)evtCollector);
        TestMetaContactList.assertEquals((String)"Events delivered while renaming a meta contact", (int)1, (int)evtCollector.collectedMetaContactEvents.size());
        MetaContactRenamedEvent event = (MetaContactRenamedEvent)evtCollector.collectedMetaContactEvents.remove(0);
        TestMetaContactList.assertSame((String)"Source contact in MetaContactRenamedEvent gen. upon remove.", (Object)contactToRename, (Object)event.getSourceMetaContact());
        TestMetaContactList.assertEquals((String)"Event ID in MetaContactEvent gen. upon remove.", (String)"MetaContactRenamedEvent", (String)event.getPropertyName());
        TestMetaContactList.assertEquals((String)"DisplayName of a MetaContact unchanged after renaming", (String)newName, (String)contactToRename.getDisplayName());
        TestMetaContactList.assertEquals((String)"Proto Contact modified after renaming a MetaContact", (String)oldMockContactDisplayName, (String)mockContact.getDisplayName());
    }

    public void testFindParentMetaContactGroup2() {
        MetaContactGroup metaContactGroup1 = this.fixture.metaClService.findMetaContactGroupByContactGroup((ContactGroup)MetaContactListServiceLick.topLevelMockGroup);
        MetaContactGroup metaContactGroup2 = this.fixture.metaClService.findMetaContactGroupByContactGroup((ContactGroup)MetaContactListServiceLick.subLevelGroup);
        MetaContactGroup metaGroup = this.fixture.metaClService.findParentMetaContactGroup(metaContactGroup1);
        TestMetaContactList.assertNotNull((String)("find failed for contact " + metaContactGroup1), (Object)metaGroup);
        TestMetaContactList.assertEquals((String)("find failed (wrong group) for group " + metaContactGroup1.getGroupName()), (String)this.fixture.metaClService.getRoot().getGroupName(), (String)metaGroup.getGroupName());
        metaGroup = this.fixture.metaClService.findParentMetaContactGroup(metaContactGroup2);
        TestMetaContactList.assertNotNull((String)("find failed for contact " + metaContactGroup2), (Object)metaGroup);
        TestMetaContactList.assertEquals((String)("find failed (wrong group) for group " + metaContactGroup2.getGroupName()), (String)"SomePeople", (String)metaGroup.getGroupName());
    }

    private class MclEventCollector
    implements MetaContactListListener {
        public Vector<EventObject> collectedMetaContactEvents = new Vector();
        public Vector<EventObject> collectedMetaContactGroupEvents = new Vector();

        private MclEventCollector() {
        }

        public void metaContactAdded(MetaContactEvent evt) {
            this.collectedMetaContactEvents.add((EventObject)evt);
        }

        public void metaContactGroupAdded(MetaContactGroupEvent evt) {
            this.collectedMetaContactGroupEvents.add((EventObject)evt);
        }

        public void metaContactMoved(MetaContactMovedEvent evt) {
            this.collectedMetaContactEvents.add((EventObject)evt);
        }

        public void metaContactRenamed(MetaContactRenamedEvent evt) {
            this.collectedMetaContactEvents.add((EventObject)evt);
        }

        public void metaContactModified(MetaContactModifiedEvent evt) {
        }

        public void protoContactMoved(ProtoContactEvent evt) {
            this.collectedMetaContactEvents.add((EventObject)evt);
        }

        public void protoContactModified(ProtoContactEvent evt) {
        }

        public void protoContactRemoved(ProtoContactEvent evt) {
            this.collectedMetaContactEvents.add((EventObject)evt);
        }

        public void metaContactGroupModified(MetaContactGroupEvent evt) {
            this.collectedMetaContactGroupEvents.add((EventObject)evt);
        }

        public void metaContactGroupRemoved(MetaContactGroupEvent evt) {
            this.collectedMetaContactGroupEvents.add((EventObject)evt);
        }

        public void metaContactRemoved(MetaContactEvent evt) {
            this.collectedMetaContactEvents.add((EventObject)evt);
        }

        public void protoContactAdded(ProtoContactEvent evt) {
            this.collectedMetaContactEvents.add((EventObject)evt);
        }

        public void childContactsReordered(MetaContactGroupEvent evt) {
            this.collectedMetaContactGroupEvents.add((EventObject)evt);
        }

        public void metaContactAvatarUpdated(MetaContactAvatarUpdateEvent evt) {
            this.collectedMetaContactGroupEvents.add((EventObject)evt);
        }
    }
}

