/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.presence;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.presence.StatusSelectorMenu;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.ImageUtils;
import net.java.sip.communicator.plugin.desktoputil.LightGrayFilter;
import net.java.sip.communicator.plugin.desktoputil.SelectedObject;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.globalstatus.GlobalStatusEnum;

public class SimpleStatusMenu
extends StatusSelectorMenu
implements ActionListener {
    private final JCheckBoxMenuItem onlineItem;
    private final JCheckBoxMenuItem offlineItem;
    private ButtonGroup group = new ButtonGroup();

    public SimpleStatusMenu(ProtocolProviderService protocolProvider) {
        this(protocolProvider, protocolProvider.getAccountID().getDisplayName(), SimpleStatusMenu.getProtocolImage(protocolProvider, "IconSize16x16"));
    }

    private SimpleStatusMenu(ProtocolProviderService protocolProvider, String displayName, Image onlineImage) {
        super(displayName, onlineImage == null ? null : new ImageIcon(onlineImage), protocolProvider);
        this.setToolTipText("<html><b>" + displayName + "</b><br>Offline</html>");
        JLabel titleLabel = new JLabel(displayName);
        titleLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        titleLabel.setFont(titleLabel.getFont().deriveFont(1));
        this.add(titleLabel);
        this.addSeparator();
        this.onlineItem = this.createMenuItem("service.gui.ONLINE", this.getIcon(), "Online");
        this.offlineItem = this.createMenuItem("service.gui.OFFLINE", onlineImage == null ? null : new ImageIcon(LightGrayFilter.createDisabledImage((Image)onlineImage)), "Offline");
        this.group.add(this.onlineItem);
        this.group.add(this.offlineItem);
        this.updateStatus(null);
    }

    private JCheckBoxMenuItem createMenuItem(String textKey, Icon icon, String name) {
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(GuiActivator.getResources().getI18NString(textKey), icon);
        menuItem.setName(name);
        menuItem.addActionListener(this);
        this.add(menuItem);
        return menuItem;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (GuiActivator.getGlobalStatusService() == null) {
            return;
        }
        JMenuItem menuItem = (JMenuItem)e.getSource();
        String itemName = menuItem.getName();
        if (itemName.equals("Online")) {
            GuiActivator.getGlobalStatusService().publishStatus(this.protocolProvider, (PresenceStatus)GlobalStatusEnum.ONLINE);
        } else {
            GuiActivator.getGlobalStatusService().publishStatus(this.protocolProvider, (PresenceStatus)GlobalStatusEnum.OFFLINE);
        }
    }

    @Override
    public void updateStatus(PresenceStatus presenceStatus) {
        String tooltip = this.getToolTipText();
        tooltip = tooltip.substring(0, tooltip.lastIndexOf("<br>"));
        ImageIcon statusImage = ImageLoader.getAccountStatusImage(this.protocolProvider);
        JCheckBoxMenuItem menuItem = this.protocolProvider.isRegistered() ? this.onlineItem : this.offlineItem;
        menuItem.setSelected(true);
        this.setSelected(new SelectedObject((Icon)statusImage, (Object)menuItem));
        this.setToolTipText(tooltip.concat("<br>" + menuItem.getText()));
    }

    @Override
    public void loadSkin() {
        super.loadSkin();
        Image image = SimpleStatusMenu.getProtocolImage(this.protocolProvider, "IconSize16x16");
        if (image != null) {
            this.setIcon(new ImageIcon(image));
        }
        if (this.onlineItem != null) {
            this.onlineItem.setIcon(this.getIcon());
        }
        if (this.offlineItem != null && image != null) {
            this.offlineItem.setIcon(new ImageIcon(LightGrayFilter.createDisabledImage((Image)image)));
        }
    }

    private static Image getProtocolImage(ProtocolProviderService pps, String iconSize) {
        byte[] bytes = pps.getProtocolIcon().getIcon(iconSize);
        return bytes == null ? null : ImageUtils.getBytesInImage((byte[])bytes);
    }
}

