/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.contactlist.notifsource;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.JPopupMenu;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.UINotification;
import net.java.sip.communicator.impl.gui.main.UINotificationGroup;
import net.java.sip.communicator.impl.gui.main.UINotificationManager;
import net.java.sip.communicator.impl.gui.main.contactlist.GroupNode;
import net.java.sip.communicator.impl.gui.main.contactlist.TreeContactList;
import net.java.sip.communicator.impl.gui.main.contactlist.UIGroupImpl;
import net.java.sip.communicator.impl.gui.main.contactlist.notifsource.NotificationContact;
import net.java.sip.communicator.service.gui.UIContact;
import net.java.sip.communicator.service.gui.UIGroup;
import net.java.sip.communicator.service.protocol.NotificationMessage;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.MessageWaitingEvent;

public class NotificationGroup
extends UIGroupImpl {
    private final String groupName;
    private GroupNode groupNode;
    private final Hashtable<String, NotificationContact> contacts = new Hashtable();
    private static UINotificationGroup uiNotificationGroup;

    public NotificationGroup(String groupName) {
        this.groupName = groupName;
    }

    public Object getDescriptor() {
        return this.groupName;
    }

    public String getDisplayName() {
        return this.groupName;
    }

    public int getSourceIndex() {
        return 0;
    }

    public UIGroup getParentGroup() {
        return null;
    }

    public boolean isGroupCollapsed() {
        return false;
    }

    public int countOnlineChildContacts() {
        return this.contacts.size();
    }

    public int countChildContacts() {
        return this.contacts.size();
    }

    public String getId() {
        return null;
    }

    @Override
    public GroupNode getGroupNode() {
        return this.groupNode;
    }

    @Override
    public void setGroupNode(GroupNode groupNode) {
        this.groupNode = groupNode;
    }

    public JPopupMenu getRightButtonMenu() {
        return null;
    }

    public Iterator<? extends UIContact> getNotifications() {
        return this.contacts.values().iterator();
    }

    public void messageWaitingNotify(MessageWaitingEvent event) {
        Iterator messages = event.getMessages();
        if (messages != null) {
            Enumeration<String> contactIdentifiers = this.contacts.keys();
            while (contactIdentifiers.hasMoreElements()) {
                String identifier = contactIdentifiers.nextElement();
                boolean toRemove = true;
                messages = event.getMessages();
                while (messages.hasNext()) {
                    NotificationMessage message = (NotificationMessage)messages.next();
                    String messageIdentifier = message.getFromContact() + message.getMessageDetails();
                    if (!identifier.equals(messageIdentifier)) continue;
                    toRemove = false;
                    break;
                }
                if (!toRemove) continue;
                this.removeNotificationContact(this.contacts.get(identifier));
                this.contacts.remove(identifier);
            }
            messages = event.getMessages();
            while (messages.hasNext()) {
                NotificationMessage message = (NotificationMessage)messages.next();
                if (!message.getMessageGroup().equals(this.groupName)) continue;
                String messageIdentifier = message.getFromContact() + message.getMessageDetails();
                NotificationContact contact = this.contacts.get(messageIdentifier);
                boolean isNew = false;
                if (contact == null) {
                    contact = new NotificationContact(this, event.getSourceProvider(), event.getMessageType(), message);
                    this.contacts.put(messageIdentifier, contact);
                    isNew = true;
                }
                contact.setMessageAccount(event.getAccount());
                this.addNotificationContact(contact, isNew);
            }
        } else {
            ProtocolProviderService protocolProvider = event.getSourceProvider();
            NotificationContact contact = this.contacts.get(protocolProvider.toString());
            boolean isNew = false;
            if (contact == null) {
                contact = new NotificationContact(this, protocolProvider, event.getMessageType(), null);
                this.contacts.put(protocolProvider.toString(), contact);
                isNew = true;
            }
            contact.setMessageAccount(event.getAccount());
            contact.setUnreadUrgentMessageCount(event.getUnreadUrgentMessages());
            contact.setUnreadMessageCount(event.getUnreadMessages());
            contact.setReadMessageCount(event.getReadMessages());
            this.addNotificationContact(contact, isNew);
        }
    }

    private void addNotificationContact(NotificationContact contact, boolean isNew) {
        TreeContactList contactList = GuiActivator.getContactList();
        if (contactList.getCurrentFilter().isMatching((UIContact)contact)) {
            if (isNew) {
                contactList.addContact(contact, this, true, true);
            } else {
                contactList.refreshContact(contact);
            }
        }
        if (contact.getUnreadMessageCount() > 0) {
            if (uiNotificationGroup == null) {
                uiNotificationGroup = new UINotificationGroup(this.getDisplayName(), GuiActivator.getResources().getI18NString("service.gui.VOICEMAIL_TOOLTIP"));
            }
            UINotificationManager.addNotification(new UINotification(contact.getDisplayName(), contact.getDisplayName() + " : " + contact.getDisplayDetails(), System.currentTimeMillis(), uiNotificationGroup, contact.getUnreadMessageCount()));
        }
    }

    private void removeNotificationContact(NotificationContact contact) {
        TreeContactList contactList = GuiActivator.getContactList();
        if (contactList.getCurrentFilter().isMatching((UIContact)contact)) {
            contactList.removeContact(contact);
        }
    }
}

