/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.call.CallToolBarButton;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.SIPCommPopupMenu;
import net.java.sip.communicator.plugin.desktoputil.SIPCommTextField;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetTelephonyPark;
import net.java.sip.communicator.util.Logger;

public class ParkCallButton
extends CallToolBarButton {
    private static final Logger logger = Logger.getLogger(ParkCallButton.class);
    private final Call call;

    public ParkCallButton(Call c) {
        super(ImageLoader.getImage(ImageLoader.PARK_CALL_BUTTON), GuiActivator.getResources().getI18NString("service.gui.PARK_BUTTON_TOOL_TIP"));
        this.call = c;
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParkCallButton.this.parkCall();
            }
        });
    }

    private void parkCall() {
        OperationSetTelephonyPark parkOpSet = (OperationSetTelephonyPark)this.call.getProtocolProvider().getOperationSet(OperationSetTelephonyPark.class);
        if (parkOpSet == null) {
            return;
        }
        CallPeer peer = (CallPeer)this.call.getCallPeers().next();
        JPopupMenu parkMenu = this.createParkMenu(peer);
        Point location = new Point(this.getX(), this.getY() + this.getHeight());
        SwingUtilities.convertPointToScreen(location, this.getParent());
        parkMenu.setLocation(location);
        parkMenu.setVisible(true);
    }

    private JPopupMenu createParkMenu(CallPeer peer) {
        final SIPCommTextField textField = new SIPCommTextField("");
        textField.setColumns(10);
        SIPCommPopupMenu popupMenu = new SIPCommPopupMenu(){

            public void setVisible(boolean b) {
                super.setVisible(b);
                if (b) {
                    textField.requestFocus();
                }
            }
        };
        popupMenu.setInvoker((Component)((Object)this));
        popupMenu.setFocusable(true);
        TransparentPanel content = new TransparentPanel();
        JLabel parkingSlot = new JLabel(GuiActivator.getResources().getI18NString("service.gui.PARKING_SLOT"));
        content.add((Component)parkingSlot);
        content.add((Component)textField);
        textField.requestFocus();
        JButton button = new JButton(GuiActivator.getResources().getI18NString("service.gui.PARK"));
        content.add((Component)button);
        popupMenu.add((Component)content);
        button.addActionListener(new ActionListener((JPopupMenu)popupMenu, textField, peer){
            final /* synthetic */ JPopupMenu val$popupMenu;
            final /* synthetic */ SIPCommTextField val$textField;
            final /* synthetic */ CallPeer val$peer;
            {
                this.val$popupMenu = jPopupMenu;
                this.val$textField = sIPCommTextField;
                this.val$peer = callPeer;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.val$popupMenu.setVisible(false);
                OperationSetTelephonyPark parkOpSet = (OperationSetTelephonyPark)ParkCallButton.this.call.getProtocolProvider().getOperationSet(OperationSetTelephonyPark.class);
                try {
                    parkOpSet.parkCall(this.val$textField.getText(), this.val$peer);
                }
                catch (OperationFailedException ex) {
                    logger.error((Object)("Failed to park " + this.val$peer.getAddress() + " to " + this.val$textField.getText()), (Throwable)ex);
                }
            }
        });
        return popupMenu;
    }
}

