/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.call.VolumeControlSlider;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.AntialiasingManager;
import net.java.sip.communicator.plugin.desktoputil.ImageUtils;
import net.java.sip.communicator.plugin.desktoputil.SIPCommButton;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.protocol.CallConference;
import net.java.sip.communicator.service.protocol.media.MediaAwareCallConference;
import net.java.sip.communicator.service.resources.ImageID;
import org.jitsi.service.neomedia.VolumeControl;
import org.jitsi.service.resources.ResourceManagementService;

public class OutputVolumeControlButton {
    private final CallConference callConference;
    private final boolean fullScreen;
    private ImageID iconImageID;
    private final boolean inButtonToolBar;

    public OutputVolumeControlButton(CallConference callConference, ImageID iconImageID, boolean fullScreen, boolean inButtonToolBar) {
        this.callConference = callConference;
        this.iconImageID = iconImageID;
        this.fullScreen = fullScreen;
        this.inButtonToolBar = inButtonToolBar;
    }

    public Component createSliderComponent() {
        ResourceManagementService r = GuiActivator.getResources();
        final Color bgColor = new Color(r.getColor("service.gui.CALL_TOOL_BAR_SOUND_BG"));
        TransparentPanel soundPanel = new TransparentPanel(new FlowLayout(0, 0, 0)){

            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                g = g.create();
                try {
                    AntialiasingManager.activateAntialiasing((Graphics)g);
                    g.setColor(bgColor);
                    g.fillRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 8, 8);
                }
                finally {
                    g.dispose();
                }
            }
        };
        soundPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        VolumeControl volumeControl = this.getOutputVolumeControl();
        VolumeControlSlider slider = new VolumeControlSlider(volumeControl, 0);
        soundPanel.add((Component)new JLabel(r.getImage("service.gui.icons.NO_SOUND_ICON")));
        soundPanel.add((Component)((Object)slider));
        soundPanel.add((Component)new JLabel(r.getImage("service.gui.icons.SOUND_MENU_ICON")));
        return soundPanel;
    }

    public Component createVolumeControlButton(boolean isButtonBar, ImageID iconImageID, String toolTipTextKey) {
        this.iconImageID = iconImageID;
        final VolumeControlButton volumeControlButton = new VolumeControlButton(isButtonBar);
        if (toolTipTextKey != null) {
            volumeControlButton.setToolTipText(GuiActivator.getResources().getI18NString(toolTipTextKey));
        }
        VolumeControl volumeControl = this.getOutputVolumeControl();
        final JPopupMenu sliderMenu = new VolumeControlSlider(volumeControl, 1).getPopupMenu();
        sliderMenu.setInvoker((Component)((Object)volumeControlButton));
        volumeControlButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Point location = new Point(volumeControlButton.getX(), volumeControlButton.getY() + volumeControlButton.getHeight());
                SwingUtilities.convertPointToScreen(location, volumeControlButton.getParent());
                sliderMenu.setLocation(location);
                sliderMenu.setVisible(!sliderMenu.isVisible());
            }
        });
        return volumeControlButton;
    }

    public Component getComponent() {
        if (this.fullScreen) {
            return this.createSliderComponent();
        }
        return this.createVolumeControlButton(this.inButtonToolBar, this.iconImageID, "service.gui.VOLUME_CONTROL_TOOL_TIP");
    }

    private VolumeControl getOutputVolumeControl() {
        VolumeControl volumeControl = null;
        if (this.callConference instanceof MediaAwareCallConference) {
            volumeControl = ((MediaAwareCallConference)this.callConference).getOutputVolumeControl();
        }
        if (volumeControl == null) {
            volumeControl = GuiActivator.getMediaService().getOutputVolumeControl();
        }
        return volumeControl;
    }

    private class VolumeControlButton
    extends SIPCommButton {
        private ImageID bgImage;
        private ImageID pressedImage;

        public VolumeControlButton(boolean inSettingsPanel) {
            super((Image)ImageLoader.getImage(ImageLoader.SOUND_SETTING_BUTTON_PRESSED), (Image)ImageLoader.getImage(OutputVolumeControlButton.this.iconImageID));
            if (inSettingsPanel) {
                this.bgImage = ImageLoader.CALL_SETTING_BUTTON_BG;
                this.pressedImage = ImageLoader.CALL_SETTING_BUTTON_PRESSED_BG;
            } else {
                this.bgImage = ImageLoader.SOUND_SETTING_BUTTON_BG;
                this.pressedImage = ImageLoader.SOUND_SETTING_BUTTON_PRESSED;
            }
            this.loadSkin();
        }

        public void loadSkin() {
            this.setBackgroundImage(ImageLoader.getImage(this.bgImage));
            this.setPressedImage(ImageLoader.getImage(this.pressedImage));
            if (OutputVolumeControlButton.this.iconImageID != null) {
                if (!OutputVolumeControlButton.this.fullScreen && !OutputVolumeControlButton.this.inButtonToolBar) {
                    this.setIconImage(ImageUtils.scaleImageWithinBounds((Image)ImageLoader.getImage(OutputVolumeControlButton.this.iconImageID), (int)18, (int)18));
                } else {
                    this.setIconImage(ImageLoader.getImage(OutputVolumeControlButton.this.iconImageID));
                }
            }
        }
    }
}

