/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call;

import java.util.List;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.call.AbstractCallToggleButton;
import net.java.sip.communicator.impl.gui.main.call.CallManager;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallConference;
import net.java.sip.communicator.service.protocol.OperationSetVideoTelephony;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.ConfigurationUtils;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.MediaUseCase;
import org.jitsi.service.neomedia.device.MediaDevice;

public class LocalVideoButton
extends AbstractCallToggleButton {
    private static final long serialVersionUID = 0L;
    private final CallConference callConference;

    public LocalVideoButton(Call call) {
        this(call, false);
    }

    public LocalVideoButton(Call call, boolean selected) {
        super(null, true, selected, ImageLoader.LOCAL_VIDEO_BUTTON, ImageLoader.LOCAL_VIDEO_BUTTON_PRESSED, "service.gui.LOCAL_VIDEO_BUTTON_TOOL_TIP");
        this.callConference = call.getConference();
    }

    @Override
    public void buttonPressed() {
        List calls = this.callConference.getCalls();
        if (!calls.isEmpty()) {
            Call call;
            CallManager.enableLocalVideo(call, !CallManager.isLocalVideoEnabled(call = (Call)calls.get(0)));
        }
    }

    public void setEnabled(boolean enabled) {
        boolean videoAvailable;
        String toolTipTextKey;
        MediaDevice videoDevice = GuiActivator.getMediaService().getDefaultDevice(MediaType.VIDEO, MediaUseCase.CALL);
        if (videoDevice == null || !videoDevice.getDirection().allowsSending()) {
            toolTipTextKey = "service.gui.NO_CAMERA_AVAILABLE";
            videoAvailable = false;
        } else {
            boolean hasVideoTelephony = false;
            boolean hasEnabledVideoFormat = false;
            for (Call conferenceCall : this.callConference.getCalls()) {
                OperationSetVideoTelephony videoTelephony;
                ProtocolProviderService protocolProvider = conferenceCall.getProtocolProvider();
                if (!hasVideoTelephony && (videoTelephony = (OperationSetVideoTelephony)protocolProvider.getOperationSet(OperationSetVideoTelephony.class)) != null) {
                    hasVideoTelephony = true;
                }
                if (!hasEnabledVideoFormat && ConfigurationUtils.hasEnabledVideoFormat((ProtocolProviderService)protocolProvider)) {
                    hasEnabledVideoFormat = true;
                }
                if (!hasVideoTelephony || !hasEnabledVideoFormat) continue;
                break;
            }
            if (!hasVideoTelephony) {
                toolTipTextKey = "service.gui.NO_VIDEO_FOR_PROTOCOL";
                videoAvailable = false;
            } else if (!hasEnabledVideoFormat) {
                toolTipTextKey = "service.gui.NO_VIDEO_ENCODINGS";
                videoAvailable = false;
            } else {
                toolTipTextKey = "service.gui.LOCAL_VIDEO_BUTTON_TOOL_TIP";
                videoAvailable = true;
            }
        }
        this.setToolTipText(GuiActivator.getResources().getI18NString(toolTipTextKey));
        super.setEnabled(videoAvailable && enabled);
    }
}

