/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call;

import java.awt.Component;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JList;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.account.Account;
import net.java.sip.communicator.impl.gui.main.call.CallManager;
import net.java.sip.communicator.impl.gui.main.call.PreCallDialog;
import net.java.sip.communicator.impl.gui.main.contactlist.UIContactImpl;
import net.java.sip.communicator.service.protocol.OperationSet;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;

public class ChooseCallAccountDialog
extends PreCallDialog {
    private final String contactAddress;
    private final Class<? extends OperationSet> opSetClass;
    private UIContactImpl uiContact;

    public ChooseCallAccountDialog(String contactAddress, Class<? extends OperationSet> opSetClass, List<ProtocolProviderService> providers) {
        super(GuiActivator.getResources().getI18NString("service.gui.CALL_VIA"), GuiActivator.getResources().getI18NString("service.gui.CHOOSE_ACCOUNT"), GuiActivator.getAccounts(providers));
        this.contactAddress = contactAddress;
        this.opSetClass = opSetClass;
        this.getAccountsCombo().setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 0L;

            @Override
            public Component getListCellRendererComponent(JList jlist, Object obj, int i, boolean flag, boolean flag1) {
                super.getListCellRendererComponent((JList<?>)jlist, obj, i, flag, flag1);
                Account account = (Account)obj;
                this.setText(account.getAccountID().getDisplayName());
                byte[] protocolIcon = account.getProtocolProvider().getProtocolIcon().getIcon("IconSize16x16");
                if (protocolIcon != null) {
                    this.setIcon(new ImageIcon(protocolIcon));
                }
                return this;
            }
        });
    }

    protected ProtocolProviderService getSelectedProvider() {
        return ((Account)this.getAccountsCombo().getSelectedItem()).getProtocolProvider();
    }

    @Override
    public void callButtonPressed() {
        if (this.uiContact != null) {
            CallManager.createCall(this.opSetClass, this.getSelectedProvider(), this.contactAddress, this.uiContact);
        } else {
            CallManager.createCall(this.opSetClass, this.getSelectedProvider(), this.contactAddress);
        }
    }

    @Override
    public void mergeCallButtonPressed() {
    }

    @Override
    public void hangupButtonPressed() {
        this.dispose();
    }

    @Override
    public void videoCallButtonPressed() {
        this.callButtonPressed();
    }

    public void setUIContact(UIContactImpl uiContact) {
        this.uiContact = uiContact;
    }
}

