/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.account;

import java.awt.Image;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.ImageUtils;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.ProtocolIcon;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;

public class Account {
    private ProtocolProviderService protocolProvider;
    private final AccountID accountID;
    private final String name;
    private ImageIcon icon;
    private boolean isEnabled;
    private JCheckBox enableCheckBox;

    public Account(ProtocolProviderService protocolProvider) {
        this.protocolProvider = protocolProvider;
        this.accountID = protocolProvider.getAccountID();
        this.name = this.accountID.getDisplayName();
        this.icon = this.getProtocolIcon(protocolProvider);
        this.isEnabled = this.accountID.isEnabled();
    }

    public Account(AccountID accountID) {
        this.accountID = accountID;
        this.name = accountID.getDisplayName();
        String iconPath = accountID.getAccountPropertyString((Object)"ACCOUNT_ICON_PATH");
        if (iconPath != null) {
            this.icon = ImageLoader.getImageForPath(iconPath);
        }
        this.isEnabled = accountID.isEnabled();
    }

    public ProtocolProviderService getProtocolProvider() {
        return this.protocolProvider;
    }

    public AccountID getAccountID() {
        return this.accountID;
    }

    public String getName() {
        return this.name;
    }

    public String getProtocolName() {
        return this.accountID.getProtocolDisplayName();
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String getStatusName() {
        if (this.protocolProvider != null) {
            return this.getAccountStatus(this.protocolProvider);
        }
        return "Offline";
    }

    public Icon getStatusIcon() {
        if (this.protocolProvider != null) {
            return ImageLoader.getAccountStatusImage(this.protocolProvider);
        }
        if (this.icon != null) {
            this.icon = ImageLoader.getImageForPath(this.accountID.getAccountPropertyString((Object)"ACCOUNT_ICON_PATH"));
            Image scaledImage = ImageUtils.scaleImageWithinBounds((Image)this.icon.getImage(), (int)16, (int)16);
            if (scaledImage != null) {
                return new ImageIcon(GrayFilter.createDisabledImage(scaledImage));
            }
        }
        return null;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    private String getAccountStatus(ProtocolProviderService protocolProvider) {
        if (protocolProvider == null) {
            return GuiActivator.getResources().getI18NString("service.gui.OFFLINE");
        }
        OperationSetPresence presence = (OperationSetPresence)protocolProvider.getOperationSet(OperationSetPresence.class);
        String status = presence != null ? presence.getPresenceStatus().getStatusName() : GuiActivator.getResources().getI18NString(protocolProvider.isRegistered() ? "service.gui.ONLINE" : "service.gui.OFFLINE");
        return status;
    }

    private ImageIcon getProtocolIcon(ProtocolProviderService protocolProvider) {
        ProtocolIcon protocolIcon = protocolProvider.getProtocolIcon();
        Image protocolImage = ImageUtils.getBytesInImage((byte[])protocolIcon.getIcon("IconSize32x32"));
        if (protocolImage != null) {
            return new ImageIcon(protocolImage);
        }
        protocolImage = ImageUtils.getBytesInImage((byte[])protocolIcon.getIcon("IconSize48x48"));
        if (protocolImage == null) {
            protocolImage = ImageUtils.getBytesInImage((byte[])protocolIcon.getIcon("IconSize64x64"));
        }
        if (protocolImage != null) {
            return ImageUtils.scaleIconWithinBounds((Image)protocolImage, (int)32, (int)32);
        }
        return null;
    }

    public void setProtocolProvider(ProtocolProviderService protocolProvider) {
        this.protocolProvider = protocolProvider;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public void setEnableCheckBox(JCheckBox enableCheckBox) {
        this.enableCheckBox = enableCheckBox;
    }

    public JCheckBox getEnableCheckBox() {
        return this.enableCheckBox;
    }

    public String toString() {
        return this.accountID.getDisplayName();
    }
}

