/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icbm;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.rv.NewRvSessionEvent;
import net.kano.joscar.rv.RecvRvEvent;
import net.kano.joscar.rv.RvProcessor;
import net.kano.joscar.rv.RvProcessorListener;
import net.kano.joscar.rv.RvSession;
import net.kano.joscar.rv.RvSessionListener;
import net.kano.joscar.rv.RvSnacResponseEvent;
import net.kano.joscar.rvcmd.DefaultRvCommandFactory;
import net.kano.joscar.snac.SnacPacketEvent;
import net.kano.joscar.snac.SnacRequestListener;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.snaccmd.FullUserInfo;
import net.kano.joscar.snaccmd.WarningLevel;
import net.kano.joscar.snaccmd.conn.SnacFamilyInfo;
import net.kano.joscar.snaccmd.icbm.IcbmCommand;
import net.kano.joscar.snaccmd.icbm.InstantMessage;
import net.kano.joscar.snaccmd.icbm.MissedMessagesCmd;
import net.kano.joscar.snaccmd.icbm.MissedMsgInfo;
import net.kano.joscar.snaccmd.icbm.OldIcbm;
import net.kano.joscar.snaccmd.icbm.ParamInfo;
import net.kano.joscar.snaccmd.icbm.ParamInfoCmd;
import net.kano.joscar.snaccmd.icbm.ParamInfoRequest;
import net.kano.joscar.snaccmd.icbm.RecvImIcbm;
import net.kano.joscar.snaccmd.icbm.RecvTypingNotification;
import net.kano.joscar.snaccmd.icbm.RvCommand;
import net.kano.joscar.snaccmd.icbm.SendImIcbm;
import net.kano.joscar.snaccmd.icbm.SendTypingNotification;
import net.kano.joscar.snaccmd.icbm.SetParamInfoCmd;
import net.kano.joustsim.Screenname;
import net.kano.joustsim.oscar.AimConnection;
import net.kano.joustsim.oscar.BuddyInfo;
import net.kano.joustsim.oscar.BuddyInfoManager;
import net.kano.joustsim.oscar.CapabilityHandler;
import net.kano.joustsim.oscar.oscar.OscarConnection;
import net.kano.joustsim.oscar.oscar.service.AbstractService;
import net.kano.joustsim.oscar.oscar.service.icbm.Conversation;
import net.kano.joustsim.oscar.oscar.service.icbm.ConversationAdapter;
import net.kano.joustsim.oscar.oscar.service.icbm.ConversationEventInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.DirectMessage;
import net.kano.joustsim.oscar.oscar.service.icbm.DirectimConversation;
import net.kano.joustsim.oscar.oscar.service.icbm.IcbmListener;
import net.kano.joustsim.oscar.oscar.service.icbm.ImConversation;
import net.kano.joustsim.oscar.oscar.service.icbm.ImMessageInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.Message;
import net.kano.joustsim.oscar.oscar.service.icbm.MessageQueuedEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.MissedImInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.MutableIcbmService;
import net.kano.joustsim.oscar.oscar.service.icbm.RendezvousCapabilityHandler;
import net.kano.joustsim.oscar.oscar.service.icbm.RendezvousSessionHandler;
import net.kano.joustsim.oscar.oscar.service.icbm.SendFailedEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.TypingInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.TypingState;
import net.kano.joustsim.oscar.oscar.service.icbm.dim.DirectimConnection;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.IncomingRvConnection;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvConnectionManager;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvConnectionManagerListener;
import net.kano.joustsim.oscar.oscar.service.icbm.secureim.EncryptedAimMessage;
import net.kano.joustsim.oscar.oscar.service.icbm.secureim.EncryptedAimMessageInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.secureim.InternalSecureTools;
import net.kano.joustsim.oscar.oscar.service.icbm.secureim.SecureAimConversation;
import net.kano.joustsim.trust.BuddyCertificateInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IcbmServiceImpl
extends AbstractService
implements MutableIcbmService {
    private static final Logger LOGGER = Logger.getLogger(IcbmServiceImpl.class.getName());
    private static final int MAX_MESSAGE_SIZE = 8000;
    private final RvProcessor rvProcessor;
    private final RvConnectionManager rvConnectionManager;
    private final CopyOnWriteArrayList<IcbmListener> listeners = new CopyOnWriteArrayList();
    private final BuddyInfoManager buddyInfoManager;
    private final Map<Screenname, SecureAimConversation> secureAimConvs = new HashMap<Screenname, SecureAimConversation>();
    private final Map<Screenname, Set<DirectimConversation>> directimconvs = new HashMap<Screenname, Set<DirectimConversation>>();
    private final Map<Screenname, ImConversation> imconvs = new HashMap<Screenname, ImConversation>();
    private Map<Message, Set<DirectimConversation>> sentConversations = new WeakHashMap<Message, Set<DirectimConversation>>();
    private Map<Message, Set<DirectimConversation>> failedConversations = new WeakHashMap<Message, Set<DirectimConversation>>();

    public IcbmServiceImpl(AimConnection aimConnection, OscarConnection oscarConnection) {
        super(aimConnection, oscarConnection, 4);
        this.rvProcessor = new RvProcessor(oscarConnection.getSnacProcessor());
        this.rvProcessor.registerRvCmdFactory(new DefaultRvCommandFactory());
        this.rvProcessor.addListener(new DelegatingRvProcessorListener());
        this.rvConnectionManager = new RvConnectionManager(this);
        this.buddyInfoManager = this.getAimConnection().getBuddyInfoManager();
        this.rvConnectionManager.addConnectionManagerListener(new RvConnectionManagerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleNewIncomingConnection(RvConnectionManager manager, IncomingRvConnection connection) {
                if (connection instanceof DirectimConnection) {
                    DirectimConnection dim = (DirectimConnection)((Object)connection);
                    DirectimConversation conv = new DirectimConversation(IcbmServiceImpl.this.getAimConnection(), dim);
                    IcbmServiceImpl.this.initializeDirectimConv(conv);
                    IcbmServiceImpl icbmServiceImpl = IcbmServiceImpl.this;
                    synchronized (icbmServiceImpl) {
                        IcbmServiceImpl.this.getActualDirectimConversations(dim.getBuddyScreenname()).add(conv);
                    }
                    IcbmServiceImpl.this.fireNewConversationEvent(conv);
                }
            }
        });
    }

    private void initializeDirectimConv(final DirectimConversation conv) {
        conv.initialize();
        conv.addConversationListener(new ConversationAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void sentOtherEvent(Conversation conversation, ConversationEventInfo event) {
                if (event instanceof MessageQueuedEvent) {
                    MessageQueuedEvent mqe = (MessageQueuedEvent)event;
                    IcbmServiceImpl icbmServiceImpl = IcbmServiceImpl.this;
                    synchronized (icbmServiceImpl) {
                        IcbmServiceImpl.this.initializeMap(IcbmServiceImpl.this.sentConversations, mqe.getMessage()).add(conv);
                    }
                }
                if (event instanceof SendFailedEvent) {
                    SendFailedEvent event1 = (SendFailedEvent)event;
                    Message msg = event1.getMessage();
                    boolean fire = false;
                    Set convs = null;
                    IcbmServiceImpl icbmServiceImpl = IcbmServiceImpl.this;
                    synchronized (icbmServiceImpl) {
                        Set sent = (Set)IcbmServiceImpl.this.sentConversations.get(msg);
                        if (sent != null && sent.contains(conv)) {
                            Set failed = IcbmServiceImpl.this.initializeMap(IcbmServiceImpl.this.failedConversations, msg);
                            failed.add(conv);
                            if (failed.containsAll(sent)) {
                                fire = true;
                                convs = DefensiveTools.getUnmodifiableSetCopy(failed);
                                IcbmServiceImpl.this.sentConversations.remove(msg);
                                IcbmServiceImpl.this.failedConversations.remove(msg);
                            }
                        }
                    }
                    if (fire) {
                        assert (convs != null);
                        for (IcbmListener l : IcbmServiceImpl.this.listeners) {
                            l.sendAutomaticallyFailed(IcbmServiceImpl.this, msg, convs);
                        }
                    }
                }
            }
        });
    }

    private Set<DirectimConversation> initializeMap(Map<Message, Set<DirectimConversation>> map1, Message msg) {
        Set<DirectimConversation> convs = map1.get(msg);
        if (convs == null) {
            convs = new HashSet<DirectimConversation>();
            map1.put(msg, convs);
        }
        return convs;
    }

    private Screenname getScreenname() {
        return this.getAimConnection().getScreenname();
    }

    @Override
    public RvConnectionManager getRvConnectionManager() {
        return this.rvConnectionManager;
    }

    @Override
    public void addIcbmListener(IcbmListener l) {
        this.listeners.addIfAbsent(l);
    }

    @Override
    public void removeIcbmListener(IcbmListener l) {
        this.listeners.remove(l);
    }

    @Override
    public SnacFamilyInfo getSnacFamilyInfo() {
        return IcbmCommand.FAMILY_INFO;
    }

    @Override
    public void connected() {
        this.sendSnac(new ParamInfoRequest());
    }

    @Override
    public void handleSnacPacket(SnacPacketEvent snacPacketEvent) {
        SnacCommand snac = snacPacketEvent.getSnacCommand();
        if (snac instanceof ParamInfoCmd) {
            ParamInfoCmd pic = (ParamInfoCmd)snac;
            this.handleParamInfo(pic);
        } else if (snac instanceof RecvImIcbm) {
            RecvImIcbm icbm = (RecvImIcbm)snac;
            this.handleImIcbm(icbm);
        } else if (snac instanceof OldIcbm && ((OldIcbm)snac).getMessageType() == 1) {
            OldIcbm cmd = (OldIcbm)snac;
            RecvImIcbm icbm = new RecvImIcbm(cmd.getRequestID(), cmd.getUserInfo(), new InstantMessage(cmd.getReason()), cmd.isAutoResponse(), cmd.senderWantsIcon(), cmd.getIconInfo(), null, cmd.getFeaturesBlock(), true);
            this.handleImIcbm(icbm);
        } else if (snac instanceof OldIcbm) {
            OldIcbm cmd = (OldIcbm)snac;
            LOGGER.info("---------------------- " + cmd);
            LOGGER.info("---------------------- " + cmd.getMessageType());
        } else if (snac instanceof MissedMessagesCmd) {
            MissedMessagesCmd mc = (MissedMessagesCmd)snac;
            this.handleMissedMessages(mc);
        } else if (snac instanceof RecvTypingNotification) {
            RecvTypingNotification typnot = (RecvTypingNotification)snac;
            this.handleTypingNotification(typnot);
        }
    }

    @Override
    public RvProcessor getRvProcessor() {
        return this.rvProcessor;
    }

    private void handleParamInfo(ParamInfoCmd pic) {
        ParamInfo pi = pic.getParamInfo();
        long newflags = pi.getFlags() | 1L | 2L | 8L;
        ParamInfo newparams = new ParamInfo(newflags, 8000, WarningLevel.getInstanceFromX10(999), WarningLevel.getInstanceFromX10(999), 0L);
        this.sendSnac(new SetParamInfoCmd(newparams));
        this.setReady();
    }

    private void handleMissedMessages(MissedMessagesCmd mc) {
        List<MissedMsgInfo> msgs = mc.getMissedMsgInfos();
        for (MissedMsgInfo msg : msgs) {
            Screenname sn = new Screenname(msg.getUserInfo().getScreenname());
            ImConversation conv = this.getImConversation(sn);
            conv.handleMissedMsg(MissedImInfo.getInstance(this.getScreenname(), msg));
        }
    }

    private void handleImIcbm(RecvImIcbm icbm) {
        FullUserInfo senderInfo = icbm.getSenderInfo();
        if (senderInfo == null) {
            return;
        }
        Screenname sender = new Screenname(senderInfo.getScreenname());
        InstantMessage message = icbm.getMessage();
        if (message == null) {
            return;
        }
        if (message.isEncrypted()) {
            SecureAimConversation conv = this.getSecureAimConversation(sender);
            EncryptedAimMessage msg = InternalSecureTools.getEncryptedAimMessageInstance(icbm);
            if (msg == null) {
                return;
            }
            BuddyInfo info = this.buddyInfoManager.getBuddyInfo(sender);
            BuddyCertificateInfo certInfo = info.getCertificateInfo();
            EncryptedAimMessageInfo minfo = EncryptedAimMessageInfo.getInstance(this.getScreenname(), icbm, certInfo, new Date());
            if (minfo == null) {
                return;
            }
            ((Conversation)conv).handleIncomingEvent(minfo);
        } else {
            ImConversation conv = this.getImConversation(sender);
            ImMessageInfo msg = ImMessageInfo.getInstance(this.getScreenname(), icbm, new Date());
            conv.handleIncomingEvent(msg);
        }
    }

    private void handleTypingNotification(RecvTypingNotification typnot) {
        Screenname sender = new Screenname(typnot.getScreenname());
        ImConversation conv = this.getImConversation(sender);
        TypingState typingState = IcbmServiceImpl.getTypingState(typnot.getTypingState());
        if (typingState != null) {
            ((Conversation)conv).handleIncomingEvent(new TypingInfo(sender, this.getScreenname(), new Date(), typingState));
        }
    }

    @Nullable
    private static TypingState getTypingState(int typingState) {
        if (typingState == 2) {
            return TypingState.TYPING;
        }
        if (typingState == 0) {
            return TypingState.NO_TEXT;
        }
        if (typingState == 1) {
            return TypingState.PAUSED;
        }
        LOGGER.log(Level.WARNING, "Unknown typing state " + typingState);
        return null;
    }

    private static int getTypingStateCode(@NotNull TypingState typingState) {
        if (typingState == TypingState.TYPING) {
            return 2;
        }
        if (typingState == TypingState.PAUSED) {
            return 1;
        }
        if (typingState == TypingState.NO_TEXT) {
            return 0;
        }
        throw new IllegalArgumentException("no code for typing state " + (Object)((Object)typingState));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SecureAimConversation getSecureAimConversation(Screenname sn) {
        SecureAimConversation conv;
        boolean isnew = false;
        IcbmServiceImpl icbmServiceImpl = this;
        synchronized (icbmServiceImpl) {
            conv = this.secureAimConvs.get(sn);
            if (conv == null) {
                isnew = true;
                conv = InternalSecureTools.newSecureAimConversation(this.getAimConnection(), sn);
            }
        }
        if (isnew) {
            ((Conversation)conv).initialize();
            icbmServiceImpl = this;
            synchronized (icbmServiceImpl) {
                this.secureAimConvs.put(sn, conv);
            }
            this.fireNewConversationEvent(conv);
        }
        return conv;
    }

    private synchronized Set<DirectimConversation> getActualDirectimConversations(Screenname sn) {
        Set<DirectimConversation> convs = this.directimconvs.get(sn);
        if (convs == null) {
            convs = new HashSet<DirectimConversation>();
            this.directimconvs.put(sn, convs);
        }
        return convs;
    }

    @Override
    public synchronized Set<DirectimConversation> getDirectimConversations(Screenname sn) {
        return DefensiveTools.getUnmodifiableSetCopy(this.getActualDirectimConversations(sn));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImConversation getImConversation(Screenname sn) {
        ImConversation conv;
        boolean isnew = false;
        IcbmServiceImpl icbmServiceImpl = this;
        synchronized (icbmServiceImpl) {
            conv = this.imconvs.get(sn);
            if (conv == null) {
                isnew = true;
                conv = new ImConversation(this.getAimConnection(), sn);
            }
        }
        if (isnew) {
            conv.initialize();
            icbmServiceImpl = this;
            synchronized (icbmServiceImpl) {
                this.imconvs.put(sn, conv);
            }
            this.fireNewConversationEvent(conv);
        }
        return conv;
    }

    @Override
    public void sendAutomatically(Screenname sn, Message message) {
        boolean sentDirectly = this.sendDirectlyIfPossible(sn, message);
        if (!sentDirectly) {
            this.getImConversation(sn).sendMessage(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendDirectlyIfPossible(Screenname sn, Message message) {
        DirectimConversation newConv;
        IcbmServiceImpl icbmServiceImpl = this;
        synchronized (icbmServiceImpl) {
            for (DirectimConversation conv : this.getActualDirectimConversations(sn)) {
                if (conv.isClosed()) continue;
                conv.sendMessage(message);
                return true;
            }
            if (!this.supportsDirectim(sn) || !IcbmServiceImpl.mustBeDirect(message)) {
                return false;
            }
            newConv = new DirectimConversation(this.getAimConnection(), sn);
        }
        this.initializeDirectimConv(newConv);
        icbmServiceImpl = this;
        synchronized (icbmServiceImpl) {
            this.getActualDirectimConversations(sn).add(newConv);
        }
        this.fireNewConversationEvent(newConv);
        newConv.sendMessage(message);
        return true;
    }

    private boolean supportsDirectim(Screenname sn) {
        return this.getAimConnection().getBuddyInfoManager().getBuddyInfo(sn).getCapabilities().contains(CapabilityBlock.BLOCK_DIRECTIM);
    }

    private static boolean mustBeDirect(Message message) {
        return message instanceof DirectMessage || message.getMessageBody().length() > 8000;
    }

    @Override
    public void sendTypingAutomatically(Screenname sn, TypingState state) {
        boolean set = this.setTypingStatusDirectlyIfPossible(sn, state);
        if (!set) {
            this.getImConversation(sn).setTypingState(state);
        }
    }

    private boolean setTypingStatusDirectlyIfPossible(Screenname sn, TypingState state) {
        boolean setSuccessfully = false;
        for (DirectimConversation dim : this.getActualDirectimConversations(sn)) {
            if (dim.isClosed()) continue;
            if (dim.isOpen()) {
                setSuccessfully = true;
            }
            dim.setTypingState(state);
        }
        return setSuccessfully;
    }

    private void fireNewConversationEvent(Conversation conv) {
        for (IcbmListener listener : this.listeners) {
            listener.newConversation(this, conv);
        }
    }

    @Override
    public void sendIM(Screenname buddy, String body, boolean autoresponse) {
        this.sendIM(buddy, body, autoresponse, null);
    }

    @Override
    public void sendIM(Screenname buddy, String body, boolean autoresponse, SnacRequestListener listener) {
        this.sendIM(buddy, body, autoresponse, listener, false);
    }

    @Override
    public void sendIM(Screenname buddy, String body, boolean autoresponse, SnacRequestListener listener, boolean isOffline) {
        this.sendIM(buddy, new InstantMessage(body), autoresponse, listener, isOffline);
    }

    @Override
    public void sendIM(Screenname buddy, InstantMessage im, boolean autoresponse) {
        this.sendIM(buddy, im, autoresponse, null);
    }

    @Override
    public void sendIM(Screenname buddy, InstantMessage im, boolean autoresponse, SnacRequestListener listener) {
        this.sendIM(buddy, im, autoresponse, listener, false);
    }

    @Override
    public void sendIM(Screenname buddy, InstantMessage im, boolean autoresponse, SnacRequestListener listener, boolean isOffline) {
        SendImIcbm imIcbm = new SendImIcbm(buddy.getFormatted(), im, autoresponse, 0L, false, null, null, !autoresponse);
        imIcbm.setOffline(isOffline);
        this.sendSnacRequest(imIcbm, listener);
    }

    @Override
    public void sendTypingStatus(Screenname buddy, TypingState typingState) {
        DefensiveTools.checkNull((Object)typingState, "typingState");
        this.sendSnac(new SendTypingNotification(buddy.getFormatted(), IcbmServiceImpl.getTypingStateCode(typingState)));
    }

    private class SessionListenerDelegate
    implements RvSessionListener {
        private RendezvousSessionHandler sessionHandler;
        private final RvSession session;

        public SessionListenerDelegate(RvSession session) {
            this.session = session;
            this.sessionHandler = null;
        }

        public void handleRv(RecvRvEvent event) {
            if (this.sessionHandler == null) {
                RvCommand rvCommand = event.getRvCommand();
                if (rvCommand == null) {
                    LOGGER.warning("unknown rv command: " + event.getSnacCommand());
                    return;
                }
                CapabilityBlock cap = rvCommand.getCapabilityBlock();
                CapabilityHandler handler = IcbmServiceImpl.this.getAimConnection().getCapabilityManager().getCapabilityHandler(cap);
                if (handler instanceof RendezvousCapabilityHandler) {
                    RendezvousCapabilityHandler rhandler = (RendezvousCapabilityHandler)handler;
                    RendezvousSessionHandler sessionHandler = rhandler.handleSession(IcbmServiceImpl.this, this.session);
                    if (sessionHandler == null) {
                        throw new IllegalStateException("RendezvousCapabilityHandler " + rhandler + " did not return session handler for " + this.session);
                    }
                    this.sessionHandler = sessionHandler;
                } else {
                    LOGGER.warning("Rendezvous for " + cap + " ignored because the handler, " + handler + ", does not support rendezvous");
                    this.session.removeListener(this);
                    return;
                }
            }
            this.sessionHandler.handleRv(event);
        }

        public void handleSnacResponse(RvSnacResponseEvent event) {
            if (this.sessionHandler == null) {
                LOGGER.warning("Got SNAC response in RV processor listener, but no handler has been registered yet: " + event);
            } else {
                this.sessionHandler.handleSnacResponse(event);
            }
        }
    }

    private class DelegatingRvProcessorListener
    implements RvProcessorListener {
        private DelegatingRvProcessorListener() {
        }

        public void handleNewSession(NewRvSessionEvent event) {
            if (event.getSessionType() == NewRvSessionEvent.TYPE_INCOMING) {
                RvSession session = event.getSession();
                session.addListener(new SessionListenerDelegate(session));
            }
        }
    }
}

