/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvproto.ft;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.ImEncodedString;
import net.kano.joscar.ImEncodingParams;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.MiscTools;
import net.kano.joscar.logging.Logger;
import net.kano.joscar.logging.LoggingSystem;
import net.kano.joscar.rvcmd.SegmentedFilename;
import org.jetbrains.annotations.Nullable;

public final class FileTransferHeader
implements LiveWritable {
    private static final Logger LOGGER = LoggingSystem.getLogger(FileTransferHeader.class.getName());
    public static final String FTVERSION_DEFAULT = "OFT2";
    public static final int HEADERTYPE_SENDHEADER = 257;
    public static final int HEADERTYPE_ACK = 514;
    public static final int HEADERTYPE_RECEIVED = 516;
    public static final int HEADERTYPE_RESUME = 517;
    public static final int HEADERTYPE_RESUME_SENDHEADER = 262;
    public static final int HEADERTYPE_RESUME_ACK = 519;
    public static final int HEADERTYPE_FILELIST_SENDLIST = 4360;
    public static final int HEADERTYPE_FILELIST_ACK = 4617;
    public static final int HEADERTYPE_FILELIST_RECEIVED = 4619;
    public static final int HEADERTYPE_FILELIST_REQFILE = 4620;
    public static final int HEADERTYPE_FILELIST_REQDIR = 4622;
    public static final int ENCRYPTION_NONE = 0;
    public static final int COMPRESSION_NONE = 0;
    public static final String CLIENTID_OLD = "OFT_Windows ICBMFT V1.1 32";
    public static final String CLIENTID_DEFAULT = "Cool FileXfer";
    public static final int LISTNAMEOFFSET_DEFAULT = 28;
    public static final int LISTSIZEOFFSET_DEFAULT = 17;
    public static final int FLAG_DEFAULT = 32;
    public static final int FLAG_DONE = 1;
    public static final int FLAG_FILELIST = 16;
    public static final ByteBlock DUMMY_DEFAULT = ByteBlock.wrap(new byte[69]);
    public static final ByteBlock MACFILEINFO_DEFAULT = ByteBlock.wrap(new byte[16]);
    private String ftVersion = null;
    private int headerType = -1;
    private long icbmMessageId = 0L;
    private int encryption = -1;
    private int compression = -1;
    private int fileCount = -1;
    private int filesLeft = -1;
    private int partCount = -1;
    private int partsLeft = -1;
    private long totalFileSize = -1L;
    private long fileSize = -1L;
    private long lastmod = -1L;
    private long checksum = -1L;
    private long resForkReceivedChecksum = -1L;
    private long resForkSize = -1L;
    private long created = -1L;
    private long resForkChecksum = -1L;
    private long bytesReceived = -1L;
    private long receivedChecksum = -1L;
    private String clientid = null;
    private int flags = -1;
    private int listNameOffset = -1;
    private int listSizeOffset = -1;
    private ByteBlock dummyBlock = null;
    private ByteBlock macFileInfo = null;
    private SegmentedFilename filename = null;
    private int headerSize = -1;

    @Nullable
    public static FileTransferHeader readHeader(InputStream in) throws IOException {
        int count;
        int headerLen;
        int count2;
        DefensiveTools.checkNull(in, "in");
        byte[] header = new byte[6];
        for (int i = 0; i < header.length; i += count2) {
            count2 = in.read(header, i, header.length - i);
            if (count2 != -1) continue;
            if (LOGGER.logWarningEnabled()) {
                LOGGER.logWarning("EOF while reading FT mini-header after " + i + " bytes");
            }
            return null;
        }
        ByteBlock ftVerBlock = ByteBlock.wrap(header, 0, 4);
        String ftversion = BinaryTools.getAsciiString(ftVerBlock);
        if (LOGGER.logWarningEnabled() && !ftversion.equals(FTVERSION_DEFAULT)) {
            LOGGER.logWarning("Got unexpected FT version block from buddy: " + ftVerBlock);
        }
        if ((headerLen = BinaryTools.getUShort(ByteBlock.wrap(header), 4)) != 256 && LOGGER.logWarningEnabled()) {
            LOGGER.logWarning("Got header length of " + headerLen + " bytes; expected 256");
        }
        if (headerLen < 6 || headerLen > 102400) {
            return null;
        }
        byte[] bigheader = new byte[headerLen - 6];
        for (int i = 0; i < bigheader.length; i += count) {
            count = in.read(bigheader, i, bigheader.length - i);
            if (count != -1) continue;
            if (LOGGER.logWarningEnabled()) {
                LOGGER.logWarning("EOF while reading rest of FT header: read " + (6 + i) + " of " + headerLen);
            }
            return null;
        }
        FileTransferHeader fsh = new FileTransferHeader();
        fsh.setFtVersion(ftversion);
        fsh.setHeaderSize(headerLen);
        ByteBlock block = ByteBlock.wrap(bigheader);
        fsh.setHeaderType(BinaryTools.getUShort(block, 0));
        fsh.setIcbmMessageId(BinaryTools.getLong(block, 2));
        fsh.setEncryption(BinaryTools.getUShort(block, 10));
        fsh.setCompression(BinaryTools.getUShort(block, 12));
        fsh.setFileCount(BinaryTools.getUShort(block, 14));
        fsh.setFilesLeft(BinaryTools.getUShort(block, 16));
        fsh.setPartCount(BinaryTools.getUShort(block, 18));
        fsh.setPartsLeft(BinaryTools.getUShort(block, 20));
        fsh.setTotalFileSize(BinaryTools.getUInt(block, 22));
        fsh.setFileSize(BinaryTools.getUInt(block, 26));
        fsh.setLastmod(BinaryTools.getUInt(block, 30));
        fsh.setChecksum(BinaryTools.getUInt(block, 34));
        fsh.setResForkReceivedChecksum(BinaryTools.getUInt(block, 38));
        fsh.setResForkSize(BinaryTools.getUInt(block, 42));
        fsh.setCreated(BinaryTools.getUInt(block, 46));
        fsh.setResForkChecksum(BinaryTools.getUInt(block, 50));
        fsh.setBytesReceived(BinaryTools.getUInt(block, 54));
        fsh.setReceivedChecksum(BinaryTools.getUInt(block, 58));
        ByteBlock clientidBlock = block.subBlock(62, 32);
        fsh.setClientid(BinaryTools.getNullPadded(clientidBlock).getString());
        ByteBlock rest = block.subBlock(94);
        fsh.setFlags(BinaryTools.getUByte(rest, 0));
        fsh.setListNameOffset(BinaryTools.getUByte(rest, 1));
        fsh.setListSizeOffset(BinaryTools.getUByte(rest, 2));
        fsh.setDummyBlock(rest.subBlock(3, 69));
        fsh.setMacFileInfo(rest.subBlock(72, 16));
        int charset = BinaryTools.getUShort(rest, 88);
        int charsubset = BinaryTools.getUShort(rest, 90);
        ByteBlock filenameBlock = rest.subBlock(92);
        ImEncodingParams encoding = new ImEncodingParams(charset, charsubset);
        String ftFilename = ImEncodedString.readImEncodedString(encoding, filenameBlock);
        int firstNull = ftFilename.indexOf(0);
        int lastNull = ftFilename.lastIndexOf(0);
        if (firstNull != lastNull) {
            for (int i = lastNull - 1; i >= 0; --i) {
                if (ftFilename.charAt(i) == '\u0000') continue;
                firstNull = i + 1;
                break;
            }
        }
        if (firstNull != -1) {
            ftFilename = ftFilename.substring(0, firstNull);
        }
        SegmentedFilename segmented = SegmentedFilename.fromFTFilename(ftFilename);
        fsh.setFilename(segmented);
        return fsh;
    }

    public FileTransferHeader() {
    }

    public FileTransferHeader(FileTransferHeader other) {
        DefensiveTools.checkNull(other, "other");
        this.ftVersion = other.ftVersion;
        this.headerType = other.headerType;
        this.icbmMessageId = other.icbmMessageId;
        this.encryption = other.encryption;
        this.compression = other.compression;
        this.fileCount = other.fileCount;
        this.filesLeft = other.filesLeft;
        this.partCount = other.partCount;
        this.partsLeft = other.partsLeft;
        this.totalFileSize = other.totalFileSize;
        this.fileSize = other.fileSize;
        this.lastmod = other.lastmod;
        this.checksum = other.checksum;
        this.resForkReceivedChecksum = other.resForkReceivedChecksum;
        this.resForkSize = other.resForkSize;
        this.created = other.created;
        this.resForkChecksum = other.resForkChecksum;
        this.bytesReceived = other.bytesReceived;
        this.receivedChecksum = other.receivedChecksum;
        this.clientid = other.clientid;
        this.flags = other.flags;
        this.listNameOffset = other.listNameOffset;
        this.listSizeOffset = other.listSizeOffset;
        this.dummyBlock = other.dummyBlock;
        this.macFileInfo = other.macFileInfo;
        this.filename = other.filename;
    }

    public synchronized String getFtVersion() {
        return this.ftVersion;
    }

    public synchronized int getHeaderType() {
        return this.headerType;
    }

    public synchronized long getIcbmMessageId() {
        return this.icbmMessageId;
    }

    public synchronized int getEncryption() {
        return this.encryption;
    }

    public synchronized int getCompression() {
        return this.compression;
    }

    public synchronized int getFileCount() {
        return this.fileCount;
    }

    public synchronized int getFilesLeft() {
        return this.filesLeft;
    }

    public synchronized int getPartCount() {
        return this.partCount;
    }

    public synchronized int getPartsLeft() {
        return this.partsLeft;
    }

    public synchronized long getTotalFileSize() {
        return this.totalFileSize;
    }

    public synchronized long getFileSize() {
        return this.fileSize;
    }

    public synchronized long getLastmod() {
        return this.lastmod;
    }

    public synchronized long getChecksum() {
        return this.checksum;
    }

    public synchronized long getResForkReceivedChecksum() {
        return this.resForkReceivedChecksum;
    }

    public synchronized long getResForkSize() {
        return this.resForkSize;
    }

    public synchronized long getCreated() {
        return this.created;
    }

    public synchronized long getResForkChecksum() {
        return this.resForkChecksum;
    }

    public synchronized long getBytesReceived() {
        return this.bytesReceived;
    }

    public synchronized long getReceivedChecksum() {
        return this.receivedChecksum;
    }

    public synchronized String getClientid() {
        return this.clientid;
    }

    public synchronized int getFlags() {
        return this.flags;
    }

    public synchronized int getListNameOffset() {
        return this.listNameOffset;
    }

    public synchronized int getListSizeOffset() {
        return this.listSizeOffset;
    }

    public synchronized ByteBlock getDummyBlock() {
        return this.dummyBlock;
    }

    public synchronized ByteBlock getMacFileInfo() {
        return this.macFileInfo;
    }

    public synchronized SegmentedFilename getFilename() {
        return this.filename;
    }

    public synchronized int getHeaderSize() {
        return this.headerSize;
    }

    public synchronized void setFtVersion(String ftVersion) {
        this.ftVersion = ftVersion;
    }

    public synchronized void setHeaderType(int headerType) {
        this.headerType = headerType;
    }

    public synchronized void setIcbmMessageId(long icbmMessageId) {
        this.icbmMessageId = icbmMessageId;
    }

    public synchronized void setEncryption(int encryption) {
        this.encryption = encryption;
    }

    public synchronized void setCompression(int compression) {
        this.compression = compression;
    }

    public synchronized void setFileCount(int fileCount) {
        this.fileCount = fileCount;
    }

    public synchronized void setFilesLeft(int filesLeft) {
        this.filesLeft = filesLeft;
    }

    public synchronized void setPartCount(int partCount) {
        this.partCount = partCount;
    }

    public synchronized void setPartsLeft(int partsLeft) {
        this.partsLeft = partsLeft;
    }

    public synchronized void setTotalFileSize(long totalFileSize) {
        this.totalFileSize = totalFileSize;
    }

    public synchronized void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public synchronized void setLastmod(long lastmod) {
        this.lastmod = lastmod;
    }

    public synchronized void setChecksum(long checksum) {
        this.checksum = checksum;
    }

    public synchronized void setResForkReceivedChecksum(long resForkReceivedChecksum) {
        this.resForkReceivedChecksum = resForkReceivedChecksum;
    }

    public synchronized void setResForkSize(long resForkSize) {
        this.resForkSize = resForkSize;
    }

    public synchronized void setCreated(long created) {
        this.created = created;
    }

    public synchronized void setResForkChecksum(long resForkChecksum) {
        this.resForkChecksum = resForkChecksum;
    }

    public synchronized void setBytesReceived(long bytesReceived) {
        this.bytesReceived = bytesReceived;
    }

    public synchronized void setReceivedChecksum(long receivedChecksum) {
        this.receivedChecksum = receivedChecksum;
    }

    public synchronized void setClientid(String clientid) {
        this.clientid = clientid;
    }

    public synchronized void setFlags(int flags) {
        this.flags = flags;
    }

    public synchronized void setListNameOffset(int listNameOffset) {
        this.listNameOffset = listNameOffset;
    }

    public synchronized void setListSizeOffset(int listSizeOffset) {
        this.listSizeOffset = listSizeOffset;
    }

    public synchronized void setDummyBlock(ByteBlock dummyBlock) {
        this.dummyBlock = dummyBlock;
    }

    public synchronized void setMacFileInfo(ByteBlock macFileInfo) {
        this.macFileInfo = macFileInfo;
    }

    public synchronized void setFilename(SegmentedFilename filename) {
        this.filename = filename;
    }

    private synchronized void setHeaderSize(int headerSize) {
        this.headerSize = headerSize;
    }

    public final synchronized void setDefaults() {
        this.clientid = CLIENTID_DEFAULT;
        this.compression = 0;
        this.encryption = 0;
        this.icbmMessageId = 0L;
        this.dummyBlock = DUMMY_DEFAULT;
        this.flags = 32;
        this.ftVersion = FTVERSION_DEFAULT;
        this.resForkChecksum = 0L;
        this.resForkReceivedChecksum = 0L;
        this.resForkSize = 0L;
        this.created = 0L;
        this.lastmod = 0L;
        this.checksum = 0L;
        this.listNameOffset = 0;
        this.listSizeOffset = 0;
        this.macFileInfo = MACFILEINFO_DEFAULT;
        this.bytesReceived = 0L;
        this.fileCount = 0;
        this.fileSize = 0L;
        this.filesLeft = 0;
        this.partCount = 0;
        this.partsLeft = 0;
        this.receivedChecksum = 0L;
        this.totalFileSize = 0L;
    }

    private synchronized void checkValidity() throws IllegalArgumentException {
        DefensiveTools.checkNull(this.ftVersion, "ftVersion");
        DefensiveTools.checkRange(this.headerType, "headerType", 0);
        DefensiveTools.checkRange(this.encryption, "encryption", 0);
        DefensiveTools.checkRange(this.compression, "compression", 0);
        DefensiveTools.checkRange(this.fileCount, "fileCount", 0);
        DefensiveTools.checkRange(this.filesLeft, "filesLeft", 0);
        DefensiveTools.checkRange(this.partCount, "partCount", 0);
        DefensiveTools.checkRange(this.partsLeft, "partsLeft", 0);
        DefensiveTools.checkRange(this.totalFileSize, "totalFileSize", 0L);
        DefensiveTools.checkRange(this.fileSize, "fileSize", 0L);
        DefensiveTools.checkRange(this.lastmod, "lastmod", 0L);
        DefensiveTools.checkRange(this.checksum, "checksum", 0L);
        DefensiveTools.checkRange(this.resForkReceivedChecksum, "resForkReceivedChecksum", 0L);
        DefensiveTools.checkRange(this.resForkSize, "resForkSize", 0L);
        DefensiveTools.checkRange(this.created, "created", 0L);
        DefensiveTools.checkRange(this.resForkChecksum, "resForkChecksum", 0L);
        DefensiveTools.checkRange(this.bytesReceived, "bytesReceived", 0L);
        DefensiveTools.checkRange(this.receivedChecksum, "receivedChecksum", 0L);
        DefensiveTools.checkNull(this.clientid, "clientid");
        DefensiveTools.checkRange(this.flags, "flags", 0);
        DefensiveTools.checkRange(this.listNameOffset, "listNameOffset", 0);
        DefensiveTools.checkRange(this.listSizeOffset, "listSizeOffset", 0);
        DefensiveTools.checkNull(this.dummyBlock, "dummyBlock");
        DefensiveTools.checkNull(this.macFileInfo, "macFileInfo");
    }

    public synchronized void write(OutputStream out) throws IOException, IllegalArgumentException {
        DefensiveTools.checkNull(out, "out");
        this.checkValidity();
        ByteArrayOutputStream header = new ByteArrayOutputStream(300);
        BinaryTools.writeUShort(header, this.headerType);
        BinaryTools.writeLong(header, this.icbmMessageId);
        BinaryTools.writeUShort(header, this.encryption);
        BinaryTools.writeUShort(header, this.compression);
        BinaryTools.writeUShort(header, this.fileCount);
        BinaryTools.writeUShort(header, this.filesLeft);
        BinaryTools.writeUShort(header, this.partCount);
        BinaryTools.writeUShort(header, this.partsLeft);
        BinaryTools.writeUInt(header, this.totalFileSize);
        BinaryTools.writeUInt(header, this.fileSize);
        BinaryTools.writeUInt(header, this.lastmod);
        BinaryTools.writeUInt(header, this.checksum);
        BinaryTools.writeUInt(header, this.resForkReceivedChecksum);
        BinaryTools.writeUInt(header, this.resForkSize);
        BinaryTools.writeUInt(header, this.created);
        BinaryTools.writeUInt(header, this.resForkChecksum);
        BinaryTools.writeUInt(header, this.bytesReceived);
        BinaryTools.writeUInt(header, this.receivedChecksum);
        ByteBlock clientidBytes = ByteBlock.wrap(BinaryTools.getAsciiBytes(this.clientid));
        BinaryTools.writeNullPadded(header, clientidBytes, 32);
        BinaryTools.writeUByte(header, this.flags);
        BinaryTools.writeUByte(header, this.listNameOffset);
        BinaryTools.writeUByte(header, this.listSizeOffset);
        BinaryTools.writeNullPadded(header, this.dummyBlock, 69);
        BinaryTools.writeNullPadded(header, this.macFileInfo, 16);
        String filenameStr = this.filename == null ? "" : this.filename.toFTFilename();
        ImEncodedString encInfo = ImEncodedString.encodeString(filenameStr);
        ImEncodingParams encoding = encInfo.getEncoding();
        BinaryTools.writeUShort(header, encoding.getCharsetCode());
        BinaryTools.writeUShort(header, encoding.getCharsetSubcode());
        byte[] fnBytes = encInfo.getBytes();
        header.write(fnBytes);
        for (int i = fnBytes.length; i < 63; ++i) {
            header.write(0);
        }
        header.write(0);
        ByteArrayOutputStream fullBuffer = new ByteArrayOutputStream(header.size() + 6);
        fullBuffer.write(BinaryTools.getAsciiBytes(this.ftVersion));
        BinaryTools.writeUShort(fullBuffer, header.size() + 6);
        header.writeTo(fullBuffer);
        fullBuffer.writeTo(out);
    }

    public synchronized String toString() {
        return "FileTransferHeader:\n ftVersion='" + this.ftVersion + "'" + "\n headerType=0x" + Integer.toHexString(this.headerType) + " (" + MiscTools.findIntField(FileTransferHeader.class, this.headerType, "HEADERTYPE_.*") + ")" + "\n icbmMessageId=" + this.icbmMessageId + "\n encryption=" + this.encryption + "\n compression=" + this.compression + "\n fileCount=" + this.fileCount + "\n filesLeft=" + this.filesLeft + "\n partCount=" + this.partCount + "\n partsLeft=" + this.partsLeft + "\n totalSize=" + this.totalFileSize + "\n fileSize=" + this.fileSize + "\n lastmod=" + this.lastmod + "\n checksum=" + this.checksum + "\n resForkReceivedChecksum=" + this.resForkReceivedChecksum + "\n resForkSize=" + this.resForkSize + "\n created=" + this.created + "\n resForkChecksum=" + this.resForkChecksum + "\n bytesReceived=" + this.bytesReceived + "\n receivedChecksum=" + this.receivedChecksum + "\n clientid='" + this.clientid + "'" + "\n flags=0x" + Integer.toHexString(this.flags) + " (" + MiscTools.getFlagFieldsString(FileTransferHeader.class, this.flags, "FLAG_.*") + ")" + "\n listNameOffset=" + this.listNameOffset + "\n listSizeOffset=" + this.listSizeOffset + "\n macFileInfo=" + BinaryTools.describeData(this.macFileInfo) + "\n filename=" + this.filename;
    }
}

