/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvcmd.trillcrypt;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.rvcmd.trillcrypt.AbstractTrillianCryptRvCmd;
import net.kano.joscar.snaccmd.icbm.RecvRvIcbm;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;

public class TrillianCryptMsgRvCmd
extends AbstractTrillianCryptRvCmd {
    private static final int TYPE_MSG = 1010;
    private final ByteBlock encryptedMsg;

    public TrillianCryptMsgRvCmd(RecvRvIcbm icbm) {
        super(icbm);
        TlvChain chain = this.getExtraTlvs();
        Tlv encMsgTlv = chain.getLastTlv(1010);
        this.encryptedMsg = encMsgTlv == null ? null : encMsgTlv.getData();
    }

    public TrillianCryptMsgRvCmd(ByteBlock encryptedMsg) {
        super(3);
        this.encryptedMsg = encryptedMsg;
    }

    public final ByteBlock getEncryptedMsg() {
        return this.encryptedMsg;
    }

    protected void writeExtraTlvs(OutputStream out) throws IOException {
        if (this.encryptedMsg != null) {
            new Tlv(1010, this.encryptedMsg).write(out);
        }
    }

    public String toString() {
        return "TrillianEncryptMsgRvCmd: msg=" + BinaryTools.describeData(this.encryptedMsg);
    }
}

