/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.icq;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import net.java.sip.communicator.impl.protocol.icq.OperationSetServerStoredAccountInfoIcqImpl;
import net.java.sip.communicator.impl.protocol.icq.ProtocolProviderServiceIcqImpl;
import net.java.sip.communicator.service.protocol.ServerStoredDetails;
import net.java.sip.communicator.util.Logger;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.snac.SnacRequestAdapter;
import net.kano.joscar.snac.SnacResponseEvent;
import net.kano.joscar.snaccmd.icq.MetaAffiliationsInfoCmd;
import net.kano.joscar.snaccmd.icq.MetaBasicInfoCmd;
import net.kano.joscar.snaccmd.icq.MetaEmailInfoCmd;
import net.kano.joscar.snaccmd.icq.MetaFullInfoRequest;
import net.kano.joscar.snaccmd.icq.MetaHomepageCategoryInfoCmd;
import net.kano.joscar.snaccmd.icq.MetaInterestsInfoCmd;
import net.kano.joscar.snaccmd.icq.MetaMoreInfoCmd;
import net.kano.joscar.snaccmd.icq.MetaNotesInfoCmd;
import net.kano.joscar.snaccmd.icq.MetaShortInfoCmd;
import net.kano.joscar.snaccmd.icq.MetaShortInfoRequest;
import net.kano.joscar.snaccmd.icq.MetaWorkInfoCmd;

public class InfoRetreiver {
    private static final Logger logger = Logger.getLogger(InfoRetreiver.class);
    private ProtocolProviderServiceIcqImpl icqProvider = null;
    private String ownerUin = null;
    private final Map<String, List<ServerStoredDetails.GenericDetail>> retreivedDetails = new Hashtable<String, List<ServerStoredDetails.GenericDetail>>();
    private static int requestID = 0;
    private static final Map<Integer, List<ServerStoredDetails.GenericDetail>> retreivedInfo = new Hashtable<Integer, List<ServerStoredDetails.GenericDetail>>();

    protected InfoRetreiver(ProtocolProviderServiceIcqImpl icqProvider, String ownerUin) {
        this.icqProvider = icqProvider;
        this.ownerUin = ownerUin;
    }

    public <T extends ServerStoredDetails.GenericDetail> Iterator<T> getDetailsAndDescendants(String uin, Class<T> detailClass) {
        List<ServerStoredDetails.GenericDetail> details = this.getContactDetails(uin);
        LinkedList<ServerStoredDetails.GenericDetail> result = new LinkedList<ServerStoredDetails.GenericDetail>();
        for (ServerStoredDetails.GenericDetail item : details) {
            if (!detailClass.isInstance(item)) continue;
            ServerStoredDetails.GenericDetail t = item;
            result.add(t);
        }
        return result.iterator();
    }

    public Iterator<ServerStoredDetails.GenericDetail> getDetails(String uin, Class<? extends ServerStoredDetails.GenericDetail> detailClass) {
        List<ServerStoredDetails.GenericDetail> details = this.getContactDetails(uin);
        LinkedList<ServerStoredDetails.GenericDetail> result = new LinkedList<ServerStoredDetails.GenericDetail>();
        for (ServerStoredDetails.GenericDetail item : details) {
            if (!detailClass.equals(item.getClass())) continue;
            result.add(item);
        }
        return result.iterator();
    }

    protected List<ServerStoredDetails.GenericDetail> getContactDetails(String uin) {
        List<ServerStoredDetails.GenericDetail> result = this.getCachedContactDetails(uin);
        if (result == null) {
            return this.retrieveDetails(uin);
        }
        return result;
    }

    protected List<ServerStoredDetails.GenericDetail> retrieveDetails(String uin) {
        List<ServerStoredDetails.GenericDetail> result = null;
        try {
            long toICQUin = Long.parseLong(uin);
            int reqID = requestID++;
            MetaFullInfoRequest infoRequest = new MetaFullInfoRequest(Long.parseLong(this.ownerUin), reqID, toICQUin);
            UserInfoResponseRetriever responseRetriever = new UserInfoResponseRetriever(reqID);
            this.icqProvider.getAimConnection().getInfoService().getOscarConnection().sendSnacRequest(infoRequest, responseRetriever);
            responseRetriever.waitForLastInfo(60000L);
            result = responseRetriever.result;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result == null) {
            result = new LinkedList<ServerStoredDetails.GenericDetail>();
        }
        this.retreivedDetails.put(uin, result);
        return result;
    }

    protected List<ServerStoredDetails.GenericDetail> getCachedContactDetails(String uin) {
        return this.retreivedDetails.get(uin);
    }

    protected void detailsChanged(String uin) {
        this.retreivedDetails.remove(uin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNickName(String uin) {
        ShortInfoResponseRetriever responseRetriever = new ShortInfoResponseRetriever();
        long longUin = Long.parseLong(uin);
        MetaShortInfoRequest req = new MetaShortInfoRequest(Long.parseLong(this.ownerUin), 2, longUin);
        this.icqProvider.getAimConnection().getInfoService().getOscarConnection().sendSnacRequest(req, responseRetriever);
        ShortInfoResponseRetriever shortInfoResponseRetriever = responseRetriever;
        synchronized (shortInfoResponseRetriever) {
            try {
                responseRetriever.wait(30000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return responseRetriever.nickname;
    }

    private List<ServerStoredDetails.GenericDetail> getInfoForRequest(int requestID) {
        List<ServerStoredDetails.GenericDetail> res = retreivedInfo.get(requestID);
        if (res == null) {
            res = new LinkedList<ServerStoredDetails.GenericDetail>();
            retreivedInfo.put(requestID, res);
        }
        return res;
    }

    private void readBasicUserInfo(MetaBasicInfoCmd cmd) {
        List<ServerStoredDetails.GenericDetail> infoData = this.getInfoForRequest(cmd.getId());
        Locale countryCodeLocale = OperationSetServerStoredAccountInfoIcqImpl.getCountry(cmd.getCountryCode());
        if (countryCodeLocale != null) {
            infoData.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.CountryDetail(countryCodeLocale));
        }
        String tmp = null;
        tmp = cmd.getNickname();
        if (tmp != null) {
            infoData.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.NicknameDetail(tmp));
        }
        if ((tmp = cmd.getFirstName()) != null) {
            infoData.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.FirstNameDetail(tmp));
        }
        if ((tmp = cmd.getLastName()) != null) {
            infoData.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.LastNameDetail(tmp));
        }
        if ((tmp = cmd.getEmail()) != null) {
            infoData.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.EmailAddressDetail(tmp));
        }
        if ((tmp = cmd.getHomeCity()) != null) {
            infoData.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.CityDetail(tmp));
        }
        if ((tmp = cmd.getHomeState()) != null) {
            infoData.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.ProvinceDetail(tmp));
        }
        if ((tmp = cmd.getHomePhone()) != null) {
            infoData.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.PhoneNumberDetail(tmp));
        }
        if ((tmp = cmd.getHomeFax()) != null) {
            infoData.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.FaxDetail(tmp));
        }
        if ((tmp = cmd.getHomeAddress()) != null) {
            infoData.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.AddressDetail(tmp));
        }
        if ((tmp = cmd.getCellPhone()) != null) {
            infoData.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.MobilePhoneDetail(tmp));
        }
        if ((tmp = cmd.getHomeZip()) != null) {
            infoData.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.PostalCodeDetail(tmp));
        }
    }

    private void readMoreUserInfo(MetaMoreInfoCmd cmd) {
        Locale originCountryLocale;
        Locale spokenLanguage3;
        Locale spokenLanguage2;
        List<ServerStoredDetails.GenericDetail> infoData = this.getInfoForRequest(cmd.getId());
        ServerStoredDetails.GenderDetail gender = OperationSetServerStoredAccountInfoIcqImpl.genders[cmd.getGender()];
        if (gender != null) {
            infoData.add((ServerStoredDetails.GenericDetail)gender);
        }
        String tmp = null;
        try {
            tmp = cmd.getHomepage();
            if (tmp != null) {
                infoData.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.WebPageDetail(new URL(tmp)));
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        Calendar birthDate = Calendar.getInstance();
        birthDate.setTime(cmd.getBirthDate());
        infoData.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.BirthDateDetail(birthDate));
        Locale spokenLanguage1 = OperationSetServerStoredAccountInfoIcqImpl.getSpokenLanguage(cmd.getSpeakingLanguages()[0]);
        if (spokenLanguage1 != null) {
            infoData.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.SpokenLanguageDetail(spokenLanguage1));
        }
        if ((spokenLanguage2 = OperationSetServerStoredAccountInfoIcqImpl.getSpokenLanguage(cmd.getSpeakingLanguages()[1])) != null) {
            infoData.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.SpokenLanguageDetail(spokenLanguage2));
        }
        if ((spokenLanguage3 = OperationSetServerStoredAccountInfoIcqImpl.getSpokenLanguage(cmd.getSpeakingLanguages()[2])) != null) {
            infoData.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.SpokenLanguageDetail(spokenLanguage3));
        }
        if ((tmp = cmd.getOriginalCity()) != null) {
            infoData.add((ServerStoredDetails.GenericDetail)new OperationSetServerStoredAccountInfoIcqImpl.OriginCityDetail(tmp));
        }
        if ((tmp = cmd.getOriginalState()) != null) {
            infoData.add((ServerStoredDetails.GenericDetail)new OperationSetServerStoredAccountInfoIcqImpl.OriginProvinceDetail(tmp));
        }
        if ((originCountryLocale = OperationSetServerStoredAccountInfoIcqImpl.getCountry(cmd.getOriginalCountryCode())) != null) {
            infoData.add((ServerStoredDetails.GenericDetail)new OperationSetServerStoredAccountInfoIcqImpl.OriginCountryDetail(originCountryLocale));
        }
        int userGMTOffset = cmd.getTimeZone();
        TimeZone userTimeZone = null;
        userTimeZone = userGMTOffset >= 0 ? TimeZone.getTimeZone("GMT+" + userGMTOffset) : TimeZone.getTimeZone("GMT" + userGMTOffset);
        infoData.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.TimeZoneDetail("GMT Offest", userTimeZone));
    }

    private void readEmailUserInfo(MetaEmailInfoCmd cmd) {
        List<ServerStoredDetails.GenericDetail> infoData = this.getInfoForRequest(cmd.getId());
        String[] emails = cmd.getEmails();
        if (emails == null) {
            return;
        }
        for (String email : emails) {
            infoData.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.EmailAddressDetail(email));
        }
    }

    private void readHomePageUserInfo(MetaHomepageCategoryInfoCmd cmd) {
        List<ServerStoredDetails.GenericDetail> infoData = this.getInfoForRequest(cmd.getId());
        String tmp = null;
        try {
            tmp = cmd.getKeywords();
            if (tmp != null) {
                infoData.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.WebPageDetail(new URL(tmp)));
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private void readWorkUserInfo(MetaWorkInfoCmd cmd) {
        int workOccupationCode;
        Locale workCountry;
        List<ServerStoredDetails.GenericDetail> infoData = this.getInfoForRequest(cmd.getId());
        String tmp = null;
        tmp = cmd.getWorkCity();
        if (tmp != null) {
            infoData.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.WorkCityDetail(tmp));
        }
        if ((tmp = cmd.getWorkState()) != null) {
            infoData.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.WorkProvinceDetail(tmp));
        }
        if ((tmp = cmd.getWorkPhone()) != null) {
            infoData.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.WorkPhoneDetail(tmp));
        }
        if ((tmp = cmd.getWorkFax()) != null) {
            infoData.add((ServerStoredDetails.GenericDetail)new OperationSetServerStoredAccountInfoIcqImpl.WorkFaxDetail(tmp));
        }
        if ((tmp = cmd.getWorkAddress()) != null) {
            infoData.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.WorkAddressDetail(tmp));
        }
        if ((tmp = cmd.getWorkZipCode()) != null) {
            infoData.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.WorkPostalCodeDetail(tmp));
        }
        if ((workCountry = OperationSetServerStoredAccountInfoIcqImpl.getCountry(cmd.getWorkCountryCode())) != null) {
            infoData.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.WorkCountryDetail(workCountry));
        }
        if ((tmp = cmd.getWorkCompany()) != null) {
            infoData.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.WorkOrganizationNameDetail(tmp));
        }
        if ((tmp = cmd.getWorkDepartment()) != null) {
            infoData.add((ServerStoredDetails.GenericDetail)new OperationSetServerStoredAccountInfoIcqImpl.WorkDepartmentNameDetail(tmp));
        }
        if ((tmp = cmd.getWorkPosition()) != null) {
            infoData.add((ServerStoredDetails.GenericDetail)new OperationSetServerStoredAccountInfoIcqImpl.WorkPositionNameDetail(tmp));
        }
        if ((workOccupationCode = cmd.getWorkOccupationCode()) == 99) {
            infoData.add((ServerStoredDetails.GenericDetail)new OperationSetServerStoredAccountInfoIcqImpl.WorkOcupationDetail(OperationSetServerStoredAccountInfoIcqImpl.occupations[OperationSetServerStoredAccountInfoIcqImpl.occupations.length - 1]));
        } else {
            infoData.add((ServerStoredDetails.GenericDetail)new OperationSetServerStoredAccountInfoIcqImpl.WorkOcupationDetail(OperationSetServerStoredAccountInfoIcqImpl.occupations[workOccupationCode]));
        }
        try {
            tmp = cmd.getWorkWebPage();
            if (tmp != null) {
                infoData.add((ServerStoredDetails.GenericDetail)new ServerStoredDetails.WorkPageDetail(new URL(tmp)));
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private void readUserAboutInfo(MetaNotesInfoCmd cmd) {
        List<ServerStoredDetails.GenericDetail> infoData = this.getInfoForRequest(cmd.getId());
        if (cmd.getNotes() != null) {
            infoData.add((ServerStoredDetails.GenericDetail)new OperationSetServerStoredAccountInfoIcqImpl.NotesDetail(cmd.getNotes()));
        }
    }

    private void readInterestsUserInfo(MetaInterestsInfoCmd cmd) {
        List<ServerStoredDetails.GenericDetail> infoData = this.getInfoForRequest(cmd.getId());
        int[] categories = cmd.getCategories();
        String[] interests = cmd.getInterests();
        for (int i = 0; i < interests.length; ++i) {
            int category = categories[i];
            if (category != 0) {
                category -= 99;
            }
            if (category > interests.length) continue;
            infoData.add((ServerStoredDetails.GenericDetail)new OperationSetServerStoredAccountInfoIcqImpl.InterestDetail(interests[i], OperationSetServerStoredAccountInfoIcqImpl.interestsCategories[category]));
        }
    }

    private void readAffilationsUserInfo(MetaAffiliationsInfoCmd cmd) {
    }

    private static class ShortInfoResponseRetriever
    extends SnacRequestAdapter {
        String nickname = null;

        private ShortInfoResponseRetriever() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleResponse(SnacResponseEvent e) {
            SnacCommand snac = e.getSnacCommand();
            if (snac instanceof MetaShortInfoCmd) {
                MetaShortInfoCmd infoSnac = (MetaShortInfoCmd)snac;
                this.nickname = infoSnac.getNickname();
                ShortInfoResponseRetriever shortInfoResponseRetriever = this;
                synchronized (shortInfoResponseRetriever) {
                    this.notifyAll();
                }
            }
        }
    }

    private class UserInfoResponseRetriever
    extends SnacRequestAdapter {
        private final int requestID;
        List<ServerStoredDetails.GenericDetail> result = null;

        UserInfoResponseRetriever(int requestID) {
            this.requestID = requestID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleResponse(SnacResponseEvent e) {
            SnacCommand snac = e.getSnacCommand();
            if (snac instanceof MetaBasicInfoCmd) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"received basic info");
                }
                InfoRetreiver.this.readBasicUserInfo((MetaBasicInfoCmd)snac);
            } else if (snac instanceof MetaMoreInfoCmd) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"received meta more info");
                }
                InfoRetreiver.this.readMoreUserInfo((MetaMoreInfoCmd)snac);
            } else if (snac instanceof MetaEmailInfoCmd) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"received email info");
                }
                InfoRetreiver.this.readEmailUserInfo((MetaEmailInfoCmd)snac);
            } else if (snac instanceof MetaHomepageCategoryInfoCmd) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"received home page info");
                }
                InfoRetreiver.this.readHomePageUserInfo((MetaHomepageCategoryInfoCmd)snac);
            } else if (snac instanceof MetaWorkInfoCmd) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"received work info");
                }
                InfoRetreiver.this.readWorkUserInfo((MetaWorkInfoCmd)snac);
            } else if (snac instanceof MetaNotesInfoCmd) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"received notes info");
                }
                InfoRetreiver.this.readUserAboutInfo((MetaNotesInfoCmd)snac);
            } else if (snac instanceof MetaInterestsInfoCmd) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"received interest info");
                }
                InfoRetreiver.this.readInterestsUserInfo((MetaInterestsInfoCmd)snac);
            } else if (snac instanceof MetaAffiliationsInfoCmd) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"received affiliations info");
                }
                InfoRetreiver.this.readAffilationsUserInfo((MetaAffiliationsInfoCmd)snac);
                this.result = InfoRetreiver.this.getInfoForRequest(((MetaAffiliationsInfoCmd)snac).getId());
                UserInfoResponseRetriever userInfoResponseRetriever = this;
                synchronized (userInfoResponseRetriever) {
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForLastInfo(long waitFor) {
            UserInfoResponseRetriever userInfoResponseRetriever = this;
            synchronized (userInfoResponseRetriever) {
                block5: {
                    try {
                        this.wait(waitFor);
                    }
                    catch (InterruptedException ex) {
                        if (!logger.isDebugEnabled()) break block5;
                        logger.debug((Object)"Interrupted while waiting for a subscription evt", (Throwable)ex);
                    }
                }
            }
        }
    }
}

