/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.irc;

import java.util.ArrayList;
import java.util.List;
import net.java.sip.communicator.impl.protocol.irc.Mode;

public class ModeParser {
    private final List<ModeEntry> modes = new ArrayList<ModeEntry>();
    private int index = 0;
    private String[] params;

    protected ModeParser(String modestring) {
        String[] parts = modestring.split(" ");
        String mode = parts[0];
        this.params = new String[parts.length - 1];
        System.arraycopy(parts, 1, this.params, 0, parts.length - 1);
        this.parse(mode);
    }

    private void parse(String modestring) {
        Boolean addition = null;
        block6: for (char c : modestring.toCharArray()) {
            switch (c) {
                case '+': {
                    addition = true;
                    continue block6;
                }
                case '-': {
                    addition = false;
                    continue block6;
                }
                default: {
                    if (addition == null) {
                        throw new IllegalStateException("expect modifier (+ or -) first");
                    }
                    try {
                        ModeEntry entry = this.process(addition, c);
                        this.modes.add(entry);
                        continue block6;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        throw new IllegalArgumentException("invalid mode string provided: parameter missing", e);
                    }
                }
            }
        }
    }

    private ModeEntry process(boolean add, char mode) {
        switch (mode) {
            case 'O': {
                return new ModeEntry(add, Mode.OWNER, new String[]{this.params[this.index++]});
            }
            case 'o': {
                return new ModeEntry(add, Mode.OPERATOR, new String[]{this.params[this.index++]});
            }
            case 'v': {
                return new ModeEntry(add, Mode.VOICE, new String[]{this.params[this.index++]});
            }
            case 'l': {
                String[] limitparams = add ? new String[]{this.params[this.index++]} : new String[]{};
                return new ModeEntry(add, Mode.LIMIT, limitparams);
            }
            case 'p': {
                return new ModeEntry(add, Mode.PRIVATE, new String[0]);
            }
            case 's': {
                return new ModeEntry(add, Mode.SECRET, new String[0]);
            }
            case 'i': {
                return new ModeEntry(add, Mode.INVITE, new String[0]);
            }
            case 'b': {
                return new ModeEntry(add, Mode.BAN, new String[]{this.params[this.index++]});
            }
        }
        return new ModeEntry(add, Mode.UNKNOWN, new String[]{"" + mode});
    }

    public List<ModeEntry> getModes() {
        return this.modes;
    }

    public static final class ModeEntry {
        private final boolean added;
        private final Mode mode;
        private final String[] params;

        private ModeEntry(boolean add, Mode mode, String ... params) {
            this.added = add;
            this.mode = mode;
            this.params = params;
        }

        public boolean isAdded() {
            return this.added;
        }

        public Mode getMode() {
            return this.mode;
        }

        public String[] getParams() {
            return this.params;
        }
    }
}

