/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.irc;

import java.util.Map;
import net.java.sip.communicator.service.protocol.AccountID;

public class IrcAccountID
extends AccountID {
    private final String host;
    private final int port;

    IrcAccountID(String userID, String host, String port, Map<String, String> accountProperties) {
        super(userID, accountProperties, "IRC", IrcAccountID.getServiceName(accountProperties));
        if (host == null) {
            throw new IllegalArgumentException("host cannot be null");
        }
        this.host = host;
        if (port == null) {
            throw new IllegalArgumentException("port cannot be null");
        }
        this.port = Integer.parseInt(port);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.host.hashCode();
        result = 31 * result + this.port;
        return result;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.host.equals(((IrcAccountID)((Object)obj)).host) && this.port == ((IrcAccountID)((Object)obj)).port;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    private static String getServiceName(Map<String, String> accountProperties) {
        String port;
        String serviceName = accountProperties.get("SERVER_ADDRESS");
        if (serviceName != null && (port = accountProperties.get("SERVER_PORT")) != null) {
            serviceName = serviceName + ":" + port;
        }
        return serviceName == null ? "IRC" : serviceName;
    }

    public String getDisplayName() {
        String key = "ACCOUNT_DISPLAY_NAME";
        String accountDisplayName = (String)this.accountProperties.get(key);
        if (accountDisplayName != null && !accountDisplayName.isEmpty()) {
            return accountDisplayName;
        }
        return String.format("%s@%s:%s (%s)", this.getUserID(), this.host, this.port, this.getProtocolName());
    }
}

