/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.snaccmd.AbstractChatInfo;
import net.kano.joscar.snaccmd.MiniRoomInfo;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

public final class FullRoomInfo
extends AbstractChatInfo
implements LiveWritable {
    public static final int INSTANCE_LAST = 65535;
    private static final int TYPE_ROOM_NAME = 106;
    private static final int CODE_DEFAULT = 0;
    private MiniRoomInfo mini = null;
    private final int exchange;
    private final String cookie;
    private final int instance;
    private final int type;
    private final int code;
    private final String roomName;

    public static FullRoomInfo readRoomInfo(ByteBlock block) {
        return new FullRoomInfo(block);
    }

    private FullRoomInfo(ByteBlock block) {
        DefensiveTools.checkNull(block, "block");
        this.mini = MiniRoomInfo.readMiniRoomInfo(block);
        this.exchange = this.mini.getExchange();
        this.cookie = this.mini.getCookie();
        this.instance = this.mini.getInstance();
        ByteBlock rest = block.subBlock(this.mini.getTotalSize());
        this.type = BinaryTools.getUByte(rest, 0);
        this.code = BinaryTools.getUShort(rest, 1);
        ByteBlock roomBlock = rest.subBlock(3);
        ImmutableTlvChain chain = TlvTools.readChain(roomBlock);
        this.roomName = chain.getString(106);
        this.readBaseInfo(chain);
    }

    public FullRoomInfo(int exchange, String name) {
        this(exchange, name, "us-ascii", Locale.getDefault().getLanguage());
    }

    public FullRoomInfo(int exchange, String name, String charset1, String language1) {
        this(exchange, name, charset1, language1, null);
    }

    public FullRoomInfo(int exchange, String name, String charset1, String language1, String contentType) {
        super(name, charset1, language1, contentType);
        DefensiveTools.checkRange(exchange, "exchange", 0);
        this.exchange = exchange;
        this.cookie = "create";
        this.instance = 65535;
        this.type = 1;
        this.code = 0;
        this.roomName = null;
    }

    public final int getExchange() {
        return this.exchange;
    }

    public final String getCookie() {
        return this.cookie;
    }

    public final int getInstance() {
        return this.instance;
    }

    public final int getType() {
        return this.type;
    }

    public final String getRoomName() {
        return this.roomName;
    }

    public void write(OutputStream out) throws IOException {
        if (this.mini == null) {
            this.mini = new MiniRoomInfo(this);
        }
        this.mini.write(out);
        BinaryTools.writeUByte(out, this.type);
        BinaryTools.writeUShort(out, this.code);
        this.writeBaseInfo(out);
        if (this.roomName != null) {
            Tlv.getStringInstance(106, this.roomName).write(out);
        }
    }

    public String toString() {
        return "FullRoomInfo: " + this.roomName + " on ex." + this.exchange + ", instance=" + this.instance + ", cookie=" + this.cookie + ", type=" + this.type + " - " + super.toString();
    }
}

