/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol.event;

import java.util.EventObject;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactGroup;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;

public class SubscriptionEvent
extends EventObject {
    private static final long serialVersionUID = 0L;
    private int eventID = -1;
    public static final int SUBSCRIPTION_CREATED = 1;
    public static final int SUBSCRIPTION_REMOVED = 2;
    public static final int SUBSCRIPTION_FAILED = 3;
    public static final int SUBSCRIPTION_RESOLVED = 4;
    public static final int ERROR_UNSPECIFIED = -1;
    private ProtocolProviderService sourceProvider = null;
    private ContactGroup parentGroup = null;
    private int errorCode = -1;
    private String errorReason = null;

    public SubscriptionEvent(Contact source, ProtocolProviderService provider, ContactGroup parentGroup, int eventID) {
        this(source, provider, parentGroup, eventID, -1, null);
    }

    public SubscriptionEvent(Contact source, ProtocolProviderService provider, ContactGroup parentGroup, int eventID, int errorCode, String errorReason) {
        super(source);
        this.sourceProvider = provider;
        this.parentGroup = parentGroup;
        this.eventID = eventID;
        this.errorCode = errorCode;
        this.errorReason = errorReason;
    }

    public ProtocolProviderService getSourceProvider() {
        return this.sourceProvider;
    }

    public Contact getSourceContact() {
        return (Contact)this.getSource();
    }

    public ContactGroup getParentGroup() {
        return this.parentGroup;
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer("SubscriptionEvent-[ ContactID=");
        buff.append(this.getSourceContact().getAddress());
        buff.append(", eventID=").append(this.getEventID());
        if (this.getParentGroup() != null) {
            buff.append(", ParentGroup=").append(this.getParentGroup().getGroupName());
        }
        return buff.toString();
    }

    public int getEventID() {
        return this.eventID;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorReason() {
        return this.errorReason;
    }
}

