/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.jabberaccregwizz;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.jabberaccregwizz.JabberAccRegWizzActivator;
import net.java.sip.communicator.plugin.jabberaccregwizz.Resources;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.fileaccess.FileAccessService;
import org.jitsi.util.xml.XMLUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class JabberServerChooserDialog
extends SIPCommDialog
implements ListSelectionListener {
    private static final long serialVersionUID = 0L;
    private static final Logger logger = Logger.getLogger(JabberServerChooserDialog.class);
    private JTable serversTable;
    private JTextArea chooseArea = new JTextArea(Resources.getString("plugin.jabberaccregwizz.CHOOSE_SERVER_TEXT"));
    private JPanel mainPanel = new TransparentPanel((LayoutManager)new BorderLayout());
    private JPanel buttonPanel = new TransparentPanel((LayoutManager)new FlowLayout(2));
    private Box buttonBox = new Box(0);
    private JPanel chooseAreaPanel = new TransparentPanel((LayoutManager)new BorderLayout());
    private JPanel westPanel = new TransparentPanel((LayoutManager)new BorderLayout(10, 10));
    private JPanel eastPanel = new TransparentPanel((LayoutManager)new BorderLayout(10, 10));
    private JLabel westIconLabel = new JLabel();
    private JButton okButton = new JButton(Resources.getString("service.gui.OK"));
    private JButton cancelButton = new JButton(Resources.getString("service.gui.CANCEL"));
    private Vector<String> servers = new Vector();
    private FileAccessService faService = null;
    private String[] columnNames = new String[]{Resources.getString("plugin.jabberaccregwizz.SERVER_COLUMN"), Resources.getString("plugin.jabberaccregwizz.COMMENT_COLUMN")};
    public boolean isOK = false;
    public String serverSelected;

    public JabberServerChooserDialog() {
        this.setSize(new Dimension(550, 450));
        this.setDefaultCloseOperation(2);
        this.setTitle(Resources.getString("plugin.jabberaccregwizz.CHOOSE_SERVER_TITLE"));
        this.setModal(true);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(screenSize.width / 2 - this.getWidth() / 2, screenSize.height / 2 - this.getHeight() / 2);
        this.init();
    }

    private void init() {
        this.chooseArea.setEditable(false);
        this.chooseArea.setOpaque(false);
        this.chooseArea.setLineWrap(true);
        this.chooseArea.setWrapStyleWord(true);
        this.chooseAreaPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 10));
        this.chooseAreaPanel.add((Component)this.chooseArea, "North");
        this.eastPanel.add((Component)this.chooseAreaPanel, "North");
        this.westIconLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20), BorderFactory.createTitledBorder("")));
        try {
            this.westIconLabel.setIcon(new ImageIcon(ImageIO.read(new ByteArrayInputStream(Resources.getImage(Resources.PAGE_IMAGE)))));
        }
        catch (IOException e) {
            logger.error((Object)"Could not read image.", (Throwable)e);
        }
        this.westPanel.add((Component)this.westIconLabel, "North");
        this.mainPanel.add((Component)this.westPanel, "West");
        this.serversTable = new JTable(new ServerChooserTableModel());
        this.serversTable.setRowHeight(22);
        this.serversTable.getSelectionModel().addListSelectionListener(this);
        this.serversTable.setSelectionMode(0);
        this.serversTable.setPreferredScrollableViewportSize(new Dimension(500, 70));
        this.fillTable();
        JScrollPane scrollPane = new JScrollPane(this.serversTable);
        this.eastPanel.add((Component)scrollPane, "Center");
        this.okButton.setMnemonic(Resources.getMnemonic("service.gui.OK"));
        this.okButton.setEnabled(false);
        this.cancelButton.setMnemonic(Resources.getMnemonic("service.gui.CANCEL"));
        this.buttonBox.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
        this.buttonBox.add(this.okButton);
        this.buttonBox.add(Box.createHorizontalStrut(10));
        this.buttonBox.add(this.cancelButton);
        this.buttonPanel.add(this.buttonBox);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JabberServerChooserDialog.this.isOK = true;
                JabberServerChooserDialog.this.dispose();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JabberServerChooserDialog.this.dispose();
            }
        });
        this.mainPanel.add((Component)this.eastPanel, "Center");
        this.mainPanel.add((Component)this.buttonPanel, "South");
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillTable() {
        BundleContext bc = JabberAccRegWizzActivator.bundleContext;
        ServiceReference faServiceReference = bc.getServiceReference(FileAccessService.class.getName());
        this.faService = (FileAccessService)bc.getService(faServiceReference);
        File localServersListFile = null;
        try {
            localServersListFile = this.faService.getTemporaryFile();
            URL file = new URL("https://xmpp.net/services.php");
            try (InputStream stream = file.openStream();){
                byte[] buf = new byte[2048];
                if (stream.available() > 0) {
                    int len;
                    FileOutputStream fos = new FileOutputStream(localServersListFile);
                    while ((len = stream.read(buf)) > 0) {
                        fos.write(buf, 0, len);
                    }
                    fos.close();
                }
            }
            FileInputStream fis = new FileInputStream(localServersListFile);
            DocumentBuilder constructor = XMLUtils.newDocumentBuilderFactory().newDocumentBuilder();
            Document document = constructor.parse(fis);
            Element root = document.getDocumentElement();
            NodeList list = root.getElementsByTagName("item");
            for (int i = 0; i < list.getLength(); ++i) {
                Element e = (Element)list.item(i);
                this.servers.add(new String(e.getAttribute("jid")));
            }
            fis.close();
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get a reference to the Jabber servers list file.", (Throwable)e);
        }
        finally {
            if (localServersListFile != null) {
                localServersListFile.delete();
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int row = this.serversTable.getSelectedRow();
        if (row != -1) {
            this.okButton.setEnabled(true);
            this.serverSelected = (String)this.serversTable.getValueAt(row, 0);
        } else {
            this.okButton.setEnabled(false);
        }
    }

    protected void close(boolean isEscaped) {
        this.cancelButton.doClick();
    }

    private class ServerChooserTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 0L;
        private Document serverComments;
        private NodeList commentsList;

        public ServerChooserTableModel() {
            try {
                this.serverComments = XMLUtils.newDocumentBuilderFactory().newDocumentBuilder().parse(Resources.getPropertyInputStream("plugin.jabberaccregwizz.SERVER_COMMENTS"));
            }
            catch (SAXException e) {
                logger.error((Object)"Failed to parse server comments.", (Throwable)e);
            }
            catch (ParserConfigurationException e) {
                logger.error((Object)"Failed to parse server comments.", (Throwable)e);
            }
            catch (IOException e) {
                logger.error((Object)"Failed to parse server comments.", (Throwable)e);
            }
            Element root = this.serverComments.getDocumentElement();
            this.commentsList = root.getElementsByTagName("item");
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return JabberServerChooserDialog.this.servers.size();
        }

        @Override
        public String getColumnName(int col) {
            return JabberServerChooserDialog.this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            int i;
            String commentString = new String("");
            if (col == 0) {
                return JabberServerChooserDialog.this.servers.get(row);
            }
            Element e = (Element)this.commentsList.item(i);
            for (i = 0; i < this.commentsList.getLength() && !e.getAttribute("jid").equals(JabberServerChooserDialog.this.servers.get(row)); ++i) {
                e = (Element)this.commentsList.item(i);
            }
            if (e.getAttribute("jid").equals(JabberServerChooserDialog.this.servers.get(row))) {
                commentString = e.getAttribute("comment");
            }
            return commentString;
        }
    }
}

